/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseConnectionString {
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="service")
    private final String service;
    @JsonProperty(value="protocol")
    private final Protocol protocol;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().hostname(this.hostname).port(this.port).service(this.service).protocol(this.protocol);
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getService() {
        return this.service;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseConnectionString)) {
            return false;
        }
        DatabaseConnectionString other = (DatabaseConnectionString)o;
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$service = this.getService();
        String other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        Protocol this$protocol = this.getProtocol();
        Protocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !((Object)((Object)this$protocol)).equals((Object)other$protocol)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        Protocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : ((Object)((Object)$protocol)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "DatabaseConnectionString(hostname=" + this.getHostname() + ", port=" + this.getPort() + ", service=" + this.getService() + ", protocol=" + (Object)((Object)this.getProtocol()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"hostname", "port", "service", "protocol"})
    @Deprecated
    public DatabaseConnectionString(String hostname, Integer port, String service, Protocol protocol) {
        this.hostname = hostname;
        this.port = port;
        this.service = service;
        this.protocol = protocol;
    }

    public static enum Protocol {
        Tcp("TCP"),
        Tcps("TCPS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Protocol> map;

        private Protocol(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Protocol create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Protocol', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Protocol.class);
            map = new HashMap<String, Protocol>();
            for (Protocol v : Protocol.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="service")
        private String service;
        @JsonProperty(value="protocol")
        private Protocol protocol;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            this.__explicitlySet__.add("service");
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public DatabaseConnectionString build() {
            DatabaseConnectionString __instance__ = new DatabaseConnectionString(this.hostname, this.port, this.service, this.protocol);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(DatabaseConnectionString o) {
            Builder copiedBuilder = this.hostname(o.getHostname()).port(o.getPort()).service(o.getService()).protocol(o.getProtocol());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "DatabaseConnectionString.Builder(hostname=" + this.hostname + ", port=" + this.port + ", service=" + this.service + ", protocol=" + (Object)((Object)this.protocol) + ")";
        }
    }
}

