/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.params.ParameterizedTestMethodContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.StringUtils;

class ParameterizedTestNameFormatter {
    private final String pattern;
    private final String displayName;
    private final ParameterizedTestMethodContext methodContext;

    ParameterizedTestNameFormatter(String pattern, String displayName, ParameterizedTestMethodContext methodContext) {
        this.pattern = pattern;
        this.displayName = displayName;
        this.methodContext = methodContext;
    }

    String format(int invocationIndex, Object ... arguments) {
        try {
            return this.formatSafely(invocationIndex, arguments);
        }
        catch (Exception ex) {
            String message = "The display name pattern defined for the parameterized test is invalid. See nested exception for further details.";
            throw new JUnitException(message, (Throwable)ex);
        }
    }

    private String formatSafely(int invocationIndex, Object[] arguments) {
        String pattern = this.prepareMessageFormatPattern(invocationIndex, arguments);
        MessageFormat format = new MessageFormat(pattern);
        Object[] humanReadableArguments = this.makeReadable(format, arguments);
        return format.format(humanReadableArguments);
    }

    private String prepareMessageFormatPattern(int invocationIndex, Object[] arguments) {
        String result = this.pattern.replace("{displayName}", this.displayName).replace("{index}", String.valueOf(invocationIndex));
        if (result.contains("{argumentsWithNames}")) {
            result = result.replace("{argumentsWithNames}", this.argumentsWithNamesPattern(arguments));
        }
        if (result.contains("{arguments}")) {
            result = result.replace("{arguments}", this.argumentsPattern(arguments));
        }
        return result;
    }

    private String argumentsWithNamesPattern(Object[] arguments) {
        return IntStream.range(0, arguments.length).mapToObj(index -> this.methodContext.getParameterName(index).map(name -> name + "=").orElse("") + "{" + index + "}").collect(Collectors.joining(", "));
    }

    private String argumentsPattern(Object[] arguments) {
        return IntStream.range(0, arguments.length).mapToObj(index -> "{" + index + "}").collect(Collectors.joining(", "));
    }

    private Object[] makeReadable(MessageFormat format, Object[] arguments) {
        Format[] formats = format.getFormatsByArgumentIndex();
        Object[] result = Arrays.copyOf(arguments, Math.min(arguments.length, formats.length), Object[].class);
        for (int i = 0; i < result.length; ++i) {
            if (formats[i] != null) continue;
            result[i] = StringUtils.nullSafeToString((Object)arguments[i]);
        }
        return result;
    }
}

