/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.jpqleditor.lexer;

import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.j2ee.persistence.jpqleditor.lexer.JPQLTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class JPQLLexer
implements Lexer<JPQLTokenId> {
    private LexerRestartInfo<JPQLTokenId> info;
    private static final int EOF = -1;
    private final LexerInput input;
    private final TokenFactory<JPQLTokenId> tokenFactory;

    JPQLLexer(LexerRestartInfo<JPQLTokenId> info) {
        this.info = info;
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
    }

    public Token<JPQLTokenId> nextToken() {
        int c = this.input.read();
        JPQLTokenId lookupId = null;
        switch (c) {
            case 34: {
                if (lookupId == null) {
                    lookupId = JPQLTokenId.STRING_LITERAL;
                }
                while (true) {
                    switch (this.input.read()) {
                        case 34: {
                            return this.token(lookupId);
                        }
                        case 92: {
                            this.input.read();
                            break;
                        }
                        case 13: {
                            this.input.consumeNewline();
                        }
                        case -1: 
                        case 10: {
                            return this.tokenFactory.createToken((TokenId)lookupId, this.input.readLength(), PartType.START);
                        }
                    }
                }
            }
            case 39: {
                if (lookupId == null) {
                    lookupId = JPQLTokenId.STRING_LITERAL;
                }
                while (true) {
                    switch (this.input.read()) {
                        case 39: {
                            return this.token(lookupId);
                        }
                        case 92: {
                            this.input.read();
                            break;
                        }
                        case 13: {
                            this.input.consumeNewline();
                        }
                        case -1: 
                        case 10: {
                            return this.tokenFactory.createToken((TokenId)lookupId, this.input.readLength(), PartType.START);
                        }
                    }
                }
            }
            case 62: {
                switch (this.input.read()) {
                    case 61: {
                        return this.token(JPQLTokenId.GTEQ);
                    }
                }
                this.input.backup(1);
                return this.token(JPQLTokenId.GT);
            }
            case 60: {
                switch (this.input.read()) {
                    case 61: {
                        return this.token(JPQLTokenId.LTEQ);
                    }
                }
                this.input.backup(1);
                return this.token(JPQLTokenId.LT);
            }
            case 43: {
                switch (this.input.read()) {
                    case 61: {
                        return this.token(JPQLTokenId.PLUSEQ);
                    }
                }
                this.input.backup(1);
                return this.token(JPQLTokenId.PLUS);
            }
            case 45: {
                switch (this.input.read()) {
                    case 61: {
                        return this.token(JPQLTokenId.MINUSEQ);
                    }
                }
                this.input.backup(1);
                return this.token(JPQLTokenId.MINUS);
            }
            case 38: {
                switch (this.input.read()) {
                    case 38: {
                        return this.token(JPQLTokenId.AMPAMP);
                    }
                }
                this.input.backup(1);
                return this.token(JPQLTokenId.AMP);
            }
            case 46: {
                c = this.input.read();
                if (c == 46) {
                    if (this.input.read() == 46) {
                        return this.token(JPQLTokenId.ELLIPSIS);
                    }
                    this.input.backup(2);
                } else {
                    if (48 <= c && c <= 57) {
                        return this.finishNumberLiteral(this.input.read(), true);
                    }
                    this.input.backup(1);
                }
                return this.token(JPQLTokenId.DOT);
            }
            case 126: {
                return this.token(JPQLTokenId.TILDE);
            }
            case 44: {
                return this.token(JPQLTokenId.COMMA);
            }
            case 59: {
                return this.token(JPQLTokenId.SEMICOLON);
            }
            case 58: {
                return this.token(JPQLTokenId.COLON);
            }
            case 63: {
                return this.token(JPQLTokenId.QUESTION);
            }
            case 40: {
                return this.token(JPQLTokenId.LPAREN);
            }
            case 41: {
                return this.token(JPQLTokenId.RPAREN);
            }
            case 91: {
                return this.token(JPQLTokenId.LBRACKET);
            }
            case 93: {
                return this.token(JPQLTokenId.RBRACKET);
            }
            case 123: {
                return this.token(JPQLTokenId.LBRACE);
            }
            case 125: {
                return this.token(JPQLTokenId.RBRACE);
            }
            case 64: {
                return this.token(JPQLTokenId.AT);
            }
            case 48: {
                c = this.input.read();
                if (c == 120 || c == 88) {
                    boolean inFraction = false;
                    block67: while (true) {
                        switch (this.input.read()) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                continue block67;
                            }
                            case 46: {
                                if (!inFraction) {
                                    inFraction = true;
                                    continue block67;
                                }
                                return this.token(JPQLTokenId.ERROR);
                            }
                            case 80: 
                            case 112: {
                                return this.finishFloatExponent();
                            }
                        }
                        break;
                    }
                    this.input.backup(1);
                    return this.token(inFraction ? JPQLTokenId.ERROR : JPQLTokenId.INT_LITERAL);
                }
                return this.finishNumberLiteral(c, false);
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.finishNumberLiteral(this.input.read(), false);
            }
            case 65: 
            case 97: {
                c = this.input.read();
                switch (c) {
                    case 66: 
                    case 98: {
                        c = this.input.read();
                        if (c != 115 && c != 83) break;
                        return this.keywordOrIdentifier(JPQLTokenId.ABS);
                    }
                    case 83: 
                    case 115: {
                        c = this.input.read();
                        if (c != 99 && c != 67) break;
                        return this.keywordOrIdentifier(JPQLTokenId.ASC);
                    }
                }
                return this.finishIdentifier(c);
            }
            case 36: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 95: 
            case 104: 
            case 106: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 117: 
            case 120: 
            case 121: 
            case 122: {
                return this.finishIdentifier();
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return this.finishWhitespace();
            }
            case 32: {
                c = this.input.read();
                if (c == -1 || !Character.isWhitespace(c)) {
                    this.input.backup(1);
                    return this.tokenFactory.getFlyweightToken((TokenId)JPQLTokenId.WHITESPACE, " ");
                }
                return this.finishWhitespace();
            }
            case -1: {
                return null;
            }
        }
        if (c >= 128) {
            if (Character.isJavaIdentifierStart(c = this.translateSurrogates(c))) {
                return this.finishIdentifier();
            }
            if (Character.isWhitespace(c)) {
                return this.finishWhitespace();
            }
        }
        return this.token(JPQLTokenId.WHITESPACE);
    }

    public Object state() {
        return null;
    }

    public void release() {
    }

    private Token<JPQLTokenId> token(JPQLTokenId id) {
        String fixedText = id.getText();
        return fixedText != null ? this.tokenFactory.getFlyweightToken((TokenId)id, fixedText) : this.tokenFactory.createToken((TokenId)id);
    }

    private Token<JPQLTokenId> finishWhitespace() {
        int c;
        while ((c = this.input.read()) != -1 && Character.isWhitespace(c)) {
        }
        this.input.backup(1);
        return this.tokenFactory.createToken((TokenId)JPQLTokenId.WHITESPACE);
    }

    private Token<JPQLTokenId> finishIdentifier() {
        return this.finishIdentifier(this.input.read());
    }

    private Token<JPQLTokenId> finishIdentifier(int c) {
        while (true) {
            if (c == -1 || !Character.isJavaIdentifierPart(c = this.translateSurrogates(c))) {
                this.input.backup(c >= 65536 ? 2 : 1);
                return this.tokenFactory.createToken((TokenId)JPQLTokenId.IDENTIFIER);
            }
            c = this.input.read();
        }
    }

    private Token<JPQLTokenId> keywordOrIdentifier(JPQLTokenId keywordId) {
        return this.keywordOrIdentifier(keywordId, this.input.read());
    }

    private Token<JPQLTokenId> keywordOrIdentifier(JPQLTokenId keywordId, int c) {
        if (c == -1 || !Character.isJavaIdentifierPart(c = this.translateSurrogates(c))) {
            this.input.backup(c >= 65536 ? 2 : 1);
            return this.token(keywordId);
        }
        return this.finishIdentifier();
    }

    private Token<JPQLTokenId> finishNumberLiteral(int c, boolean inFraction) {
        while (true) {
            switch (c) {
                case 46: {
                    if (!inFraction) {
                        inFraction = true;
                        break;
                    }
                    return this.token(JPQLTokenId.ERROR);
                }
                case 76: 
                case 108: {
                    return this.token(JPQLTokenId.LONG_LITERAL);
                }
                case 68: 
                case 100: {
                    return this.token(JPQLTokenId.DOUBLE_LITERAL);
                }
                case 70: 
                case 102: {
                    return this.token(JPQLTokenId.FLOAT_LITERAL);
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    break;
                }
                case 69: 
                case 101: {
                    return this.finishFloatExponent();
                }
                default: {
                    this.input.backup(1);
                    return this.token(inFraction ? JPQLTokenId.DOUBLE_LITERAL : JPQLTokenId.INT_LITERAL);
                }
            }
            c = this.input.read();
        }
    }

    private Token<JPQLTokenId> finishFloatExponent() {
        int c = this.input.read();
        if (c == 43 || c == 45) {
            c = this.input.read();
        }
        if (c < 48 || 57 < c) {
            return this.token(JPQLTokenId.ERROR);
        }
        while (48 <= (c = this.input.read()) && c <= 57) {
        }
        switch (c) {
            case 68: 
            case 100: {
                return this.token(JPQLTokenId.DOUBLE_LITERAL);
            }
            case 70: 
            case 102: {
                return this.token(JPQLTokenId.FLOAT_LITERAL);
            }
        }
        this.input.backup(1);
        return this.token(JPQLTokenId.DOUBLE_LITERAL);
    }

    private int translateSurrogates(int c) {
        if (Character.isHighSurrogate((char)c)) {
            int lowSurr = this.input.read();
            if (lowSurr != -1 && Character.isLowSurrogate((char)lowSurr)) {
                c = Character.toCodePoint((char)c, (char)lowSurr);
            } else {
                this.input.backup(1);
            }
        }
        return c;
    }
}

