/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import org.apache.commons.codec.binary.Base32;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.Field;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IndexerFieldVersion;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.creator.AbstractIndexCreator;
import org.apache.maven.index.expr.StringSearchExpression;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.maven.indexer.NexusRepositoryIndexerImpl;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;

class ClassDependencyIndexCreator
extends AbstractIndexCreator {
    private static final Logger LOG = Logger.getLogger(ClassDependencyIndexCreator.class.getName());
    private static final String NB_DEPENDENCY_CLASSES = "nbdc";
    private static final IndexerField FLD_NB_DEPENDENCY_CLASS = new IndexerField(new Field(null, "urn:NbClassDependenciesIndexCreator", "nbdc", "Java dependencies"), IndexerFieldVersion.V3, "nbdc", "Java dependencies", IndexerField.ANALYZED_STORED);
    private Map<String, Set<String>> classDeps;
    private static final byte[] ZIP_HEADER_1 = new byte[]{80, 75, 3, 4};
    private static final byte[] ZIP_HEADER_2 = new byte[]{80, 75, 5, 6};
    private static final String[] JDK_CLASS_TEST = new String[]{"apple/applescript", "apple/laf", "apple/launcher", "apple/security", "com/apple/concurrent", "com/apple/eawt", "com/apple/eio", "com/apple/laf", "com/oracle/net", "com/oracle/nio", "com/oracle/util", "com/oracle/webservices", "com/oracle/xmlns", "com/sun/accessibility", "com/sun/activation", "com/sun/awt", "com/sun/beans", "com/sun/corba", "com/sun/demo", "com/sun/image", "com/sun/imageio", "com/sun/istack", "com/sun/java", "com/sun/java_cup", "com/sun/jmx", "com/sun/jndi", "com/sun/management", "com/sun/media", "com/sun/naming", "com/sun/net", "com/sun/nio", "com/sun/org", "com/sun/rmi", "com/sun/rowset", "com/sun/security", "com/sun/swing", "com/sun/tracing", "com/sun/xml", "java/applet", "java/awt", "java/awt/color", "java/awt/datatransfer", "java/awt/dnd", "java/awt/event", "java/awt/font", "java/awt/geom", "java/awt/im", "java/awt/image", "java/awt/peer", "java/awt/print", "java/beans", "java/beans/beancontext", "java/io", "java/lang", "java/lang/annotation", "java/lang/instrument", "java/lang/invoke", "java/lang/management", "java/lang/ref", "java/lang/reflect", "java/math", "java/net", "java/nio", "java/nio/channels", "java/nio/charset", "java/nio/file", "java/rmi", "java/rmi/activation", "java/rmi/dgc", "java/rmi/registry", "java/rmi/server", "java/security", "java/security/acl", "java/security/cert", "java/security/interfaces", "java/security/spec", "java/sql", "java/text", "java/text/spi", "java/time", "java/time/chrono", "java/time/format", "java/time/temporal", "java/time/zone", "java/util", "java/util/concurrent", "java/util/function", "java/util/jar", "java/util/logging", "java/util/prefs", "java/util/regex", "java/util/spi", "java/util/stream", "java/util/zip", "javax/accessibility", "javax/activation", "javax/activity", "javax/annotation", "javax/annotation/processing", "javax/imageio", "javax/imageio/event", "javax/imageio/metadata", "javax/imageio/plugins", "javax/imageio/spi", "javax/imageio/stream", "javax/jws", "javax/jws/soap", "javax/lang/model", "javax/management", "javax/management/loading", "javax/management/modelmbean", "javax/management/monitor", "javax/management/openmbean", "javax/management/relation", "javax/management/remote", "javax/management/timer", "javax/naming", "javax/naming/directory", "javax/naming/event", "javax/naming/ldap", "javax/naming/spi", "javax/net", "javax/net/ssl", "javax/print", "javax/print/attribute", "javax/print/event", "javax/rmi", "javax/rmi/CORBA", "javax/rmi/ssl", "javax/script", "javax/security/auth", "javax/security/cert", "javax/security/sasl", "javax/smartcardio", "javax/sound/midi", "javax/sound/sampled", "javax/sql", "javax/sql/rowset", "javax/swing", "javax/swing/border", "javax/swing/colorchooser", "javax/swing/event", "javax/swing/filechooser", "javax/swing/plaf", "javax/swing/table", "javax/swing/text", "javax/swing/tree", "javax/swing/undo", "javax/tools", "javax/transaction", "javax/transaction/xa", "javax/xml", "javax/xml/bind", "javax/xml/crypto", "javax/xml/datatype", "javax/xml/namespace", "javax/xml/parsers", "javax/xml/soap", "javax/xml/stream", "javax/xml/transform", "javax/xml/validation", "javax/xml/ws", "javax/xml/xpath", "jdk/incubator", "jdk/internal/cmm", "jdk/internal/instrumentation", "jdk/internal/org", "jdk/internal/util", "jdk/management/cmm", "jdk/management/resource", "jdk/net", "jdk/xml/internal", "org/ietf/jgss", "org/jcp/xml", "org/omg/CORBA", "org/omg/CORBA_2_3", "org/omg/CosNaming", "org/omg/Dynamic", "org/omg/DynamicAny", "org/omg/IOP", "org/omg/Messaging", "org/omg/PortableInterceptor", "org/omg/PortableServer", "org/omg/SendingContext", "org/omg/stub", "org/w3c/dom", "org/xml/sax"};
    final ThreadLocal<byte[]> BYTES = new ThreadLocal();
    private static final int MIN_ARRAY_SIZE = 16384;
    static final List<IndexerField> INDEXER_FIELDS = Collections.singletonList(FLD_NB_DEPENDENCY_CLASS);
    private static final CRC32 crc = new CRC32();
    private static final Base32 base32 = new Base32();

    ClassDependencyIndexCreator() {
        super(ClassDependencyIndexCreator.class.getName(), Arrays.asList("min"));
    }

    @Override
    public void populateArtifactInfo(ArtifactContext context) throws IOException {
        this.classDeps = null;
        ArtifactInfo ai = context.getArtifactInfo();
        if (ai.getClassifier() != null) {
            return;
        }
        if ("pom".equals(ai.getPackaging()) || ai.getFileExtension().endsWith(".lastUpdated")) {
            return;
        }
        File jar = context.getArtifact();
        if (jar == null || !jar.isFile()) {
            LOG.log(Level.FINER, "no artifact for {0}", ai);
            return;
        }
        if (jar.length() == 0L) {
            LOG.log(Level.FINER, "zero length jar for {0}", ai);
            return;
        }
        String packaging = ai.getPackaging();
        if (packaging == null || !packaging.equals("jar") && !ClassDependencyIndexCreator.isArchiveFile(jar)) {
            LOG.log(Level.FINE, "skipping artifact {0} with unrecognized packaging based on {1}", new Object[]{ai, jar});
            return;
        }
        LOG.log(Level.FINER, "reading {0}", jar);
        this.classDeps = new HashMap<String, Set<String>>();
        this.read(jar, (name, stream, classes) -> {
            try {
                ClassDependencyIndexCreator.addDependenciesToMap(name, stream, this.classDeps, classes);
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Exception indexing " + jar, ex);
            }
        });
    }

    private static boolean isArchiveFile(File jar) throws IOException {
        try (FileInputStream in = new FileInputStream(jar);){
            byte[] buffer = new byte[4];
            boolean bl = ((InputStream)in).read(buffer, 0, 4) == 4 && (Arrays.equals(ZIP_HEADER_1, buffer) || Arrays.equals(ZIP_HEADER_2, buffer));
            return bl;
        }
    }

    @Override
    public boolean updateArtifactInfo(Document document, ArtifactInfo artifactInfo) {
        return false;
    }

    @Override
    public void updateDocument(ArtifactInfo ai, Document doc) {
        String[] classNamesSplit;
        if (this.classDeps == null || this.classDeps.isEmpty()) {
            return;
        }
        if (ai.getClassNames() == null) {
            LOG.log(Level.FINE, "no class names in index for {0}; therefore cannot store class usages", ai);
            return;
        }
        StringBuilder b = new StringBuilder();
        for (String referrerTopLevel : classNamesSplit = ai.getClassNames().split("\n")) {
            Set<String> referees = this.classDeps.remove(referrerTopLevel.substring(1));
            if (referees != null) {
                for (String referee : referees) {
                    b.append(ClassDependencyIndexCreator.crc32base32(referee));
                    b.append(' ');
                }
            }
            b.append(' ');
        }
        if (!this.classDeps.isEmpty()) {
            LOG.log(Level.FINE, "found dependencies for {0} from classes {1} not among {2}", new Object[]{ai, this.classDeps.keySet(), Arrays.asList(classNamesSplit)});
        }
        LOG.log(Level.FINER, "Class dependencies index field: {0}", b);
        doc.add((IndexableField)FLD_NB_DEPENDENCY_CLASS.toField(b.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void search(String className, Indexer indexer, Collection<IndexingContext> contexts, List<? super RepositoryQueries.ClassUsage> results) throws IOException {
        String searchString = ClassDependencyIndexCreator.crc32base32(className.replace('.', '/'));
        Query refClassQuery = indexer.constructQuery(FLD_NB_DEPENDENCY_CLASS.getOntology(), new StringSearchExpression(searchString));
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)1024, (int)Integer.MAX_VALUE);
        for (IndexingContext context : contexts) {
            IndexSearcher searcher = context.acquireIndexSearcher();
            try {
                searcher.search(refClassQuery, (Collector)collector);
                ScoreDoc[] hits = collector.topDocs().scoreDocs;
                LOG.log(Level.FINER, "for {0} ~ {1} found {2} hits", new Object[]{className, searchString, hits.length});
                for (ScoreDoc hit : hits) {
                    ArtifactInfo ai;
                    Document d = searcher.doc(hit.doc);
                    String fldValue = d.get(NB_DEPENDENCY_CLASSES);
                    LOG.log(Level.FINER, "{0} uses: {1}", new Object[]{className, fldValue});
                    Set<String> refClasses = ClassDependencyIndexCreator.parseField(searchString, fldValue, d.get(ArtifactInfo.NAMES));
                    if (refClasses.isEmpty() || (ai = IndexUtils.constructArtifactInfo(d, context)) == null) continue;
                    ai.setRepository(context.getRepositoryId());
                    List<NBVersionInfo> version = NexusRepositoryIndexerImpl.convertToNBVersionInfo(Collections.singleton(ai));
                    if (version.isEmpty()) continue;
                    results.add(new RepositoryQueries.ClassUsage(version.get(0), refClasses));
                }
            }
            finally {
                context.releaseIndexSearcher(searcher);
            }
        }
    }

    private static Set<String> parseField(String refereeCRC, String field, String referrersNL) {
        TreeSet<String> referrers = new TreeSet<String>();
        int p = 0;
        block0: for (String referrer : referrersNL.split("\n")) {
            while (true) {
                if (field.charAt(p) == ' ') {
                    ++p;
                    continue block0;
                }
                if (field.substring(p, p + 7).equals(refereeCRC)) {
                    referrers.add(referrer.substring(1).replace('/', '.'));
                }
                p += 8;
            }
        }
        return referrers;
    }

    private static void addDependenciesToMap(String referrer, InputStream classData, Map<String, Set<String>> depsMap, Set<String> siblings) throws IOException {
        int shell = referrer.indexOf(36, referrer.lastIndexOf(47) + 1);
        String referrerTopLevel = shell == -1 ? referrer : referrer.substring(0, shell);
        Set<String> tmp = depsMap.get(referrerTopLevel);
        if (tmp == null) {
            tmp = new HashSet<String>();
            depsMap.put(referrerTopLevel, tmp);
        }
        Set<String> referees = tmp;
        ClassDependencyIndexCreator.dependenciesOf(classData).filter(referee -> !referrer.equals(referee)).filter(referee -> !siblings.contains(referee)).filter(referee -> {
            for (int i = 0; i < JDK_CLASS_TEST.length; ++i) {
                if (!referee.startsWith(JDK_CLASS_TEST[i])) continue;
                return false;
            }
            return true;
        }).forEach(referee -> referees.add((String)referee));
    }

    byte[] bytes(int size) {
        byte[] result = this.BYTES.get();
        if (result == null || result.length < size) {
            result = new byte[Math.max(16384, size)];
            this.BYTES.set(result);
        }
        return result;
    }

    void read(File jar, JarClassEntryConsumer consumer) throws IOException {
        HashSet<String> classNames = new HashSet<String>(512);
        try (JarFile jf = new JarFile(jar, false);){
            String name;
            JarEntry entry;
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                entry = e.nextElement();
                name = entry.getName();
                if (!name.endsWith(".class")) continue;
                String clazz = name.substring(0, name.length() - 6);
                classNames.add(clazz);
            }
            e = jf.entries();
            while (e.hasMoreElements()) {
                int size;
                entry = e.nextElement();
                name = entry.getName();
                if (!name.endsWith(".class") || (size = Math.max((int)entry.getSize(), 0)) <= 0) continue;
                byte[] target = this.bytes(size);
                try (InputStream in = jf.getInputStream(entry);){
                    int count = 0;
                    for (int pos = 0; count != -1 && pos < size; pos += (count = in.read(target, pos, size - pos)) == -1 ? 0 : count) {
                    }
                }
                in = new ByteArrayInputStream(target, 0, size);
                try {
                    String clazz = name.substring(0, name.length() - 6);
                    consumer.accept(clazz, in, classNames);
                }
                finally {
                    in.close();
                }
            }
        }
        catch (SecurityException x) {
            throw new IOException(x);
        }
    }

    private static Stream<String> dependenciesOf(InputStream classData) throws IOException {
        return ((Stream)new ClassFile(classData).getAllClassNames().stream().unordered()).map(ClassName::getInternalName).distinct();
    }

    @Override
    public Collection<IndexerField> getIndexerFields() {
        return INDEXER_FIELDS;
    }

    static String crc32base32(String s) {
        crc.reset();
        crc.update(s.getBytes(StandardCharsets.UTF_8));
        long v = crc.getValue();
        byte[] b32 = base32.encode(new byte[]{(byte)(v >> 24 & 0xFFL), (byte)(v >> 16 & 0xFFL), (byte)(v >> 8 & 0xFFL), (byte)(v & 0xFFL)});
        assert (b32.length == 8);
        assert (b32[7] == 61);
        return new String(b32, 0, 7, StandardCharsets.ISO_8859_1).toLowerCase();
    }

    @FunctionalInterface
    static interface JarClassEntryConsumer {
        public void accept(String var1, InputStream var2, Set<String> var3) throws IOException;
    }
}

