/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.validation.constraints;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.j2ee.sun.validation.constraints.Constraint;
import org.netbeans.modules.j2ee.sun.validation.constraints.ConstraintFailure;
import org.netbeans.modules.j2ee.sun.validation.constraints.ConstraintUtils;
import org.netbeans.modules.j2ee.sun.validation.util.BundleReader;

public class RangeConstraint
extends ConstraintUtils
implements Constraint {
    private Double startValue = null;
    private Double endValue = null;

    public RangeConstraint() {
        this.startValue = null;
        this.endValue = null;
    }

    public RangeConstraint(String startValue, String endValue) {
        try {
            this.startValue = new Double(startValue);
            this.endValue = new Double(endValue);
        }
        catch (NumberFormatException e) {
            String format = BundleReader.getValue("Error_failed_to_create");
            Object[] arguments = new Object[]{"RangeConstaint"};
            System.out.println(MessageFormat.format(format, arguments));
        }
    }

    @Override
    public Collection match(String value, String name) {
        ArrayList failed_constrained_list = new ArrayList();
        if (this.startValue == null || this.endValue == null) {
            return failed_constrained_list;
        }
        if (value != null && value.length() != 0) {
            try {
                Double val = new Double(value);
                if (val.compareTo(this.startValue) < 0 || val.compareTo(this.endValue) > 0) {
                    this.addFailure(failed_constrained_list, name, value);
                }
            }
            catch (NumberFormatException e) {
                this.addFailure(failed_constrained_list, name, value);
            }
        }
        return failed_constrained_list;
    }

    public void setRangeStart(String value) {
        try {
            this.startValue = new Double(value);
        }
        catch (NumberFormatException e) {
            String format = BundleReader.getValue("Error_failed_to_set");
            Object[] arguments = new Object[]{this.toString(), "Range Start"};
            System.out.println(MessageFormat.format(format, arguments));
        }
    }

    public void setRangeEnd(String value) {
        try {
            this.endValue = new Double(value);
        }
        catch (NumberFormatException e) {
            String format = BundleReader.getValue("Error_failed_to_set");
            Object[] arguments = new Object[]{this.toString(), "Range End"};
            System.out.println(MessageFormat.format(format, arguments));
        }
    }

    @Override
    public void print() {
        super.print();
        String format = BundleReader.getValue("Name_Value_Pair_Format");
        Object[] arguments = new Object[]{"Range Start", this.startValue};
        System.out.println(MessageFormat.format(format, arguments));
        arguments = new Object[]{"Range End", this.endValue};
        System.out.println(MessageFormat.format(format, arguments));
    }

    public void setRangeStart(Double value) {
        this.startValue = value;
    }

    public void setRangeEnd(Double value) {
        this.endValue = value;
    }

    private void addFailure(Collection failed_constrained_list, String name, String value) {
        String failureMessage = this.formatFailureMessage(this.toString(), value, name);
        String format = BundleReader.getValue("MSG_RangeConstraint_Failure");
        String range = this.startValue + " - " + this.endValue;
        Object[] arguments = new Object[]{range};
        String genericFailureMessage = MessageFormat.format(format, arguments);
        failed_constrained_list.add(new ConstraintFailure(this.toString(), value, name, failureMessage, genericFailureMessage));
    }
}

