/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.server.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.server.properties.InstanceProperties;
import org.openide.util.NbPreferences;

public final class InstancePropertiesManager {
    private static final Logger LOGGER = Logger.getLogger(InstancePropertiesManager.class.getName());
    private static InstancePropertiesManager manager;
    private final Map<Preferences, InstanceProperties> cache = new WeakHashMap<Preferences, InstanceProperties>();
    private final Random random = new Random();

    private InstancePropertiesManager() {
    }

    public static synchronized InstancePropertiesManager getInstance() {
        if (manager == null) {
            manager = new InstancePropertiesManager();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceProperties createProperties(String namespace) {
        Preferences prefs = NbPreferences.forModule(InstancePropertiesManager.class);
        try {
            prefs = prefs.node(namespace);
            boolean next = true;
            String id = null;
            InstancePropertiesManager instancePropertiesManager = this;
            synchronized (instancePropertiesManager) {
                while (next) {
                    id = Integer.toString(this.random.nextInt(Integer.MAX_VALUE));
                    next = prefs.nodeExists(id);
                }
                prefs = prefs.node(id);
                prefs.flush();
                DefaultInstanceProperties created = new DefaultInstanceProperties(id, this, prefs);
                this.cache.put(prefs, created);
                return created;
            }
        }
        catch (BackingStoreException ex) {
            LOGGER.log(Level.INFO, null, ex);
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InstanceProperties> getProperties(String namespace) {
        Preferences prefs = NbPreferences.forModule(InstancePropertiesManager.class);
        try {
            prefs = prefs.node(namespace);
            prefs.flush();
            ArrayList<InstanceProperties> allProperties = new ArrayList<InstanceProperties>();
            InstancePropertiesManager instancePropertiesManager = this;
            synchronized (instancePropertiesManager) {
                for (String id : prefs.childrenNames()) {
                    Preferences child = prefs.node(id);
                    InstanceProperties props = this.cache.get(child);
                    if (props == null) {
                        props = new DefaultInstanceProperties(id, this, child);
                        this.cache.put(child, props);
                    }
                    allProperties.add(props);
                }
            }
            return allProperties;
        }
        catch (BackingStoreException ex) {
            LOGGER.log(Level.INFO, null, ex);
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Preferences prefs) throws BackingStoreException {
        InstancePropertiesManager instancePropertiesManager = this;
        synchronized (instancePropertiesManager) {
            this.cache.remove(prefs);
            prefs.removeNode();
        }
    }

    private static class DefaultInstanceProperties
    extends InstanceProperties {
        private final InstancePropertiesManager manager;
        private Preferences prefs;

        public DefaultInstanceProperties(String id, InstancePropertiesManager manager, Preferences prefs) {
            super(id);
            this.manager = manager;
            this.prefs = prefs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getBoolean(String key, boolean def) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                return this.prefs.getBoolean(key, def);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getDouble(String key, double def) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                return this.prefs.getDouble(key, def);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float getFloat(String key, float def) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                return this.prefs.getFloat(key, def);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getInt(String key, int def) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                return this.prefs.getInt(key, def);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getLong(String key, long def) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                return this.prefs.getLong(key, def);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getString(String key, String def) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                return this.prefs.get(key, def);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putBoolean(String key, boolean value) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                this.prefs.putBoolean(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putDouble(String key, double value) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                this.prefs.putDouble(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putFloat(String key, float value) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                this.prefs.putFloat(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putInt(String key, int value) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                this.prefs.putInt(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putLong(String key, long value) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                this.prefs.putLong(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putString(String key, String value) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                this.prefs.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeKey(String key) {
            DefaultInstanceProperties defaultInstanceProperties = this;
            synchronized (defaultInstanceProperties) {
                if (this.prefs == null) {
                    throw new IllegalStateException("Properties are not valid anymore");
                }
                this.prefs.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            try {
                DefaultInstanceProperties defaultInstanceProperties = this;
                synchronized (defaultInstanceProperties) {
                    if (this.prefs != null) {
                        this.manager.remove(this.prefs);
                        this.prefs = null;
                    }
                }
            }
            catch (BackingStoreException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }
}

