"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUpgradeableConfig = getUpgradeableConfig;

var _is_config_version_upgradeable = require("./is_config_version_upgradeable");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 *  Find the most recent SavedConfig that is upgradeable to the specified version
 *  @param {Object} options
 *  @property {SavedObjectsClient} savedObjectsClient
 *  @property {string} version
 *  @return {Promise<SavedConfig|undefined>}
 */
async function getUpgradeableConfig({
  savedObjectsClient,
  version
}) {
  // attempt to find a config we can upgrade
  const {
    saved_objects: savedConfigs
  } = await savedObjectsClient.find({
    type: 'config',
    page: 1,
    perPage: 1000,
    sortField: 'buildNum',
    sortOrder: 'desc'
  }); // try to find a config that we can upgrade

  return savedConfigs.find(savedConfig => (0, _is_config_version_upgradeable.isConfigVersionUpgradeable)(savedConfig.id, version));
}