/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp.muc;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.impl.protocol.xmpp.ChatRoomMember;
import org.jitsi.jicofo.xmpp.muc.ChatRoomRoleManager;
import org.jitsi.jicofo.xmpp.muc.MemberRole;
import org.jitsi.jicofo.xmpp.muc.MemberRoleKt;
import org.jitsi.utils.OrderedJsonObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\nH\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jitsi/jicofo/xmpp/muc/AutoOwnerRoleManager;", "Lorg/jitsi/jicofo/xmpp/muc/ChatRoomRoleManager;", "chatRoom", "Lorg/jitsi/impl/protocol/xmpp/ChatRoom;", "(Lorg/jitsi/impl/protocol/xmpp/ChatRoom;)V", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "owner", "Lorg/jitsi/impl/protocol/xmpp/ChatRoomMember;", "electNewOwner", "", "localRoleChanged", "newRole", "Lorg/jitsi/jicofo/xmpp/muc/MemberRole;", "oldRole", "memberJoined", "member", "memberLeftOrKicked", "jicofo"})
public final class AutoOwnerRoleManager
extends ChatRoomRoleManager {
    @Nullable
    private ChatRoomMember owner;

    public AutoOwnerRoleManager(@NotNull ChatRoom chatRoom) {
        Intrinsics.checkNotNullParameter(chatRoom, "chatRoom");
        super(chatRoom, null);
    }

    @Override
    public void memberJoined(@NotNull ChatRoomMember member) {
        Intrinsics.checkNotNullParameter(member, "member");
        if (this.owner == null) {
            this.electNewOwner();
        }
    }

    @Override
    protected void memberLeftOrKicked(@NotNull ChatRoomMember member) {
        Intrinsics.checkNotNullParameter(member, "member");
        if (Intrinsics.areEqual(member, this.owner)) {
            this.getLogger().debug("The owner left the room, electing a new one.");
            this.owner = null;
            this.electNewOwner();
        }
    }

    @Override
    public void localRoleChanged(@NotNull MemberRole newRole, @Nullable MemberRole oldRole) {
        Intrinsics.checkNotNullParameter((Object)newRole, "newRole");
        if (!MemberRoleKt.hasOwnerRights(newRole)) {
            this.getLogger().error("Local role has no owner rights, can not manage roles.");
            return;
        }
        this.electNewOwner();
    }

    private final void electNewOwner() {
        Object v3;
        block7: {
            Object v1;
            Object object2;
            block6: {
                if (this.owner != null) {
                    return;
                }
                if (this.getChatRoom().isBreakoutRoom()) {
                    return;
                }
                List<ChatRoomMember> list = this.getChatRoom().getMembers();
                Intrinsics.checkNotNullExpressionValue(list, "chatRoom.members");
                Iterable iterable = list;
                AutoOwnerRoleManager autoOwnerRoleManager = this;
                Iterable iterable2 = iterable;
                for (Object object2 : iterable2) {
                    ChatRoomMember it = (ChatRoomMember)object2;
                    boolean bl = false;
                    if (!(!it.isRobot() && MemberRoleKt.hasOwnerRights(it.getRole()))) continue;
                    v1 = object2;
                    break block6;
                }
                v1 = null;
            }
            autoOwnerRoleManager.owner = v1;
            if (this.owner != null) {
                return;
            }
            List<ChatRoomMember> list = this.getChatRoom().getMembers();
            Intrinsics.checkNotNullExpressionValue(list, "chatRoom.members");
            Iterable iterable = list;
            object2 = iterable.iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                ChatRoomMember it = (ChatRoomMember)e;
                boolean bl = false;
                if (!(!it.isRobot())) continue;
                v3 = e;
                break block7;
            }
            v3 = null;
        }
        ChatRoomMember newOwner = v3;
        if (newOwner != null) {
            this.getLogger().info("Electing new owner: " + newOwner);
            this.grantOwner(newOwner);
            this.owner = newOwner;
        }
    }

    @Override
    @NotNull
    public OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$_get_debugState__u24lambda_u2d2 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string, "this@AutoOwnerRoleManager.javaClass.simpleName");
        $this$_get_debugState__u24lambda_u2d2.put("class", string);
        Object object = this.owner;
        if (object == null || (object = object.getJid()) == null || (object = object.toString()) == null) {
            object = "null";
        }
        $this$_get_debugState__u24lambda_u2d2.put("owner", object);
        return orderedJsonObject;
    }
}

