/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.wagon.events.TransferEvent;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenIndexId;
import org.jetbrains.idea.maven.server.IndexedMavenId;
import org.jetbrains.idea.maven.server.Maven2ServerGlobals;
import org.jetbrains.idea.maven.server.MavenProcessCanceledRuntimeException;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.embedder.Maven2ModelConverter;
import org.jetbrains.idea.maven.server.embedder.Maven2ServerEmbedderImpl;
import org.jetbrains.idea.maven.server.embedder.Maven2ServerIndexFetcher;
import org.jetbrains.idea.maven.server.embedder.RuntimeRemoteException;
import org.jetbrains.idea.maven.server.embedder.TransferListenerAdapter;
import org.jetbrains.idea.maven.server.security.MavenToken;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactContextProducer;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.ArtifactScanningListener;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.ScanningResult;
import org.sonatype.nexus.index.context.IndexUtils;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.creator.AbstractIndexCreator;
import org.sonatype.nexus.index.creator.JarFileContentsIndexCreator;
import org.sonatype.nexus.index.creator.MinimalArtifactInfoIndexCreator;
import org.sonatype.nexus.index.updater.IndexUpdateRequest;
import org.sonatype.nexus.index.updater.IndexUpdater;
import org.sonatype.nexus.index.updater.ResourceFetcher;

public final class Maven2ServerIndexerImpl
extends MavenRemoteObject
implements MavenServerIndexer {
    private final Maven2ServerEmbedderImpl myEmbedder = Maven2ServerEmbedderImpl.create(new MavenServerSettings());
    private final NexusIndexer myIndexer = this.myEmbedder.getComponent(NexusIndexer.class);
    private final IndexUpdater myUpdater = this.myEmbedder.getComponent(IndexUpdater.class);
    private final ArtifactContextProducer myArtifactContextProducer = this.myEmbedder.getComponent(ArtifactContextProducer.class);

    public Maven2ServerIndexerImpl() throws RemoteException {
        MavenServerUtil.registerShutdownTask(() -> this.release(MavenServerUtil.getToken()));
    }

    public void releaseIndex(MavenIndexId mavenIndexId, MavenToken token) throws MavenServerIndexerException {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            IndexingContext context = (IndexingContext)this.myIndexer.getIndexingContexts().get(mavenIndexId.indexId);
            if (context != null) {
                this.myIndexer.removeIndexingContext(context, false);
            }
        }
        catch (Exception e) {
            throw new MavenServerIndexerException(this.wrapException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private IndexingContext getIndex(MavenIndexId mavenIndexId) throws IOException {
        IndexingContext context = (IndexingContext)this.myIndexer.getIndexingContexts().get(mavenIndexId.indexId);
        if (context == null) {
            NexusIndexer nexusIndexer = this.myIndexer;
            synchronized (nexusIndexer) {
                context = (IndexingContext)this.myIndexer.getIndexingContexts().get(mavenIndexId.indexId);
                if (context == null) {
                    context = this.myIndexer.addIndexingContextForced(mavenIndexId.indexId, mavenIndexId.repositoryId, mavenIndexId.repositoryFilePath != null ? new File(mavenIndexId.repositoryFilePath) : null, new File(mavenIndexId.indexDirPath), mavenIndexId.url, null, Arrays.asList(new AbstractIndexCreator[]{new TinyArtifactInfoIndexCreator(), new JarFileContentsIndexCreator()}));
                }
            }
        }
        IndexingContext indexingContext = context;
        if (indexingContext == null) {
            Maven2ServerIndexerImpl.$$$reportNull$$$0(0);
        }
        return indexingContext;
    }

    public boolean indexExists(File dir, MavenToken token) throws RemoteException {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            return IndexReader.indexExists((File)dir);
        }
        catch (Exception e) {
            Maven2ServerGlobals.getLogger().warn(e);
            return false;
        }
    }

    private static String getRepositoryPathOrUrl(IndexingContext index) {
        File file = index.getRepository();
        return file == null ? index.getRepositoryUrl() : file.getPath();
    }

    private static boolean isLocal(IndexingContext index) {
        return index.getRepository() != null;
    }

    public int getIndexCount(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        return this.myIndexer.getIndexingContexts().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndex(MavenIndexId mavenIndexId, MavenServerSettings settings, MavenServerProgressIndicator indicator, MavenToken token) throws MavenServerIndexerException, MavenServerProcessCanceledException, RemoteException {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            IndexingContext index;
            IndexingContext indexingContext = index = this.getIndex(mavenIndexId);
            synchronized (indexingContext) {
                if (Maven2ServerIndexerImpl.isLocal(index)) {
                    File repository = index.getRepository();
                    if (repository != null && repository.exists()) {
                        indicator.setIndeterminate(true);
                        try {
                            this.myIndexer.scan(index, (ArtifactScanningListener)new MyScanningListener(indicator), false);
                        }
                        finally {
                            indicator.setIndeterminate(false);
                        }
                    }
                } else {
                    IndexUpdateRequest request = new IndexUpdateRequest(index);
                    Maven2ServerEmbedderImpl embedder = Maven2ServerEmbedderImpl.create(settings);
                    try {
                        request.setResourceFetcher((ResourceFetcher)new Maven2ServerIndexFetcher(index.getRepositoryId(), index.getRepositoryUrl(), embedder.getComponent(WagonManager.class), new TransferListenerAdapter(indicator){

                            @Override
                            protected void downloadProgress(long downloaded, long total) {
                                super.downloadProgress(downloaded, total);
                                try {
                                    this.myIndicator.setFraction((double)downloaded / (double)total);
                                }
                                catch (RemoteException e) {
                                    throw new RuntimeRemoteException(e);
                                }
                            }

                            @Override
                            public void transferCompleted(TransferEvent event) {
                                super.transferCompleted(event);
                                try {
                                    this.myIndicator.setText2("Processing indices...");
                                }
                                catch (RemoteException e) {
                                    throw new RuntimeRemoteException(e);
                                }
                            }
                        }));
                        this.myUpdater.fetchAndUpdateIndex(request);
                    }
                    finally {
                        embedder.release(token);
                    }
                }
            }
        }
        catch (RuntimeRemoteException e) {
            throw e.getCause();
        }
        catch (MavenProcessCanceledRuntimeException e) {
            throw new MavenServerProcessCanceledException();
        }
        catch (Exception e) {
            throw new MavenServerIndexerException(this.wrapException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IndexedMavenId> processArtifacts(MavenIndexId indexId, int startFrom, MavenToken token) throws MavenServerIndexerException {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            IndexingContext context;
            int CHUNK_SIZE = 10000;
            IndexingContext indexingContext = context = this.getIndex(indexId);
            synchronized (indexingContext) {
                IndexReader r = this.getIndex(indexId).getIndexReader();
                int total = r.numDocs();
                ArrayList<IndexedMavenId> result = new ArrayList<IndexedMavenId>(Math.min(10000, total));
                for (int i = startFrom; i < total; ++i) {
                    String[] uInfoParts;
                    Document doc;
                    String uinfo;
                    if (r.isDeleted(i) || (uinfo = (doc = r.document(i)).get("u")) == null || (uInfoParts = uinfo.split("\\|")).length < 3) continue;
                    String groupId = uInfoParts[0];
                    String artifactId = uInfoParts[1];
                    String version = uInfoParts[2];
                    String packaging = doc.get("p");
                    String description = doc.get("d");
                    result.add(new IndexedMavenId(groupId, artifactId, version, packaging, description));
                    if (result.size() != 10000) continue;
                    return result;
                }
                if (result.isEmpty()) {
                    return null;
                }
                return result;
            }
        }
        catch (Exception e) {
            throw new MavenServerIndexerException(this.wrapException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexedMavenId addArtifact(MavenIndexId indexId, File artifactFile, MavenToken token) throws MavenServerIndexerException {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            IndexingContext index;
            IndexingContext indexingContext = index = this.getIndex(indexId);
            synchronized (indexingContext) {
                ArtifactContext artifactContext = this.myArtifactContextProducer.getArtifactContext(index, artifactFile);
                if (artifactContext == null) {
                    return null;
                }
                Maven2ServerIndexerImpl.addArtifact(this.myIndexer, index, artifactContext);
                ArtifactInfo a = artifactContext.getArtifactInfo();
                return new IndexedMavenId(a.groupId, a.artifactId, a.version, a.packaging, a.description);
            }
        }
        catch (Exception e) {
            throw new MavenServerIndexerException(this.wrapException(e));
        }
    }

    public static void addArtifact(NexusIndexer indexer, IndexingContext index, ArtifactContext artifactContext) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        indexer.addArtifactToIndex(artifactContext, index);
        Method m = index.getClass().getDeclaredMethod("closeReaders", new Class[0]);
        m.setAccessible(true);
        m.invoke((Object)index, new Object[0]);
    }

    public Set<MavenArtifactInfo> search(MavenIndexId indexId, String pattern, int maxResult, MavenToken token) throws MavenServerIndexerException {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            IndexingContext index = this.getIndex(indexId);
            TopDocs docs = null;
            try {
                BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
                MatchAllDocsQuery query = StringUtils.isEmpty((String)pattern) ? new MatchAllDocsQuery() : Maven2ServerIndexerImpl.getWildcardQuery(pattern);
                docs = index.getIndexSearcher().search((Query)query, null, maxResult);
            }
            catch (BooleanQuery.TooManyClauses query) {
                // empty catch block
            }
            if (docs == null || docs.scoreDocs.length == 0) {
                return Collections.emptySet();
            }
            HashSet<MavenArtifactInfo> result = new HashSet<MavenArtifactInfo>();
            for (int i = 0; i < docs.scoreDocs.length; ++i) {
                int docIndex = docs.scoreDocs[i].doc;
                Document doc = index.getIndexReader().document(docIndex);
                ArtifactInfo a = IndexUtils.constructArtifactInfo((Document)doc, (IndexingContext)index);
                if (a == null) continue;
                a.repository = Maven2ServerIndexerImpl.getRepositoryPathOrUrl(index);
                result.add(Maven2ModelConverter.convertArtifactInfo(a));
            }
            return result;
        }
        catch (Exception e) {
            throw new MavenServerIndexerException(this.wrapException(e));
        }
    }

    public Collection<MavenArchetype> getArchetypes(MavenToken token) throws RemoteException {
        MavenServerUtil.checkToken((MavenToken)token);
        HashSet<MavenArchetype> result = new HashSet<MavenArchetype>();
        this.doCollectArchetypes("internal-catalog", result);
        return result;
    }

    private void doCollectArchetypes(String roleHint, Set<MavenArchetype> result) throws RemoteException {
        try {
            ArchetypeDataSource source = this.myEmbedder.getComponent(ArchetypeDataSource.class, roleHint);
            ArchetypeCatalog catalog = source.getArchetypeCatalog(new Properties());
            for (Archetype each : catalog.getArchetypes()) {
                result.add(Maven2ModelConverter.convertArchetype(each));
            }
        }
        catch (ArchetypeDataSourceException e) {
            Maven2ServerGlobals.getLogger().warn(e);
        }
    }

    public void release(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            this.myEmbedder.release(token);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @NotNull
    private static WildcardQuery getWildcardQuery(String pattern) {
        return new WildcardQuery(new Term("c", "*/" + pattern.replaceAll("\\.", "/")));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/Maven2ServerIndexerImpl", "getIndex"));
    }

    private static class TinyArtifactInfoIndexCreator
    extends MinimalArtifactInfoIndexCreator {
        private TinyArtifactInfoIndexCreator() {
        }

        public void updateDocument(ArtifactInfo ai, Document doc) {
            if (ai.packaging != null) {
                doc.add((Fieldable)new Field("p", ai.packaging, Field.Store.YES, Field.Index.NO));
            }
            if ("maven-archetype".equals(ai.packaging) && ai.description != null) {
                doc.add((Fieldable)new Field("d", ai.description, Field.Store.YES, Field.Index.NO));
            }
        }
    }

    private static class MyScanningListener
    implements ArtifactScanningListener {
        private final MavenServerProgressIndicator p;

        MyScanningListener(MavenServerProgressIndicator indicator) {
            this.p = indicator;
        }

        public void scanningStarted(IndexingContext ctx) {
            try {
                if (this.p.isCanceled()) {
                    throw new MavenProcessCanceledRuntimeException();
                }
            }
            catch (RemoteException e) {
                throw new RuntimeRemoteException(e);
            }
        }

        public void scanningFinished(IndexingContext ctx, ScanningResult result) {
            try {
                if (this.p.isCanceled()) {
                    throw new MavenProcessCanceledRuntimeException();
                }
            }
            catch (RemoteException e) {
                throw new RuntimeRemoteException(e);
            }
        }

        public void artifactError(ArtifactContext ac, Exception e) {
        }

        public void artifactDiscovered(ArtifactContext ac) {
            try {
                if (this.p.isCanceled()) {
                    throw new MavenProcessCanceledRuntimeException();
                }
                ArtifactInfo info = ac.getArtifactInfo();
                this.p.setText2(info.groupId + ":" + info.artifactId + ":" + info.version);
            }
            catch (RemoteException e) {
                throw new RuntimeRemoteException(e);
            }
        }
    }
}

