/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.psi.PsiFile;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.extensions.GroovyRunnableScriptType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

public final class GroovyScriptUtil {
    public static final GroovyRunnableScriptType DEFAULT_TYPE = new GroovyRunnableScriptType("default"){

        @Override
        @NotNull
        public Icon getScriptIcon() {
            Icon icon = JetgroovyIcons.Groovy.GroovyFile;
            if (icon == null) {
                1.$$$reportNull$$$0(0);
            }
            return icon;
        }

        @Override
        public GroovyScriptRunner getRunner() {
            return new DefaultGroovyScriptRunner();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/runner/GroovyScriptUtil$1", "getScriptIcon"));
        }
    };

    public static boolean isSpecificScriptFile(@NotNull PsiFile file, GroovyScriptType scriptType) {
        if (file == null) {
            GroovyScriptUtil.$$$reportNull$$$0(0);
        }
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        if (!((GroovyFile)file).isScript()) {
            return false;
        }
        return GroovyScriptUtil.isSpecificScriptFile((GroovyFile)file, scriptType);
    }

    public static boolean isSpecificScriptFile(@NotNull GroovyFile script, GroovyScriptType scriptType) {
        if (script == null) {
            GroovyScriptUtil.$$$reportNull$$$0(1);
        }
        assert (script.isScript());
        if (scriptType == DEFAULT_TYPE) {
            return GroovyScriptUtil.getScriptType(script) == DEFAULT_TYPE;
        }
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])GroovyScriptTypeDetector.EP_NAME.getExtensions()) {
            if (detector.getScriptType() != scriptType || !detector.isSpecificScriptFile(script)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static GroovyRunnableScriptType getScriptType(@NotNull GroovyFile script) {
        GroovyScriptType scriptType;
        if (script == null) {
            GroovyScriptUtil.$$$reportNull$$$0(2);
        }
        GroovyRunnableScriptType groovyRunnableScriptType = (scriptType = GroovyScriptTypeDetector.getScriptType(script)) == null ? DEFAULT_TYPE : (GroovyRunnableScriptType)scriptType;
        if (groovyRunnableScriptType == null) {
            GroovyScriptUtil.$$$reportNull$$$0(3);
        }
        return groovyRunnableScriptType;
    }

    public static boolean isPlainGroovyScript(@NotNull GroovyFile script) {
        if (script == null) {
            GroovyScriptUtil.$$$reportNull$$$0(4);
        }
        return GroovyScriptTypeDetector.getScriptType(script) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/runner/GroovyScriptUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/runner/GroovyScriptUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSpecificScriptFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getScriptType";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPlainGroovyScript";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

