/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;
import org.jetbrains.plugins.groovy.lang.resolve.GrReferenceResolveRunnerKt;
import org.jetbrains.plugins.groovy.lang.resolve.ReceiverKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.SpreadKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.transformations.inline.GroovyInlineASTTransformationPerformer;
import org.jetbrains.plugins.groovy.transformations.inline.GroovyInlineTransformationUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/GrReferenceResolveRunner;", "", "place", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;Lcom/intellij/psi/scope/PsiScopeProcessor;)V", "getPlace", "()Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "getProcessor", "()Lcom/intellij/psi/scope/PsiScopeProcessor;", "processQualifier", "", "qualifier", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "state", "Lcom/intellij/psi/ResolveState;", "resolveReferenceExpression", "intellij.groovy.psi"})
public final class GrReferenceResolveRunner {
    @NotNull
    private final GrReferenceExpression place;
    @NotNull
    private final PsiScopeProcessor processor;

    public final boolean resolveReferenceExpression() {
        boolean processNonCode = !(PsiTreeUtil.skipParentsOfType((PsiElement)this.place, (Class[])new Class[]{GrReferenceExpression.class, GrAnnotationArrayInitializer.class}) instanceof GrAnnotationNameValuePair);
        ResolveState initialState = ResolveUtilKt.initialState(processNonCode);
        GrExpression qualifier = (GrExpression)this.place.getQualifier();
        if (qualifier == null) {
            if (!ResolveUtilKt.treeWalkUp(this.place, this.processor, initialState)) {
                return false;
            }
            if (!processNonCode) {
                return true;
            }
            if (this.place.getContext() instanceof GrMethodCall && !ClosureMissingMethodContributor.processMethodsFromClosures(this.place, this.processor)) {
                return false;
            }
        } else {
            ResolveState resolveState = initialState.put(ClassHint.RESOLVE_CONTEXT, (Object)qualifier);
            Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"initialState.put(RESOLVE_CONTEXT, qualifier)");
            ResolveState state = resolveState;
            if (this.place.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
                return SpreadKt.processSpread(qualifier.getType(), this.processor, state, this.place, !(this.place.getParent() instanceof GrMethodCall));
            }
            if (ResolveUtil.isClassReference(this.place)) {
                return false;
            }
            if (!this.processQualifier(qualifier, initialState)) {
                return false;
            }
        }
        if (processNonCode) {
            if (!ResolveUtil.processCategoryMembers(this.place, this.processor, initialState)) {
                return false;
            }
            GroovyInlineASTTransformationPerformer macroPerformer = GroovyInlineTransformationUtilKt.getHierarchicalInlineTransformationPerformer(this.place);
            if (macroPerformer != null && !macroPerformer.processResolve(this.processor, initialState, this.place)) {
                return false;
            }
        }
        return true;
    }

    private final boolean processQualifier(GrExpression qualifier, ResolveState state) {
        PsiType qualifierType = qualifier.getType();
        if (qualifierType == null || Intrinsics.areEqual((Object)PsiType.VOID, (Object)qualifierType)) {
            if (qualifier instanceof GrReferenceExpression) {
                PsiElement resolved = ((GrReferenceExpression)qualifier).resolve();
                if (resolved instanceof PsiClass ? !ResolveUtil.processClassDeclarations((PsiClass)resolved, this.processor, state, null, this.place) : resolved != null && !resolved.processDeclarations(this.processor, state, null, (PsiElement)this.place)) {
                    return false;
                }
                if (!(resolved instanceof PsiPackage)) {
                    PsiClassType psiClassType = TypesUtil.getJavaLangObject(this.place);
                    Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"TypesUtil.getJavaLangObject(place)");
                    PsiClassType objectQualifier = psiClassType;
                    if (!ReceiverKt.processReceiverType((PsiType)objectQualifier, this.processor, state, this.place)) {
                        return false;
                    }
                }
            }
        } else {
            if (!ReceiverKt.processReceiverType(qualifierType, this.processor, state, this.place)) {
                return false;
            }
            if (!(this.place.getParent() instanceof GrMethodCall) && !GrReferenceResolveRunnerKt.access$processImplicitSpread(qualifierType, this.processor, state, this.place)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public final GrReferenceExpression getPlace() {
        return this.place;
    }

    @NotNull
    public final PsiScopeProcessor getProcessor() {
        return this.processor;
    }

    public GrReferenceResolveRunner(@NotNull GrReferenceExpression place, @NotNull PsiScopeProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        this.place = place;
        this.processor = processor;
    }
}

