/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.inference;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.style.inference.SignatureInferenceOptionsKt;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0019\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0016*\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\f\u0010\u0019\u001a\u0004\u0018\u00010\u000f*\u00020\u001aR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/style/inference/SignatureInferenceContext;", "", "ignored", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "(Ljava/util/List;)V", "allowedToProcessReturnType", "", "getAllowedToProcessReturnType", "()Z", "allowedToResolveOperators", "getAllowedToResolveOperators", "getIgnored", "()Ljava/util/List;", "filterType", "Lcom/intellij/psi/PsiType;", "type", "context", "Lcom/intellij/psi/PsiElement;", "ignoreMethod", "method", "getTypeArguments", "", "Lcom/intellij/psi/PsiClassType;", "(Lcom/intellij/psi/PsiClassType;)[Lcom/intellij/psi/PsiType;", "staticType", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "intellij.groovy"})
public class SignatureInferenceContext {
    private final boolean allowedToProcessReturnType;
    private final boolean allowedToResolveOperators;
    @NotNull
    private final List<GrMethod> ignored;

    @NotNull
    public PsiType[] getTypeArguments(@NotNull PsiClassType $this$getTypeArguments) {
        Intrinsics.checkNotNullParameter((Object)$this$getTypeArguments, (String)"$this$getTypeArguments");
        PsiType[] psiTypeArray = $this$getTypeArguments.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"parameters");
        return psiTypeArray;
    }

    @NotNull
    public PsiType filterType(@NotNull PsiType type2, @NotNull PsiElement context) {
        PsiType psiType;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (type2 instanceof PsiPrimitiveType) {
            PsiClassType psiClassType = ((PsiPrimitiveType)type2).getBoxedType(context);
            psiType = psiClassType != null ? (PsiType)psiClassType : type2;
        } else {
            psiType = type2;
        }
        return psiType;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PsiType staticType(@NotNull GrExpression $this$staticType) {
        PsiType psiType;
        Intrinsics.checkNotNullParameter((Object)$this$staticType, (String)"$this$staticType");
        GrExpression grExpression = $this$staticType;
        if (grExpression instanceof GrMethodCall) {
            void $this$mapNotNullTo$iv$iv;
            GroovyResolveResult[] resolveResults = ((GrMethodCall)$this$staticType).multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResults, (String)"resolveResults");
            GroovyResolveResult[] $this$mapNotNull$iv = resolveResults;
            boolean $i$f$mapNotNull = false;
            GroovyResolveResult[] groovyResolveResultArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                PsiType psiType2;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                Object v0 = it;
                if (!(v0 instanceof GroovyMethodResult)) {
                    v0 = null;
                }
                if (SignatureInferenceOptionsKt.access$getStaticReturnType(v0, $this$staticType) == null) continue;
                PsiType it$iv$iv = psiType2;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List types = (List)destination$iv$iv;
            if (types.isEmpty()) {
                return ((GrMethodCall)$this$staticType).getType();
            }
            psiType = TypesUtil.getLeastUpperBoundNullable(types, ((GrMethodCall)$this$staticType).getManager());
        } else {
            psiType = $this$staticType.getType();
        }
        return psiType;
    }

    @NotNull
    public SignatureInferenceContext ignoreMethod(@NotNull GrMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)method);
        Collection $this$toTypedArray$iv = this.ignored;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        GrMethod[] grMethodArray = thisCollection$iv.toArray(new GrMethod[0]);
        if (grMethodArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        spreadBuilder.addSpread((Object)grMethodArray);
        return new SignatureInferenceContext(CollectionsKt.listOf((Object[])((GrMethod[])spreadBuilder.toArray((Object[])new GrMethod[spreadBuilder.size()]))));
    }

    public boolean getAllowedToProcessReturnType() {
        return this.allowedToProcessReturnType;
    }

    public boolean getAllowedToResolveOperators() {
        return this.allowedToResolveOperators;
    }

    @NotNull
    public final List<GrMethod> getIgnored() {
        return this.ignored;
    }

    public SignatureInferenceContext(@NotNull List<? extends GrMethod> ignored) {
        Intrinsics.checkNotNullParameter(ignored, (String)"ignored");
        this.ignored = ignored;
        this.allowedToProcessReturnType = true;
        this.allowedToResolveOperators = true;
    }
}

