/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.IncorrectOperationException;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;

public final class GroovyTemplatesFactory {
    @NonNls
    static final String NAME_TEMPLATE_PROPERTY = "NAME";
    static final String LOW_CASE_NAME_TEMPLATE_PROPERTY = "lowCaseName";

    public static PsiFile createFromTemplate(@NotNull PsiDirectory directory, @NotNull String name, @NotNull String fileName, @NotNull String templateName, boolean allowReformatting, String ... parameters2) throws IncorrectOperationException {
        String text;
        if (directory == null) {
            GroovyTemplatesFactory.$$$reportNull$$$0(0);
        }
        if (name == null) {
            GroovyTemplatesFactory.$$$reportNull$$$0(1);
        }
        if (fileName == null) {
            GroovyTemplatesFactory.$$$reportNull$$$0(2);
        }
        if (templateName == null) {
            GroovyTemplatesFactory.$$$reportNull$$$0(3);
        }
        FileTemplate template = FileTemplateManager.getInstance((Project)directory.getProject()).getInternalTemplate(templateName);
        Project project = directory.getProject();
        Properties properties = new Properties(FileTemplateManager.getInstance((Project)project).getDefaultProperties());
        JavaTemplateUtil.setPackageNameAttribute((Properties)properties, (PsiDirectory)directory);
        properties.setProperty(NAME_TEMPLATE_PROPERTY, name);
        properties.setProperty(LOW_CASE_NAME_TEMPLATE_PROPERTY, StringUtil.decapitalize((String)name));
        for (int i = 0; i < parameters2.length; i += 2) {
            properties.setProperty(parameters2[i], parameters2[i + 1]);
        }
        try {
            text = template.getText(properties);
        }
        catch (Exception e) {
            String message = "Unable to load template for " + FileTemplateManager.getInstance((Project)project).internalTemplateToSubject(templateName);
            throw new RuntimeException(message, e);
        }
        return (PsiFile)WriteAction.compute(() -> {
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
            PsiFile file = factory.createFileFromText(fileName, (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)text);
            if ((file = (PsiFile)directory.add((PsiElement)file)) != null && allowReformatting && template.isReformatCode()) {
                new ReformatCodeProcessor(project, file, null, false).run();
            }
            return file;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "directory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "fileName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "templateName";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/actions/GroovyTemplatesFactory";
        objectArray[2] = "createFromTemplate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

