/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.util.OutputWrapper;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.gradle.api.logging.LogLevel;
import org.gradle.process.internal.JvmOptions;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleConnectorService;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressListener;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsProvider;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.tooling.internal.init.Init;
import org.jetbrains.plugins.gradle.util.GradleProperties;
import org.jetbrains.plugins.gradle.util.GradlePropertiesUtil;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleExecutionHelper {
    private static final Logger LOG = Logger.getInstance(GradleExecutionHelper.class);

    @NotNull
    public <T> ModelBuilder<T> getModelBuilder(@NotNull Class<T> modelType, @NotNull ExternalSystemTaskId id, @Nullable GradleExecutionSettings settings2, @NotNull ProjectConnection connection, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (modelType == null) {
            GradleExecutionHelper.$$$reportNull$$$0(0);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(3);
        }
        ModelBuilder result = connection.model(modelType);
        if (settings2 != null) {
            GradleExecutionHelper.prepare((LongRunningOperation)result, id, settings2, listener2, connection);
        }
        ModelBuilder modelBuilder = result;
        if (modelBuilder == null) {
            GradleExecutionHelper.$$$reportNull$$$0(4);
        }
        return modelBuilder;
    }

    @NotNull
    public BuildLauncher getBuildLauncher(@NotNull ExternalSystemTaskId id, @NotNull ProjectConnection connection, @Nullable GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(5);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(6);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(7);
        }
        BuildLauncher result = connection.newBuild();
        if (settings2 != null) {
            GradleExecutionHelper.prepare((LongRunningOperation)result, id, settings2, listener2, connection);
        }
        BuildLauncher buildLauncher = result;
        if (buildLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(8);
        }
        return buildLauncher;
    }

    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings2, @NotNull Function<? super ProjectConnection, ? extends T> f) {
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(9);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(10);
        }
        return this.execute(projectPath, settings2, null, null, null, f);
    }

    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings2, @Nullable ExternalSystemTaskId taskId, @Nullable ExternalSystemTaskNotificationListener listener2, @Nullable CancellationTokenSource cancellationTokenSource, @NotNull Function<? super ProjectConnection, ? extends T> f) {
        String projectDir;
        File projectPathFile;
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(11);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(12);
        }
        if ((projectPathFile = new File(projectPath)).isFile() && projectPath.endsWith("gradle") && projectPathFile.getParent() != null) {
            List arguments;
            projectDir = projectPathFile.getParent();
            if (settings2 != null && !(arguments = settings2.getArguments()).contains("-b") && !arguments.contains("--build-file")) {
                settings2.withArguments(new String[]{"-b", projectPath});
            }
        } else {
            projectDir = projectPath;
        }
        CancellationToken cancellationToken = cancellationTokenSource != null ? cancellationTokenSource.token() : null;
        return (T)GradleConnectorService.withGradleConnection(projectDir, taskId, settings2, listener2, cancellationToken, connection -> {
            try {
                return GradleExecutionHelper.maybeFixSystemProperties(() -> f.fun(connection), projectDir);
            }
            catch (ExternalSystemException | ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.warn("Gradle execution error", e);
                Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
                ExternalSystemException externalSystemException = new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause), e, new String[0]);
                externalSystemException.initCause(e);
                throw externalSystemException;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T maybeFixSystemProperties(@NotNull Computable<T> action2, String projectDir) {
        if (action2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(13);
        }
        Map<String, String> keyToMask = ((SystemPropertiesAdjuster)ApplicationManager.getApplication().getService(SystemPropertiesAdjuster.class)).getKeyToMask(projectDir);
        HashMap<String, String> oldValues = new HashMap<String, String>();
        try {
            keyToMask.forEach((key, newVal) -> {
                String oldVal = System.getProperty(key);
                oldValues.put((String)key, oldVal);
                if (oldVal != null) {
                    SystemProperties.setProperty((String)key, (String)newVal);
                }
            });
            Object object = action2.compute();
            return (T)object;
        }
        finally {
            oldValues.forEach((k, v) -> {
                if (v != null) {
                    System.setProperty(k, v);
                }
            });
        }
    }

    public void ensureInstalledWrapper(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull CancellationToken cancellationToken) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(14);
        }
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(15);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(16);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(17);
        }
        if (cancellationToken == null) {
            GradleExecutionHelper.$$$reportNull$$$0(18);
        }
        this.ensureInstalledWrapper(id, projectPath, settings2, null, listener2, cancellationToken);
    }

    public void ensureInstalledWrapper(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull GradleExecutionSettings settings2, @Nullable GradleVersion gradleVersion2, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull CancellationToken cancellationToken) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(19);
        }
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(20);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(21);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(22);
        }
        if (cancellationToken == null) {
            GradleExecutionHelper.$$$reportNull$$$0(23);
        }
        if (!settings2.getDistributionType().isWrapped()) {
            return;
        }
        if (settings2.getDistributionType() == DistributionType.DEFAULT_WRAPPED && GradleUtil.findDefaultWrapperPropertiesFile(projectPath) != null) {
            return;
        }
        GradleConnectorService.withGradleConnection(projectPath, id, settings2, listener2, cancellationToken, connection -> {
            this.ensureInstalledWrapper(id, projectPath, settings2, gradleVersion2, listener2, (ProjectConnection)connection, cancellationToken);
            return null;
        });
    }

    /*
     * Exception decompiling
     */
    private void ensureInstalledWrapper(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull GradleExecutionSettings settings, @Nullable GradleVersion gradleVersion, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull ProjectConnection connection, @NotNull CancellationToken cancellationToken) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeWrapperTask(@NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings2, @NotNull String projectPath, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ProjectConnection connection, @NotNull CancellationToken cancellationToken) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(30);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(31);
        }
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(32);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(33);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(34);
        }
        if (cancellationToken == null) {
            GradleExecutionHelper.$$$reportNull$$$0(35);
        }
        GradleExecutionHelper.maybeFixSystemProperties(() -> {
            BuildLauncher launcher = this.getBuildLauncher(id, connection, settings2, listener2);
            launcher.withCancellationToken(cancellationToken);
            launcher.forTasks(new String[]{"wrapper"});
            launcher.run();
            return null;
        }, projectPath);
    }

    @NotNull
    private static Supplier<String> setupWrapperTaskInInitScript(@Nullable GradleVersion gradleVersion2, @NotNull GradleExecutionSettings settings2) throws IOException {
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(36);
        }
        String wrapperFilesLocationPath = FileUtil.createTempDirectory((String)"wrap", (String)"loc").getCanonicalPath();
        String jarFile = FileUtil.join((String[])new String[]{wrapperFilesLocationPath, "gradle-wrapper.jar"});
        String scriptFile = FileUtil.join((String[])new String[]{wrapperFilesLocationPath, "gradlew"});
        String fileWithPathToProperties = FileUtil.join((String[])new String[]{wrapperFilesLocationPath, "path.tmp"});
        StringJoiner lines = new StringJoiner(System.lineSeparator());
        lines.add("");
        lines.add("gradle.projectsEvaluated { gr ->");
        lines.add("  def wrapper = gr.rootProject.tasks[\"wrapper\"]");
        lines.add("  if (wrapper != null) {");
        lines.add("    if (wrapper.jarFile.exists()) {");
        lines.add("      wrapper.jarFile = new File('" + StringUtil.escapeBackSlashes((String)jarFile) + "')");
        lines.add("      wrapper.scriptFile = new File('" + StringUtil.escapeBackSlashes((String)scriptFile) + "')");
        lines.add("    }");
        if (gradleVersion2 != null) {
            lines.add("    wrapper.gradleVersion = '" + gradleVersion2.getVersion() + "'");
        }
        lines.add("    wrapper.doLast {");
        lines.add("      def fileWithPathToProperties = new File('" + StringUtil.escapeBackSlashes((String)fileWithPathToProperties) + "')");
        lines.add("      fileWithPathToProperties.write wrapper.propertiesFile.getCanonicalPath()");
        lines.add("    }");
        lines.add("  }");
        lines.add("}");
        lines.add("");
        File initScriptFile2 = GradleExecutionHelper.writeToFileGradleInitScript(lines.toString(), "wrapper_init");
        settings2.withArguments(new String[]{"--init-script", initScriptFile2.getCanonicalPath()});
        Supplier<String> supplier = () -> FileUtil.loadFileOrNull((String)fileWithPathToProperties);
        if (supplier == null) {
            GradleExecutionHelper.$$$reportNull$$$0(37);
        }
        return supplier;
    }

    @NotNull
    public TestLauncher getTestLauncher(@NotNull ExternalSystemTaskId id, @NotNull ProjectConnection connection, @NotNull List<String> tasks2, @Nullable GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(38);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(39);
        }
        if (tasks2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(40);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(41);
        }
        TestLauncher result = connection.newTestLauncher();
        if (settings2 != null) {
            GradleExecutionHelper.prepareForTestLauncher((LongRunningOperation)result, id, settings2, listener2, connection, tasks2);
        }
        TestLauncher testLauncher = result;
        if (testLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(42);
        }
        return testLauncher;
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(ProjectResolverContext projectResolverContext) {
        CancellationTokenSource cancellationTokenSource = projectResolverContext.getCancellationTokenSource();
        CancellationToken cancellationToken = cancellationTokenSource != null ? cancellationTokenSource.token() : null;
        return GradleExecutionHelper.getBuildEnvironment(projectResolverContext.getConnection(), projectResolverContext.getExternalSystemTaskId(), projectResolverContext.getListener(), cancellationToken, projectResolverContext.getSettings());
    }

    public static void prepare(@NotNull LongRunningOperation operation2, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ProjectConnection connection) {
        if (operation2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(43);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(44);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(45);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(46);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(47);
        }
        GradleExecutionHelper.prepare(operation2, id, settings2, listener2, connection, (OutputStream)new OutputWrapper(listener2, id, true), (OutputStream)new OutputWrapper(listener2, id, false), false, Collections.emptyList());
    }

    public static void prepareForTestLauncher(@NotNull LongRunningOperation operation2, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ProjectConnection connection, @NotNull List<String> tasks2) {
        if (operation2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(48);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(49);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(50);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(51);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(52);
        }
        if (tasks2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(53);
        }
        GradleExecutionHelper.prepare(operation2, id, settings2, listener2, connection, (OutputStream)new OutputWrapper(listener2, id, true), (OutputStream)new OutputWrapper(listener2, id, false), true, tasks2);
    }

    public static void prepare(@NotNull LongRunningOperation operation2, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ProjectConnection connection, @NotNull OutputStream standardOutput, @NotNull OutputStream standardError, boolean forTestLauncher, @NotNull List<String> tasks2) {
        BuildIdentifier buildIdentifier;
        String gradleVersion2;
        if (operation2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(54);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(55);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(56);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(57);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(58);
        }
        if (standardOutput == null) {
            GradleExecutionHelper.$$$reportNull$$$0(59);
        }
        if (standardError == null) {
            GradleExecutionHelper.$$$reportNull$$$0(60);
        }
        if (tasks2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(61);
        }
        List<String> jvmArgs = settings2.getJvmArguments();
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, id, listener2, (CancellationToken)null, settings2);
        String string2 = gradleVersion2 = buildEnvironment != null ? buildEnvironment.getGradle().getGradleVersion() : null;
        if (!jvmArgs.isEmpty()) {
            List<String> merged;
            if (buildEnvironment != null) {
                BuildIdentifier buildIdentifier2 = GradleExecutionHelper.getBuildIdentifier(buildEnvironment);
                List buildJvmArguments = buildIdentifier2 == null || "buildSrc".equals(buildIdentifier2.getRootDir().getName()) ? ContainerUtil.emptyList() : buildEnvironment.getJava().getJvmArguments();
                merged = GradleExecutionHelper.mergeBuildJvmArguments(buildJvmArguments, jvmArgs);
            } else {
                merged = jvmArgs;
            }
            List filteredArgs = ContainerUtil.mapNotNull((Collection)merged, s -> StringUtil.isEmpty((String)s) ? null : s);
            operation2.setJvmArguments(ArrayUtilRt.toStringArray((Collection)filteredArgs));
        }
        if (settings2.isOfflineWork()) {
            settings2.withArgument("--offline");
        }
        GradleExecutionHelper.setupLogging(settings2, buildEnvironment);
        if (forTestLauncher) {
            GradleExecutionHelper.setupTestLauncherArguments(operation2, settings2, tasks2);
        } else {
            GradleExecutionHelper.setupOperationArguments(operation2, settings2);
        }
        GradleExecutionHelper.setupEnvironment(operation2, settings2, gradleVersion2, id, listener2);
        String javaHome = settings2.getJavaHome();
        if (javaHome != null && new File(javaHome).isDirectory()) {
            LOG.debug("Java home to set for Gradle operation: " + javaHome);
            operation2.setJavaHome(new File(javaHome));
        }
        String buildRootDir = buildEnvironment == null ? null : ((buildIdentifier = GradleExecutionHelper.getBuildIdentifier(buildEnvironment)) == null ? null : buildIdentifier.getRootDir().getPath());
        GradleProgressListener gradleProgressListener = new GradleProgressListener(listener2, id, buildRootDir);
        operation2.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
        if (forTestLauncher) {
            operation2.addProgressListener((ProgressListener)gradleProgressListener, new OperationType[]{OperationType.FILE_DOWNLOAD, OperationType.TASK, OperationType.TEST, OperationType.TEST_OUTPUT});
        } else {
            operation2.addProgressListener((ProgressListener)gradleProgressListener, new OperationType[]{OperationType.TASK, OperationType.FILE_DOWNLOAD});
        }
        operation2.setStandardOutput(standardOutput);
        operation2.setStandardError(standardError);
        InputStream inputStream = (InputStream)settings2.getUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY);
        if (inputStream != null) {
            operation2.setStandardInput(inputStream);
        }
    }

    private static void setupTestLauncherArguments(@NotNull LongRunningOperation operation2, @NotNull GradleExecutionSettings settings2, @NotNull List<String> tasks2) {
        if (operation2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(62);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(63);
        }
        if (tasks2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(64);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        if (!settings2.getArguments().isEmpty()) {
            arguments.addAll(tasks2);
            GradleExecutionHelper.addSettingsArguments(arguments, settings2);
            MultiMap<String, String> testTasksConfiguration = GradleExecutionHelper.extractTestCommandOptions(arguments);
            if (operation2 instanceof TestLauncher) {
                for (Map.Entry entry : testTasksConfiguration.entrySet()) {
                    ((TestLauncher)operation2).withTaskAndTestClasses((String)entry.getKey(), (Iterable)entry.getValue());
                }
            }
        }
        GradleExecutionHelper.addIdeaParameters(arguments);
        operation2.withArguments(arguments);
    }

    private static void setupOperationArguments(@NotNull LongRunningOperation operation2, @NotNull GradleExecutionSettings settings2) {
        if (operation2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(65);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(66);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        GradleExecutionHelper.addSettingsArguments(arguments, settings2);
        Set<String> testTaskPatterns = GradleExecutionHelper.extractTestTaskPatterns(arguments);
        String path = GradleExecutionHelper.renderInitScript(testTaskPatterns);
        if (path != null) {
            ContainerUtil.addAll(arguments, (Object[])new String[]{"--init-script", path});
        }
        GradleExecutionHelper.addIdeaParameters(arguments);
        operation2.withArguments(arguments);
    }

    private static void addSettingsArguments(@NotNull ArrayList<String> arguments, @NotNull GradleExecutionSettings settings2) {
        if (arguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(67);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(68);
        }
        LOG.info("Passing command-line args to Gradle Tooling API: " + StringUtil.join(GradleExecutionHelper.obfuscatePasswordParameters(settings2.getArguments()), (String)" "));
        arguments.addAll(ContainerUtil.filter((Collection)settings2.getArguments(), it -> StringUtil.isNotEmpty((String)it)));
    }

    private static void addIdeaParameters(@NotNull ArrayList<String> arguments) {
        if (arguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(69);
        }
        arguments.add("-Didea.active=true");
        arguments.add("-Didea.version=" + GradleExecutionHelper.getIdeaVersion());
    }

    private static void setupLogging(@NotNull GradleExecutionSettings settings2, @Nullable BuildEnvironment buildEnvironment) {
        Application application;
        String gradleLogLevel;
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(70);
        }
        List arguments = settings2.getArguments();
        Collection options = GradleCommandLineOptionsProvider.LOGGING_OPTIONS.getOptions();
        List<String> optionsNames = GradleCommandLineOptionsProvider.getAllOptionsNames(options);
        if (buildEnvironment == null) {
            return;
        }
        GradleProperties properties = GradlePropertiesUtil.getGradleProperties(settings2.getServiceDirectory(), buildEnvironment.getBuildIdentifier().getRootDir().toPath());
        GradleProperties.GradleProperty<String> loggingLevelProperty = properties.getGradleLoggingLevel();
        String string2 = gradleLogLevel = loggingLevelProperty != null ? loggingLevelProperty.getValue() : null;
        if (!ContainerUtil.exists(optionsNames, it -> arguments.contains(it)) && gradleLogLevel != null) {
            try {
                LogLevel logLevel = LogLevel.valueOf((String)gradleLogLevel.toUpperCase());
                switch (logLevel) {
                    case DEBUG: {
                        settings2.withArgument("-d");
                        break;
                    }
                    case INFO: {
                        settings2.withArgument("-i");
                        break;
                    }
                    case WARN: {
                        settings2.withArgument("-w");
                        break;
                    }
                    case QUIET: {
                        settings2.withArgument("-q");
                    }
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn("org.gradle.logging.level must be one of quiet, warn, lifecycle, info, or debug");
            }
        }
        if ((application = ApplicationManager.getApplication()) != null && application.isUnitTestMode() && !ContainerUtil.exists(optionsNames, it -> arguments.contains(it))) {
            settings2.withArgument("--info");
        }
    }

    @Nullable
    private static BuildIdentifier getBuildIdentifier(@NotNull BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            GradleExecutionHelper.$$$reportNull$$$0(71);
        }
        try {
            return buildEnvironment.getBuildIdentifier();
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            return null;
        }
    }

    private static void setupEnvironment(@NotNull LongRunningOperation operation2, @NotNull GradleExecutionSettings settings2, @Nullable String gradleVersion2, ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener listener2) {
        TargetEnvironmentConfiguration environmentConfiguration2;
        boolean isEnvironmentCustomizationSupported;
        if (operation2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(72);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(73);
        }
        boolean bl = isEnvironmentCustomizationSupported = gradleVersion2 != null && GradleVersion.version((String)gradleVersion2).getBaseVersion().compareTo(GradleVersion.version((String)"3.5")) >= 0;
        if (!isEnvironmentCustomizationSupported) {
            if (!settings2.isPassParentEnvs() || !settings2.getEnv().isEmpty()) {
                listener2.onTaskOutput(taskId, String.format("The version of Gradle you are using%s does not support the environment variables customization feature. Support for this is available in Gradle 3.5 and all later versions.\n", gradleVersion2 == null ? "" : " (" + gradleVersion2 + ")"), false);
            }
            return;
        }
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider = ExternalSystemExecutionAware.Companion.getEnvironmentConfigurationProvider((ExternalSystemExecutionSettings)settings2);
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = environmentConfiguration2 = environmentConfigurationProvider != null ? environmentConfigurationProvider.getEnvironmentConfiguration() : null;
        if (environmentConfiguration2 != null && !"local".equals(environmentConfiguration2.getTypeId())) {
            if (settings2.isPassParentEnvs()) {
                LOG.warn("Host system environment variables will not be passed for the target run.");
            }
            operation2.setEnvironmentVariables(settings2.getEnv());
            return;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withEnvironment(settings2.getEnv());
        commandLine.withParentEnvironmentType(settings2.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        Map effectiveEnvironment = commandLine.getEffectiveEnvironment();
        operation2.setEnvironmentVariables(effectiveEnvironment);
    }

    @ApiStatus.Internal
    static List<String> mergeBuildJvmArguments(@NotNull List<String> jvmArgs, @NotNull List<String> jvmArgsFromIdeSettings) {
        if (jvmArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(74);
        }
        if (jvmArgsFromIdeSettings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(75);
        }
        List<String> mergedJvmArgs = GradleExecutionHelper.mergeJvmArgs(jvmArgs, jvmArgsFromIdeSettings);
        JvmOptions jvmOptions = new JvmOptions(null);
        jvmOptions.setAllJvmArgs(mergedJvmArgs);
        return jvmOptions.getAllJvmArgs();
    }

    @ApiStatus.Internal
    static List<String> mergeJvmArgs(@NotNull List<String> jvmArgs, @NotNull List<String> jvmArgsFromIdeSettings) {
        if (jvmArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(76);
        }
        if (jvmArgsFromIdeSettings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(77);
        }
        MultiMap argumentsMap = MultiMap.createLinkedSet();
        String lastKey = null;
        for (String jvmArg : ContainerUtil.concat(jvmArgs, jvmArgsFromIdeSettings)) {
            if (jvmArg.startsWith("-")) {
                argumentsMap.putValue((Object)jvmArg, (Object)"");
                lastKey = jvmArg;
                continue;
            }
            if (lastKey != null) {
                argumentsMap.putValue((Object)lastKey, (Object)jvmArg);
                lastKey = null;
                continue;
            }
            argumentsMap.putValue((Object)jvmArg, (Object)"");
        }
        LinkedHashMap<String, String> mergedKeys = new LinkedHashMap<String, String>();
        LinkedHashSet argKeySet = new LinkedHashSet(argumentsMap.keySet());
        for (String argKey : argKeySet) {
            Collection values = argumentsMap.getModifiable((Object)argKey);
            if (values.size() == 1 && ((String)values.iterator().next()).isEmpty()) {
                Couple<String> couple = GradleExecutionHelper.splitArg(argKey);
                mergedKeys.put((String)couple.first, (String)couple.second);
                continue;
            }
            mergedKeys.put(argKey, "");
            LinkedHashMap<String, String> mergedArgs = new LinkedHashMap<String, String>();
            for (String jvmArg : values) {
                if (jvmArg.isEmpty()) continue;
                Couple<String> couple = GradleExecutionHelper.splitArg(jvmArg);
                mergedArgs.put((String)couple.first, (String)couple.second);
            }
            values.clear();
            mergedArgs.forEach((key, value) -> values.add(key + value));
        }
        SmartList mergedArgs = new SmartList();
        mergedKeys.forEach((arg_0, arg_1) -> GradleExecutionHelper.lambda$mergeJvmArgs$12((List)mergedArgs, arg_0, arg_1));
        argKeySet.stream().filter(arg_0 -> GradleExecutionHelper.lambda$mergeJvmArgs$13((List)mergedArgs, arg_0)).forEach(arg_0 -> ((MultiMap)argumentsMap).remove(arg_0));
        argumentsMap.remove((Object)"--add-opens");
        SmartList result = new SmartList();
        argumentsMap.keySet().forEach(arg_0 -> GradleExecutionHelper.lambda$mergeJvmArgs$15(argumentsMap, (List)result, arg_0));
        return result;
    }

    private static Couple<String> splitArg(String arg) {
        int i = arg.indexOf(61);
        return i <= 0 ? Couple.of((Object)arg, (Object)"") : Couple.of((Object)arg.substring(0, i), (Object)arg.substring(i));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static File generateInitScript(boolean isBuildSrcProject, @NotNull Set<Class<?>> toolingExtensionClasses) {
        InputStream stream;
        if (toolingExtensionClasses == null) {
            GradleExecutionHelper.$$$reportNull$$$0(78);
        }
        if ((stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/init.gradle")) == null) {
            LOG.warn("Can't find init script template");
            return null;
        }
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            String toolingExtensionsJarPaths = GradleExecutionHelper.getToolingExtensionsJarPaths(toolingExtensionClasses);
            Object script = StreamUtil.readText((Reader)reader).replaceFirst(Pattern.quote("${EXTENSIONS_JARS_PATH}"), Matcher.quoteReplacement(toolingExtensionsJarPaths));
            if (isBuildSrcProject) {
                String buildSrcDefaultInitScript = GradleExecutionHelper.getBuildSrcDefaultInitScript();
                if (buildSrcDefaultInitScript == null) {
                    File file = null;
                    return file;
                }
                script = (String)script + buildSrcDefaultInitScript;
            }
            File file = GradleExecutionHelper.writeToFileGradleInitScript((String)script, "ijinit");
            return file;
        }
        catch (Exception e) {
            LOG.warn("Can't generate IJ gradle init script", (Throwable)e);
            return null;
        }
    }

    public static File writeToFileGradleInitScript(@NotNull String content, @NotNull String filePrefix) throws IOException {
        if (content == null) {
            GradleExecutionHelper.$$$reportNull$$$0(79);
        }
        if (filePrefix == null) {
            GradleExecutionHelper.$$$reportNull$$$0(80);
        }
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        int contentLength = contentBytes.length;
        return FileUtil.findSequentFile((File)new File(FileUtil.getTempDirectory()), (String)filePrefix, (String)"gradle", file -> {
            try {
                if (!file.exists()) {
                    FileUtil.writeToFile((File)file, (byte[])contentBytes, (boolean)false);
                    file.deleteOnExit();
                    return true;
                }
                if ((long)contentLength != file.length()) {
                    return false;
                }
                return content.equals(FileUtil.loadFile((File)file, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException iOException) {
                return false;
            }
        });
    }

    @ApiStatus.Experimental
    @NotNull
    public static Map<String, String> getConfigurationInitScripts(@NonNls GradleRunConfiguration configuration) {
        String initScript = (String)configuration.getUserData(GradleTaskManager.INIT_SCRIPT_KEY);
        if (StringUtil.isNotEmpty((String)initScript)) {
            String prefix = Objects.requireNonNull((String)configuration.getUserData(GradleTaskManager.INIT_SCRIPT_PREFIX_KEY), "init script file prefix is required");
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(prefix, initScript);
            LinkedHashMap<String, String> linkedHashMap = map;
            if (linkedHashMap == null) {
                GradleExecutionHelper.$$$reportNull$$$0(81);
            }
            return linkedHashMap;
        }
        Map<String, String> map = Collections.emptyMap();
        if (map == null) {
            GradleExecutionHelper.$$$reportNull$$$0(82);
        }
        return map;
    }

    @ApiStatus.Internal
    public static void attachTargetPathMapperInitScript(@NotNull GradleExecutionSettings executionSettings) {
        if (executionSettings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(83);
        }
        try {
            File initScriptFile2 = GradleExecutionHelper.writeToFileGradleInitScript("if(!ext.has('mapPath')) ext.mapPath = { path -> path }\n", "ijmapper");
            executionSettings.prependArguments(new String[]{"--init-script", initScriptFile2.getAbsolutePath()});
        }
        catch (IOException e) {
            LOG.warn("Can't generate IJ gradle init script", (Throwable)e);
        }
    }

    @Nullable
    public static String getBuildSrcDefaultInitScript() {
        String string2;
        InputStream stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/buildSrcInit.gradle");
        if (stream == null) {
            LOG.warn("Can't find default init script template");
            return null;
        }
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        try {
            string2 = StreamUtil.readText((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.warn("Can't use IJ gradle init script", (Throwable)e);
                return null;
            }
        }
        ((Reader)reader).close();
        return string2;
    }

    @Nullable
    public static GradleVersion getGradleVersion(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationTokenSource cancellationTokenSource) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(84);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(85);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(86);
        }
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, taskId, listener2, cancellationTokenSource, null);
        GradleVersion gradleVersion2 = null;
        if (buildEnvironment != null) {
            gradleVersion2 = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        }
        return gradleVersion2;
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationTokenSource cancellationTokenSource, @Nullable GradleExecutionSettings settings2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(87);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(88);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(89);
        }
        CancellationToken cancellationToken = cancellationTokenSource != null ? cancellationTokenSource.token() : null;
        return GradleExecutionHelper.getBuildEnvironment(connection, taskId, listener2, cancellationToken, settings2);
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken, @Nullable GradleExecutionSettings settings2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(90);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(91);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(92);
        }
        BuildEnvironment buildEnvironment = null;
        try {
            String javaHome;
            ModelBuilder modelBuilder = connection.model(BuildEnvironment.class);
            if (cancellationToken != null) {
                modelBuilder.withCancellationToken(cancellationToken);
            }
            if (settings2 != null && (javaHome = settings2.getJavaHome()) != null && new File(javaHome).isDirectory()) {
                modelBuilder.setJavaHome(new File(javaHome));
            }
            GradleProgressListener gradleProgressListener = new GradleProgressListener(listener2, taskId);
            modelBuilder.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
            modelBuilder.addProgressListener((ProgressListener)gradleProgressListener);
            modelBuilder.setStandardOutput((OutputStream)new OutputWrapper(listener2, taskId, true));
            modelBuilder.setStandardError((OutputStream)new OutputWrapper(listener2, taskId, false));
            buildEnvironment = (BuildEnvironment)modelBuilder.get();
            if (LOG.isDebugEnabled()) {
                try {
                    LOG.debug("Gradle version: " + buildEnvironment.getGradle().getGradleVersion());
                    LOG.debug("Gradle java home: " + buildEnvironment.getJava().getJavaHome());
                    LOG.debug("Gradle jvm arguments: " + buildEnvironment.getJava().getJvmArguments());
                }
                catch (Throwable t) {
                    LOG.debug(t);
                }
            }
        }
        catch (Throwable t) {
            LOG.debug(t);
        }
        return buildEnvironment;
    }

    private static Set<String> extractTestTaskPatterns(@NotNull List<String> args) {
        if (args == null) {
            GradleExecutionHelper.$$$reportNull$$$0(93);
        }
        LinkedHashSet<String> testIncludePatterns = new LinkedHashSet<String>();
        Iterator<String> it = args.iterator();
        while (it.hasNext()) {
            String next = it.next();
            if (!"--tests".equals(next)) continue;
            it.remove();
            if (!it.hasNext()) continue;
            testIncludePatterns.add(it.next());
            it.remove();
        }
        return testIncludePatterns;
    }

    static MultiMap<String, String> extractTestCommandOptions(@NotNull List<String> args) {
        if (args == null) {
            GradleExecutionHelper.$$$reportNull$$$0(94);
        }
        MultiMap taskToTestsPatterns = new MultiMap();
        HashMap<String, Option> optionsIndex = new HashMap<String, Option>();
        for (Option option : GradleCommandLineOptionsProvider.getSupportedOptions().getOptions()) {
            optionsIndex.put(option.getOpt(), option);
            optionsIndex.put(option.getLongOpt(), option);
        }
        int j = 0;
        while (j < args.size()) {
            String peek;
            String token = args.get(j);
            Option option = (Option)optionsIndex.get(StringUtil.trimLeading((String)token, (char)'-'));
            if (option != null) {
                ++j;
                if (!option.hasArg()) continue;
                ++j;
                continue;
            }
            while (j < args.size() - 2 && "--tests".equals(peek = args.get(j + 1))) {
                taskToTestsPatterns.putValue((Object)token, (Object)args.get(j + 2));
                args.remove(j + 1);
                args.remove(j + 1);
            }
            if (!taskToTestsPatterns.containsKey((Object)token)) {
                taskToTestsPatterns.putValue((Object)token, (Object)"*");
            }
            args.remove(j);
        }
        return taskToTestsPatterns;
    }

    private static String toGroovyList(@NotNull List<String> list2) {
        if (list2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(95);
        }
        String rawList = list2.stream().map(it -> GradleExecutionHelper.toGroovyString(it)).collect(Collectors.joining(","));
        return "[" + rawList + "]";
    }

    @NotNull
    public static String toGroovyString(@NotNull String string2) {
        if (string2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(96);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char ch : string2.toCharArray()) {
            if (ch == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (ch == '\'') {
                stringBuilder.append("\\'");
                continue;
            }
            if (ch == '$') {
                stringBuilder.append("\\$");
                continue;
            }
            stringBuilder.append(ch);
        }
        String string3 = "'" + stringBuilder + "'";
        if (string3 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(97);
        }
        return string3;
    }

    @Nullable
    public static String renderInitScript(@NotNull Set<String> testTasksPatterns) {
        String string2;
        InputStream stream;
        if (testTasksPatterns == null) {
            GradleExecutionHelper.$$$reportNull$$$0(98);
        }
        if ((stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/testFilterInit.gradle")) == null) {
            LOG.error("Can't find test filter init script template");
            return null;
        }
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        try {
            String testNameIncludes = Matcher.quoteReplacement(GradleExecutionHelper.toGroovyList(new ArrayList<String>(testTasksPatterns)));
            String script = StreamUtil.readText((Reader)reader).replaceFirst(Pattern.quote("${TEST_NAME_INCLUDES}"), testNameIncludes);
            File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(script, "ijtestinit");
            string2 = tempFile.getAbsolutePath();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.warn("Can't generate IJ gradle test filter init script", (Throwable)e);
                return null;
            }
        }
        ((Reader)reader).close();
        return string2;
    }

    @NotNull
    public static String getToolingExtensionsJarPaths(@NotNull Set<Class<?>> toolingExtensionClasses) {
        if (toolingExtensionClasses == null) {
            GradleExecutionHelper.$$$reportNull$$$0(99);
        }
        Set jarPaths = ContainerUtil.map2SetNotNull(toolingExtensionClasses, aClass -> {
            String path = PathManager.getJarPathForClass((Class)aClass);
            if (path != null) {
                if (FileUtilRt.getNameWithoutExtension((String)path).equals("gradle-api-" + GradleVersion.current().getBaseVersion())) {
                    LOG.warn("The gradle api jar shouldn't be added to the gradle daemon classpath: {" + aClass + "," + path + "}");
                    return null;
                }
                return FileUtil.toCanonicalPath((String)path);
            }
            return null;
        });
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        Iterator it = jarPaths.iterator();
        while (it.hasNext()) {
            String jarPath = (String)it.next();
            buf.append("mapPath(\"").append(jarPath).append("\")");
            if (!it.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        String string2 = buf.toString();
        if (string2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(100);
        }
        return string2;
    }

    @NotNull
    static List<String> obfuscatePasswordParameters(@NotNull List<String> commandLineArguments) {
        if (commandLineArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(101);
        }
        ArrayList<String> replaced = new ArrayList<String>(commandLineArguments.size());
        String PASSWORD_PARAMETER_IDENTIFIER = ".password=";
        for (String option : commandLineArguments) {
            int index = option.indexOf(".password=");
            if (index == -1) {
                replaced.add(option);
                continue;
            }
            replaced.add(option.substring(0, index + ".password=".length()) + "*********");
        }
        ArrayList<String> arrayList = replaced;
        if (arrayList == null) {
            GradleExecutionHelper.$$$reportNull$$$0(102);
        }
        return arrayList;
    }

    private static String getIdeaVersion() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        return appInfo.getMajorVersion() + "." + appInfo.getMinorVersion();
    }

    private static /* synthetic */ void lambda$mergeJvmArgs$15(MultiMap argumentsMap, List result, String key) {
        argumentsMap.get((Object)key).forEach(val -> {
            result.add(key);
            if (StringUtil.isNotEmpty((String)val)) {
                result.add(val);
            }
        });
    }

    private static /* synthetic */ boolean lambda$mergeJvmArgs$13(List mergedArgs, String argKey) {
        return !mergedArgs.contains(argKey);
    }

    private static /* synthetic */ void lambda$mergeJvmArgs$12(List mergedArgs, String s1, String s2) {
        mergedArgs.add(s1 + s2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 37: 
            case 42: 
            case 81: 
            case 82: 
            case 97: 
            case 100: 
            case 102: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 37: 
            case 42: 
            case 81: 
            case 82: 
            case 97: 
            case 100: 
            case 102: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelType";
                break;
            }
            case 1: 
            case 5: 
            case 14: 
            case 19: 
            case 24: 
            case 30: 
            case 38: 
            case 44: 
            case 49: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 6: 
            case 28: 
            case 34: 
            case 39: 
            case 47: 
            case 52: 
            case 58: 
            case 84: 
            case 87: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 7: 
            case 17: 
            case 22: 
            case 27: 
            case 33: 
            case 41: 
            case 46: 
            case 51: 
            case 57: 
            case 86: 
            case 89: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 8: 
            case 37: 
            case 42: 
            case 81: 
            case 82: 
            case 97: 
            case 100: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 20: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 16: 
            case 21: 
            case 26: 
            case 31: 
            case 36: 
            case 45: 
            case 50: 
            case 56: 
            case 63: 
            case 66: 
            case 68: 
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 18: 
            case 23: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationToken";
                break;
            }
            case 40: 
            case 53: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 43: 
            case 48: 
            case 54: 
            case 62: 
            case 65: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardOutput";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardError";
                break;
            }
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildEnvironment";
                break;
            }
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmArgs";
                break;
            }
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmArgsFromIdeSettings";
                break;
            }
            case 78: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolingExtensionClasses";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePrefix";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionSettings";
                break;
            }
            case 85: 
            case 88: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 93: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testTasksPatterns";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildLauncher";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "setupWrapperTaskInInitScript";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestLauncher";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationInitScripts";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "toGroovyString";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolingExtensionsJarPaths";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "obfuscatePasswordParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModelBuilder";
                break;
            }
            case 4: 
            case 8: 
            case 37: 
            case 42: 
            case 81: 
            case 82: 
            case 97: 
            case 100: 
            case 102: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBuildLauncher";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "maybeFixSystemProperties";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "ensureInstalledWrapper";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "executeWrapperTask";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setupWrapperTaskInInitScript";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getTestLauncher";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "prepareForTestLauncher";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "setupTestLauncherArguments";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "setupOperationArguments";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsArguments";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "addIdeaParameters";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "setupLogging";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getBuildIdentifier";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "setupEnvironment";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "mergeBuildJvmArguments";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "mergeJvmArgs";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "generateInitScript";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "writeToFileGradleInitScript";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "attachTargetPathMapperInitScript";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getGradleVersion";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getBuildEnvironment";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "extractTestTaskPatterns";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "extractTestCommandOptions";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "toGroovyList";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "toGroovyString";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "renderInitScript";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getToolingExtensionsJarPaths";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "obfuscatePasswordParameters";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 8: 
            case 37: 
            case 42: 
            case 81: 
            case 82: 
            case 97: 
            case 100: 
            case 102: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static class SystemPropertiesAdjuster {
        public SystemPropertiesAdjuster() {
            LOG.info("Gradle system adjuster service: " + this.getClass().getName());
        }

        public Map<String, String> getKeyToMask(@NotNull String projectDir) {
            if (projectDir == null) {
                SystemPropertiesAdjuster.$$$reportNull$$$0(0);
            }
            HashMap<String, String> propertiesFixes = new HashMap<String, String>();
            if (Registry.is((String)"gradle.tooling.adjust.user.dir", (boolean)true)) {
                propertiesFixes.put("user.dir", projectDir);
            }
            propertiesFixes.put("java.system.class.loader", null);
            return propertiesFixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDir", "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper$SystemPropertiesAdjuster", "getKeyToMask"));
        }
    }
}

