/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.externalSystem.issue.quickfix.ReimportQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleVersionQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleWrapperSettingsOpenQuickFix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnsupportedGradleVersionIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "Companion", "intellij.gradle.common"})
@ApiStatus.Internal
public final class UnsupportedGradleVersionIssueChecker
implements GradleIssueChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Unable to fully structure code
     */
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        rootCauseText = rootCause.toString();
        gradleVersionUsed = null;
        if (issueData.getBuildEnvironment() != null) {
            v0 = issueData.getBuildEnvironment().getGradle();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"issueData.buildEnvironment.gradle");
            gradleVersionUsed = GradleVersion.version((String)v0.getGradleVersion());
        }
        v1 = rootCause;
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"rootCause");
        isOldGradleClasspathInfererIssue = org.jetbrains.plugins.gradle.issue.UnsupportedGradleVersionIssueChecker$Companion.access$causedByOldGradleClasspathInferer(UnsupportedGradleVersionIssueChecker.Companion, gradleVersionUsed, v1);
        if (!isOldGradleClasspathInfererIssue && !StringsKt.startsWith$default((String)rootCauseText, (String)"org.gradle.tooling.UnsupportedVersionException: ", (boolean)false, (int)2, null)) {
            return null;
        }
        if (isOldGradleClasspathInfererIssue || StringsKt.endsWith$default((String)rootCauseText, (String)"does not support the ModelBuilder API. Support for this is available in Gradle 1.2 and all later versions.", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v2 = gradleVersionUsed;
        if (v2 != null) {
            it = var7_6 = v2;
            $i$a$-let-UnsupportedGradleVersionIssueChecker$check$isAncientGradleVersion$1 = false;
            ** if (!(it.compareTo((GradleVersion)GradleVersion.version((String)"3.0")) < 0)) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v3 = true;
            ** GOTO lbl24
        }
lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
lbl24:
        // 2 sources

        isAncientGradleVersion = v3;
        unsupportedVersionMessagePrefix = "org.gradle.tooling.UnsupportedVersionException: Support for builds using Gradle versions older than ";
        if (!isAncientGradleVersion && !StringsKt.startsWith$default((String)rootCauseText, (String)unsupportedVersionMessagePrefix, (boolean)false, (int)2, null)) {
            return null;
        }
        minRequiredVersionCandidate = null;
        minRequiredVersionCandidate = isAncientGradleVersion != false ? "3.0" : StringsKt.substringBefore((String)StringsKt.substringAfter$default((String)rootCauseText, (String)unsupportedVersionMessagePrefix, null, (int)2, null), (String)" ", (String)"");
        try {
            var10_11 = GradleVersion.version((String)minRequiredVersionCandidate);
        }
        catch (IllegalArgumentException e) {
            var10_11 = GradleVersion.current();
        }
        gradleMinimumVersionRequired = var10_11;
        quickFixes = new ArrayList<E>();
        issueDescription = new StringBuilder();
        gradleVersionString = gradleVersionUsed != null ? gradleVersionUsed.getVersion() : "version";
        v4 = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"ApplicationInfoImpl.getShadowInstance()");
        appInfo = v4;
        ideVersion = appInfo.getVersionName() + " " + appInfo.getMajorVersion() + "." + appInfo.getMinorVersion();
        issueDescription.append("Unsupported Gradle. \n").append("The project uses Gradle " + gradleVersionString + " which is incompatible with " + ideVersion + ".\n");
        issueDescription.append("\nPossible solution:\n");
        wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile(issueData.getProjectPath());
        if (wrapperPropertiesFile == null || gradleVersionUsed != null && gradleVersionUsed.getBaseVersion().compareTo(gradleMinimumVersionRequired) < 0) {
            v5 = issueData.getProjectPath();
            v6 = gradleMinimumVersionRequired;
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"gradleMinimumVersionRequired");
            gradleVersionFix = new GradleVersionQuickFix(v5, v6, true);
            issueDescription.append(" - <a href=\"" + gradleVersionFix.getId() + "\">Upgrade Gradle wrapper to " + gradleMinimumVersionRequired.getVersion() + " version and re-import the project</a>\n");
            quickFixes.add(gradleVersionFix);
        } else {
            wrapperSettingsOpenQuickFix = new GradleWrapperSettingsOpenQuickFix(issueData.getProjectPath(), "distributionUrl");
            v7 = issueData.getProjectPath();
            v8 = GradleConstants.SYSTEM_ID;
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"GradleConstants.SYSTEM_ID");
            reimportQuickFix = new ReimportQuickFix(v7, v8);
            v9 = wrapperSettingsOpenQuickFix.getId();
            v10 = gradleMinimumVersionRequired;
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"gradleMinimumVersionRequired");
            issueDescription.append(" - <a href=\"" + v9 + "\">Open Gradle wrapper settings</a>, upgrade version to " + v10.getVersion() + " or newer and <a href=\"" + reimportQuickFix.getId() + "\">reload the project</a>\n");
            quickFixes.add(wrapperSettingsOpenQuickFix);
            quickFixes.add(reimportQuickFix);
        }
        v11 = issueDescription.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"issueDescription.toString()");
        description = v11;
        v12 = BuildConsoleUtils.getMessageTitle((String)description);
        Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getMessageTitle(description)");
        title = v12;
        return new BuildIssue(title, description, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ String $title;
            final /* synthetic */ String $description;
            final /* synthetic */ List $quickFixes;

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
            {
                this.$title = $captured_local_variable$0;
                this.$description = $captured_local_variable$1;
                this.$quickFixes = $captured_local_variable$2;
                this.title = $captured_local_variable$0;
                this.description = $captured_local_variable$1;
                this.quickFixes = $captured_local_variable$2;
            }
        };
    }

    @Override
    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return GradleIssueChecker.DefaultImpls.consumeBuildOutputFailureMessage(this, message, failureCause, stacktrace, location, parentEventId, messageConsumer);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnsupportedGradleVersionIssueChecker$Companion;", "", "()V", "causedByOldGradleClasspathInferer", "", "gradleVersionUsed", "Lorg/gradle/util/GradleVersion;", "rootCause", "", "intellij.gradle.common"})
    public static final class Companion {
        private final boolean causedByOldGradleClasspathInferer(GradleVersion gradleVersionUsed, Throwable rootCause) {
            String string2 = rootCause.getMessage();
            if (string2 == null) {
                return false;
            }
            String message = string2;
            if (!StringsKt.startsWith$default((String)message, (String)"Cannot determine classpath for resource", (boolean)false, (int)2, null)) {
                return false;
            }
            if (gradleVersionUsed == null) {
                StackTraceElement stackTraceElement;
                block5: {
                    StackTraceElement[] stackTraceElementArray;
                    StackTraceElement[] stackTraceElementArray2 = rootCause.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray2, (String)"rootCause.stackTrace");
                    StackTraceElement[] stackTraceElementArray3 = stackTraceElementArray = stackTraceElementArray2;
                    int n = stackTraceElementArray3.length;
                    for (int i = 0; i < n; ++i) {
                        StackTraceElement stackTraceElement2;
                        StackTraceElement it = stackTraceElement2 = stackTraceElementArray3[i];
                        boolean bl = false;
                        StackTraceElement stackTraceElement3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement3, (String)"it");
                        if (!Intrinsics.areEqual((Object)stackTraceElement3.getClassName(), (Object)"org.gradle.tooling.internal.provider.ClasspathInferer")) continue;
                        stackTraceElement = stackTraceElement2;
                        break block5;
                    }
                    stackTraceElement = null;
                }
                return stackTraceElement != null;
            }
            GradleVersion gradleVersion2 = gradleVersionUsed.getBaseVersion();
            if (gradleVersion2 == null) {
                return true;
            }
            return gradleVersion2.compareTo(GradleVersion.version((String)"3.0")) < 0;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$causedByOldGradleClasspathInferer(Companion $this, GradleVersion gradleVersionUsed, Throwable rootCause) {
            return $this.causedByOldGradleClasspathInferer(gradleVersionUsed, rootCause);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

