/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipAndTrickPromotionFactory;
import com.intellij.ide.util.TipDialog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.FeaturesTrainerIcons;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.course.Lesson;
import training.statistic.LessonStartingWay;
import training.statistic.StatisticBase;
import training.ui.UISettings;
import training.util.RoundedPanel;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Ltraining/ui/IftTipAndTrickPromoter;", "Lcom/intellij/ide/util/TipAndTrickPromotionFactory;", "()V", "createOpenLessonPanel", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "lesson", "Ltraining/learn/course/Lesson;", "tip", "Lcom/intellij/ide/util/TipAndTrickBean;", "createPromotionPanel", "findLessonForTip", "intellij.featuresTrainer"})
public final class IftTipAndTrickPromoter
implements TipAndTrickPromotionFactory {
    @Nullable
    public JPanel createPromotionPanel(@NotNull Project project, @NotNull TipAndTrickBean tip) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tip, (String)"tip");
        Lesson lesson = this.findLessonForTip(tip);
        if (lesson == null) {
            return null;
        }
        Lesson lesson2 = lesson;
        return this.createOpenLessonPanel(project, lesson2, tip);
    }

    /*
     * WARNING - void declaration
     */
    private final Lesson findLessonForTip(TipAndTrickBean tip) {
        void $this$filterTo$iv$iv;
        String string = tip.fileName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tip.fileName");
        String tipId = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"neue-"), (CharSequence)".html");
        CourseManager courseManager = CourseManager.Companion.getInstance();
        Iterable $this$filter$iv = courseManager.getLessonsForModules();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Lesson it = (Lesson)element$iv$iv;
            boolean bl = false;
            if (!it.getSuitableTips().contains(tipId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lessons = (List)destination$iv$iv;
        $this$filter$iv = lessons;
        if (!$this$filter$iv.isEmpty()) {
            if (lessons.size() > 1) {
                IftTipAndTrickPromoter $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(IftTipAndTrickPromoter.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn(tip + " declared as suitable in more than one lesson: " + lessons);
            }
            return (Lesson)lessons.get(0);
        }
        return null;
    }

    private final JPanel createOpenLessonPanel(Project project, Lesson lesson, TipAndTrickBean tip) {
        RoundedPanel container = new RoundedPanel(8);
        container.setLayout(new BoxLayout(container, 0));
        container.setBackground(UISettings.Companion.getInstance().getShortcutBackgroundColor());
        JLabel promotionLabel = new JLabel(LearnBundle.INSTANCE.message("tip.and.trick.promotion.label", new Object[0]));
        promotionLabel.setIcon(FeaturesTrainerIcons.Img.FeatureTrainerBanner);
        promotionLabel.setIconTextGap(JBUI.scale((int)6));
        container.add(Box.createRigidArea((Dimension)new JBDimension(12, 28)));
        container.add(promotionLabel);
        container.add(Box.createHorizontalGlue());
        ActionLink openLessonLink2 = new ActionLink(LearnBundle.INSTANCE.message("tip.and.trick.promotion.open.lesson", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(project, lesson, tip){
            final /* synthetic */ Project $project;
            final /* synthetic */ Lesson $lesson;
            final /* synthetic */ TipAndTrickBean $tip;

            public final void invoke(@NotNull ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TipDialog.hideForProject((Project)this.$project);
                if (!this.$project.isDisposed()) {
                    CourseManager.openLesson$default(CourseManager.Companion.getInstance(), this.$project, this.$lesson, LessonStartingWay.TIP_AND_TRICK_PROMOTER, true, false, 16, null);
                    String string = this.$lesson.getId();
                    String string2 = this.$tip.fileName;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tip.fileName");
                    StatisticBase.Companion.logLessonLinkClickedFromTip(string, string2);
                }
            }
            {
                this.$project = project;
                this.$lesson = lesson;
                this.$tip = tipAndTrickBean;
                super(1);
            }
        });
        container.add((Component)openLessonLink2);
        container.add(Box.createRigidArea((Dimension)new JBDimension(12, 28)));
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new BoxLayout(wrapper, 0));
        wrapper.setBackground(UIUtil.getTextFieldBackground());
        wrapper.setBorder((Border)new JBEmptyBorder(8, 12, 8, 12));
        wrapper.add(container);
        return wrapper;
    }
}

