/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.Platform;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShStringUtil;
import com.intellij.sh.run.ShBeforeRunProviderDelegate;
import com.intellij.sh.run.ShConfigurationType;
import com.intellij.sh.run.ShRunConfiguration;
import com.intellij.sh.run.ShRunner;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ShRunConfigurationProfileState
implements RunProfileState {
    private final Project myProject;
    private final ShRunConfiguration myRunConfiguration;

    ShRunConfigurationProfileState(@NotNull Project project, @NotNull ShRunConfiguration runConfiguration) {
        if (project == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        ShRunner shRunner;
        if (runner == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(2);
        }
        if (this.myRunConfiguration.isExecuteInTerminal() && !this.isRunBeforeConfig() && (shRunner = (ShRunner)ApplicationManager.getApplication().getService(ShRunner.class)) != null && shRunner.isAvailable(this.myProject)) {
            shRunner.run(this.myProject, this.buildCommand(), this.myRunConfiguration.getScriptWorkingDirectory(), this.myRunConfiguration.getName(), this.isActivateToolWindow());
            return null;
        }
        return this.buildExecutionResult();
    }

    private boolean isActivateToolWindow() {
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)this.myProject).findSettings((RunConfiguration)this.myRunConfiguration);
        return settings == null || settings.isActivateToolWindowBeforeRun();
    }

    private ExecutionResult buildExecutionResult() throws ExecutionException {
        GeneralCommandLine commandLine = this.myRunConfiguration.isExecuteScriptFile() ? this.createCommandLineForFile() : this.createCommandLineForScript();
        ProcessHandler processHandler = ShRunConfigurationProfileState.createProcessHandler(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        TerminalExecutionConsole console = new TerminalExecutionConsole(this.myProject, processHandler);
        console.attachToProcess(processHandler);
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler);
    }

    @NotNull
    private static ProcessHandler createProcessHandler(GeneralCommandLine commandLine) throws ExecutionException {
        return new KillableProcessHandler(commandLine){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                return new BaseOutputReader.Options(){

                    public BaseDataReader.SleepingPolicy policy() {
                        return BaseDataReader.SleepingPolicy.BLOCKING;
                    }

                    public boolean splitToLines() {
                        return false;
                    }
                };
            }
        };
    }

    @NotNull
    private GeneralCommandLine createCommandLineForScript() {
        PtyCommandLine commandLine = new PtyCommandLine();
        commandLine.withConsoleMode(false);
        commandLine.withInitialColumns(120);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.setWorkDirectory(this.myRunConfiguration.getScriptWorkingDirectory());
        commandLine.withExePath((String)ObjectUtils.notNull((Object)ShConfigurationType.getDefaultShell(), (Object)"/bin/sh"));
        commandLine.withParameters(new String[]{"-c"});
        commandLine.withParameters(new String[]{this.myRunConfiguration.getScriptText()});
        PtyCommandLine ptyCommandLine = commandLine;
        if (ptyCommandLine == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(3);
        }
        return ptyCommandLine;
    }

    @NotNull
    private GeneralCommandLine createCommandLineForFile() throws ExecutionException {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(this.myRunConfiguration.getScriptPath());
        if (virtualFile == null || virtualFile.getParent() == null) {
            throw new ExecutionException(ShBundle.message("error.message.cannot.determine.shell.script.parent.directory", new Object[0]));
        }
        WSLDistribution wslDistribution = ShRunConfiguration.getWSLDistributionIfNeeded(this.myRunConfiguration.getInterpreterPath(), this.myRunConfiguration.getScriptPath());
        PtyCommandLine commandLine = new PtyCommandLine();
        if (!SystemInfo.isWindows || wslDistribution != null) {
            commandLine.getEnvironment().put("TERM", "xterm-256color");
        }
        commandLine.withConsoleMode(false);
        commandLine.withInitialColumns(120);
        commandLine.withEnvironment(this.myRunConfiguration.getEnvData().getEnvs());
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.setWorkDirectory(this.myRunConfiguration.getScriptWorkingDirectory());
        commandLine.setExePath(ShRunConfigurationProfileState.convertToWslIfNeeded(this.myRunConfiguration.getInterpreterPath(), wslDistribution));
        if (StringUtil.isNotEmpty((String)this.myRunConfiguration.getInterpreterOptions())) {
            commandLine.addParameters(ParametersListUtil.parse((String)this.myRunConfiguration.getInterpreterOptions()));
        }
        commandLine.addParameter(ShRunConfigurationProfileState.convertToWslIfNeeded(this.myRunConfiguration.getScriptPath(), wslDistribution));
        if (StringUtil.isNotEmpty((String)this.myRunConfiguration.getScriptOptions())) {
            commandLine.addParameters(ParametersListUtil.parse((String)this.myRunConfiguration.getScriptOptions()));
        }
        if (wslDistribution != null) {
            commandLine = (PtyCommandLine)wslDistribution.patchCommandLine((GeneralCommandLine)commandLine, this.myProject, null, false);
        }
        PtyCommandLine ptyCommandLine = commandLine;
        if (ptyCommandLine == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(4);
        }
        return ptyCommandLine;
    }

    private boolean isRunBeforeConfig() {
        Key<Boolean> userDataKey = ShBeforeRunProviderDelegate.getRunBeforeUserDataKey((RunConfiguration)this.myRunConfiguration);
        Boolean userDataValue = (Boolean)this.myProject.getUserData(userDataKey);
        boolean isRunBeforeConfig = userDataValue != null && userDataValue != false;
        this.myRunConfiguration.getProject().putUserData(userDataKey, (Object)false);
        return isRunBeforeConfig;
    }

    @NotNull
    private String buildCommand() {
        if (this.myRunConfiguration.isExecuteScriptFile()) {
            WSLDistribution wslDistribution = ShRunConfiguration.getWSLDistributionIfNeeded(this.myRunConfiguration.getInterpreterPath(), this.myRunConfiguration.getScriptPath());
            ArrayList<String> commandLine = new ArrayList<String>();
            ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getEnvData().getEnvs());
            ShRunConfigurationProfileState.addIfPresent(commandLine, ShRunConfigurationProfileState.adaptPathForExecution(this.myRunConfiguration.getInterpreterPath(), wslDistribution));
            ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getInterpreterOptions());
            commandLine.add(ShRunConfigurationProfileState.adaptPathForExecution(this.myRunConfiguration.getScriptPath(), wslDistribution));
            ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getScriptOptions());
            String string = String.join((CharSequence)" ", commandLine);
            if (string == null) {
                ShRunConfigurationProfileState.$$$reportNull$$$0(5);
            }
            return string;
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getEnvData().getEnvs(), true);
        ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getScriptText());
        String string = String.join((CharSequence)" ", commandLine);
        if (string == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static void addIfPresent(@NotNull List<String> commandLine, @Nullable String options) {
        if (commandLine == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(7);
        }
        ContainerUtil.addIfNotNull(commandLine, (Object)StringUtil.nullize((String)options));
    }

    private static void addIfPresent(@NotNull List<String> commandLine, @NotNull Map<String, String> envs) {
        if (commandLine == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(8);
        }
        if (envs == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(9);
        }
        ShRunConfigurationProfileState.addIfPresent(commandLine, envs, false);
    }

    private static void addIfPresent(@NotNull List<String> commandLine, @NotNull Map<String, String> envs, boolean endWithSemicolon) {
        if (commandLine == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(10);
        }
        if (envs == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(11);
        }
        int index = 0;
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            String quotedString;
            String key = entry.getKey();
            String value = entry.getValue();
            if (Platform.current() != Platform.WINDOWS) {
                quotedString = ShStringUtil.quote(value);
            } else {
                String escapedValue = StringUtil.escapeQuotes((String)value);
                String string = quotedString = StringUtil.containsWhitespaces((CharSequence)value) ? (String)StringUtil.QUOTER.apply(escapedValue) : escapedValue;
            }
            if (endWithSemicolon) {
                String semicolon = "";
                if (index == envs.size() - 1) {
                    semicolon = ";";
                }
                commandLine.add("export " + key + "=" + quotedString + semicolon);
            } else {
                commandLine.add(key + "=" + quotedString);
            }
            ++index;
        }
    }

    private static String adaptPathForExecution(@NotNull String systemDependentPath, @Nullable WSLDistribution wslDistribution) {
        if (systemDependentPath == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(12);
        }
        if (wslDistribution != null) {
            return wslDistribution.getWslPath(systemDependentPath);
        }
        if (Platform.current() != Platform.WINDOWS) {
            return ShStringUtil.quote(systemDependentPath);
        }
        String escapedPath = StringUtil.escapeQuotes((String)systemDependentPath);
        return StringUtil.containsWhitespaces((CharSequence)systemDependentPath) ? (String)StringUtil.QUOTER.apply(escapedPath) : escapedPath;
    }

    private static String convertToWslIfNeeded(@NotNull String path, @Nullable WSLDistribution wslDistribution) {
        if (path == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(13);
        }
        if (path.isEmpty()) {
            return path;
        }
        if (wslDistribution != null) {
            return wslDistribution.getWslPath(path);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/run/ShRunConfigurationProfileState";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemDependentPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/run/ShRunConfigurationProfileState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLineForScript";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLineForFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addIfPresent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "adaptPathForExecution";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertToWslIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

