/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.completion;

import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sh.ShLanguage;
import com.intellij.sh.completion.ShCompletionUtil;
import com.intellij.sh.lexer.ShTokenTypes;
import com.intellij.sh.psi.ShCommandsList;
import com.intellij.sh.psi.ShFile;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShCommandCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final int BUILTIN_PRIORITY = -10;
    @NonNls
    private static final List<String> BUILTIN = Arrays.asList("alias", "bg", "bind", "break", "builtin", "caller", "cd", "command", "compgen", "complete", "continue", "declare", "dirs", "disown", "echo", "enable", "eval", "exec", "exit", "export", "false", "fc", "fg", "getopts", "hash", "help", "history", "jobs", "kill", "let", "local", "logout", "popd", "printf", "pushd", "pwd", "read", "readonly", "return", "set", "shift", "shopt", "source", "suspend", "test", "times", "trap", "true", "type", "typeset", "ulimit", "umask", "unalias", "unset", "wait");

    public ShCommandCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)ShCommandCompletionContributor.elementPattern(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (ShCompletionUtil.endsWithDot(parameters)) {
                    return;
                }
                Object kws = new SmartList();
                PsiElement original = parameters.getOriginalPosition();
                if (original == null || !original.getText().contains("/")) {
                    result.addAllElements((Iterable)ContainerUtil.map(BUILTIN, s -> PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)s).withIcon(PlatformIcons.FUNCTION_ICON).withInsertHandler(AddSpaceInsertHandler.INSTANCE), (double)-10.0)));
                    kws = ShCommandCompletionContributor.suggestKeywords(parameters.getPosition());
                    Iterator iterator = kws.iterator();
                    while (iterator.hasNext()) {
                        String keywords = (String)iterator.next();
                        result.addElement((LookupElement)LookupElementBuilder.create((String)keywords).bold().withInsertHandler(AddSpaceInsertHandler.INSTANCE));
                    }
                }
                kws.addAll(BUILTIN);
                Arrays.stream(ShTokenTypes.HUMAN_READABLE_KEYWORDS.getTypes()).map(IElementType::toString).forEach(((Collection)kws)::add);
                String prefix = CompletionUtil.findJavaIdentifierPrefix((CompletionParameters)parameters);
                if (prefix.isEmpty() && parameters.isAutoPopup()) {
                    return;
                }
                CompletionResultSet resultSetWithPrefix = result.withPrefixMatcher(prefix);
                WordCompletionContributor.addWordCompletionVariants((CompletionResultSet)resultSetWithPrefix, (CompletionParameters)parameters, new HashSet(kws));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sh/completion/ShCommandCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static Collection<String> suggestKeywords(PsiElement position) {
        TextRange posRange = position.getTextRange();
        ShFile posFile = (ShFile)position.getContainingFile();
        ShCommandsList parent = (ShCommandsList)PsiTreeUtil.getTopmostParentOfType((PsiElement)position, ShCommandsList.class);
        TextRange range = new TextRange(parent == null ? 0 : parent.getTextRange().getStartOffset(), posRange.getStartOffset());
        String text = range.isEmpty() ? "IntellijIdeaRulezzz " : range.substring(posFile.getText());
        PsiFile file = PsiFileFactory.getInstance((Project)posFile.getProject()).createFileFromText("a.sh", ShLanguage.INSTANCE, (CharSequence)text, true, false);
        int completionOffset = posRange.getStartOffset() - range.getStartOffset();
        GeneratedParserUtilBase.CompletionState state = new GeneratedParserUtilBase.CompletionState(completionOffset){

            public String convertItem(Object o) {
                if (o instanceof IElementType[] && ((IElementType[])o).length > 0) {
                    return this.kw2str(((IElementType[])o)[0]);
                }
                return o instanceof IElementType ? this.kw2str((IElementType)o) : null;
            }

            @Nullable
            private String kw2str(IElementType o) {
                return ShTokenTypes.HUMAN_READABLE_KEYWORDS_WITHOUT_TEMPLATES.contains(o) ? o.toString() : null;
            }
        };
        file.putUserData(GeneratedParserUtilBase.COMPLETION_STATE_KEY, (Object)state);
        TreeUtil.ensureParsed((ASTNode)file.getNode());
        return state.items;
    }

    private static PsiElementPattern.Capture<PsiElement> elementPattern() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement().andNot((ElementPattern)PlatformPatterns.psiElement().andOr(new ElementPattern[]{ShCompletionUtil.insideForClause(), ShCompletionUtil.insideIfDeclaration(), ShCompletionUtil.insideWhileDeclaration(), ShCompletionUtil.insideUntilDeclaration(), ShCompletionUtil.insideFunctionDefinition(), ShCompletionUtil.insideSelectDeclaration(), ShCompletionUtil.insideCaseDeclaration(), ShCompletionUtil.insideCondition(), ShCompletionUtil.insideComment()}));
    }
}

