/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.internal.impldep.com.beust.jcommander.JCommander;
import org.gradle.internal.impldep.com.beust.jcommander.Parameter;
import org.gradle.internal.impldep.com.beust.jcommander.ParameterException;
import org.gradle.internal.impldep.org.testng.TestNGException;
import org.gradle.internal.impldep.org.testng.collections.Sets;
import org.gradle.internal.impldep.org.testng.internal.Yaml;
import org.gradle.internal.impldep.org.testng.xml.Parser;
import org.gradle.internal.impldep.org.testng.xml.XmlSuite;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converter {
    @Parameter(description="file1 [file2 file3...]", required=true)
    private List<String> m_files;
    @Parameter(names={"-d"}, description="The directory where the file(s) will be created")
    private String m_outputDirectory = ".";

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
        Converter c = new Converter();
        c.run(args);
    }

    private void findAllSuites(Collection<XmlSuite> suites, Set<XmlSuite> result) {
        for (XmlSuite s : suites) {
            result.add(s);
            for (XmlSuite xs : s.getChildSuites()) {
                this.findAllSuites(Arrays.asList(xs), result);
            }
        }
    }

    private void run(String[] args) throws ParserConfigurationException, SAXException, IOException {
        JCommander jc = new JCommander(this);
        try {
            jc.parse(args);
            File f = new File(this.m_outputDirectory);
            if (!f.exists()) {
                f.mkdir();
            }
            for (String file : this.m_files) {
                Set<XmlSuite> allSuites = Sets.newHashSet();
                Parser parser = new Parser(file);
                parser.setLoadClasses(false);
                this.findAllSuites(parser.parse(), allSuites);
                for (XmlSuite suite : allSuites) {
                    File newFile;
                    String fileName = suite.getFileName();
                    int ind = fileName.lastIndexOf(".");
                    String bn = fileName.substring(0, ind);
                    int ind2 = bn.lastIndexOf(File.separatorChar);
                    String baseName = bn.substring(ind2 + 1);
                    if (file.endsWith(".xml")) {
                        newFile = new File(this.m_outputDirectory, baseName + ".yaml");
                        this.writeFile(newFile, Yaml.toYaml(suite).toString());
                        continue;
                    }
                    if (file.endsWith(".yaml")) {
                        newFile = new File(this.m_outputDirectory, baseName + ".xml");
                        this.writeFile(newFile, suite.toXml());
                        continue;
                    }
                    throw new TestNGException("Unknown file type:" + file);
                }
            }
        }
        catch (ParameterException ex) {
            System.out.println("Error: " + ex.getMessage());
            jc.usage();
        }
    }

    private void writeFile(File newFile, String content) throws IOException {
        FileWriter bw = new FileWriter(newFile);
        bw.write(content);
        bw.close();
        System.out.println("Wrote " + newFile);
    }
}

