/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.core.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleId;
import org.gradle.internal.impldep.org.apache.ivy.core.sort.ModuleInSort;
import org.gradle.internal.impldep.org.apache.ivy.core.sort.NonMatchingVersionReporter;
import org.gradle.internal.impldep.org.apache.ivy.plugins.version.VersionMatcher;

class CollectionOfModulesToSort {
    private final List moduleDescriptors;
    private final VersionMatcher versionMatcher;
    private final Map modulesByModuleId;
    private final NonMatchingVersionReporter nonMatchingVersionReporter;

    public CollectionOfModulesToSort(Collection modulesToSort, VersionMatcher matcher, NonMatchingVersionReporter nonMatchingVersionReporter) {
        this.versionMatcher = matcher;
        this.nonMatchingVersionReporter = nonMatchingVersionReporter;
        this.modulesByModuleId = new HashMap();
        this.moduleDescriptors = new ArrayList(modulesToSort.size());
        Iterator it = modulesToSort.iterator();
        while (it.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)it.next();
            ModuleInSort mdInSort = new ModuleInSort(md);
            this.moduleDescriptors.add(mdInSort);
            this.addToModulesByModuleId(md, mdInSort);
        }
    }

    private void addToModulesByModuleId(ModuleDescriptor md, ModuleInSort mdInSort) {
        ModuleId mdId = md.getModuleRevisionId().getModuleId();
        LinkedList<ModuleInSort> mdInSortAsList = new LinkedList<ModuleInSort>();
        mdInSortAsList.add(mdInSort);
        List previousList = this.modulesByModuleId.put(mdId, mdInSortAsList);
        if (previousList != null) {
            mdInSortAsList.addAll(previousList);
        }
    }

    public Iterator iterator() {
        return this.moduleDescriptors.iterator();
    }

    public int size() {
        return this.moduleDescriptors.size();
    }

    public ModuleInSort getModuleDescriptorDependency(DependencyDescriptor descriptor) {
        Collection modulesOfSameId = (Collection)this.modulesByModuleId.get(descriptor.getDependencyId());
        if (modulesOfSameId == null) {
            return null;
        }
        Iterator it = modulesOfSameId.iterator();
        while (it.hasNext()) {
            ModuleInSort mdInSort = (ModuleInSort)it.next();
            if (mdInSort.match(descriptor, this.versionMatcher)) {
                return mdInSort;
            }
            this.nonMatchingVersionReporter.reportNonMatchingVersion(descriptor, mdInSort.getSortedModuleDescriptor());
        }
        return null;
    }
}

