/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.jcifs.dcerpc;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.security.Principal;
import org.gradle.internal.impldep.jcifs.dcerpc.DcerpcBind;
import org.gradle.internal.impldep.jcifs.dcerpc.DcerpcBinding;
import org.gradle.internal.impldep.jcifs.dcerpc.DcerpcConstants;
import org.gradle.internal.impldep.jcifs.dcerpc.DcerpcException;
import org.gradle.internal.impldep.jcifs.dcerpc.DcerpcMessage;
import org.gradle.internal.impldep.jcifs.dcerpc.DcerpcPipeHandle;
import org.gradle.internal.impldep.jcifs.dcerpc.DcerpcSecurityProvider;
import org.gradle.internal.impldep.jcifs.dcerpc.ndr.NdrBuffer;
import org.gradle.internal.impldep.jcifs.smb.BufferCache;
import org.gradle.internal.impldep.jcifs.smb.NtlmPasswordAuthentication;

public abstract class DcerpcHandle
implements DcerpcConstants {
    protected DcerpcBinding binding;
    protected int max_xmit;
    protected int max_recv;
    protected int state;
    protected DcerpcSecurityProvider securityProvider;
    private static int call_id = 1;

    public DcerpcHandle() {
        this.max_recv = this.max_xmit = 4280;
        this.state = 0;
        this.securityProvider = null;
    }

    protected static DcerpcBinding parseBinding(String str) throws DcerpcException {
        char[] arr = str.toCharArray();
        String proto = null;
        String key = null;
        DcerpcBinding binding = null;
        int si = 0;
        int mark = 0;
        int state = 0;
        block6: do {
            char ch = arr[si];
            switch (state) {
                case 0: {
                    if (ch != ':') continue block6;
                    proto = str.substring(mark, si);
                    mark = si + 1;
                    state = 1;
                    break;
                }
                case 1: {
                    if (ch == '\\') {
                        mark = si + 1;
                        break;
                    }
                    state = 2;
                }
                case 2: {
                    if (ch != '[') continue block6;
                    String server = str.substring(mark, si).trim();
                    if (server.length() == 0) {
                        server = "127.0.0.1";
                    }
                    binding = new DcerpcBinding(proto, str.substring(mark, si));
                    mark = si + 1;
                    state = 5;
                    break;
                }
                case 5: {
                    if (ch == '=') {
                        key = str.substring(mark, si).trim();
                        mark = si + 1;
                        break;
                    }
                    if (ch != ',' && ch != ']') continue block6;
                    String val = str.substring(mark, si).trim();
                    if (key == null) {
                        key = "endpoint";
                    }
                    binding.setOption(key, val);
                    key = null;
                    break;
                }
                default: {
                    si = arr.length;
                }
            }
        } while (++si < arr.length);
        if (binding == null || binding.endpoint == null) {
            throw new DcerpcException("Invalid binding URL: " + str);
        }
        return binding;
    }

    public static DcerpcHandle getHandle(String url, NtlmPasswordAuthentication auth) throws UnknownHostException, MalformedURLException, DcerpcException {
        if (url.startsWith("ncacn_np:")) {
            return new DcerpcPipeHandle(url, auth);
        }
        throw new DcerpcException("DCERPC transport not supported: " + url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() throws DcerpcException, IOException {
        DcerpcHandle dcerpcHandle = this;
        synchronized (dcerpcHandle) {
            try {
                this.state = 1;
                DcerpcBind bind = new DcerpcBind(this.binding, this);
                this.sendrecv(bind);
            }
            catch (IOException ioe) {
                this.state = 0;
                throw ioe;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendrecv(DcerpcMessage msg) throws DcerpcException, IOException {
        if (this.state == 0) {
            this.bind();
        }
        boolean isDirect = true;
        byte[] stub = BufferCache.getBuffer();
        try {
            int off;
            int n;
            NdrBuffer buf = new NdrBuffer(stub, 0);
            msg.flags = 3;
            msg.call_id = call_id++;
            msg.encode(buf);
            if (this.securityProvider != null) {
                buf.setIndex(0);
                this.securityProvider.wrap(buf);
            }
            int tot = buf.getLength() - 24;
            for (off = 0; off < tot; off += n) {
                n = tot - off;
                if (24 + n > this.max_xmit) {
                    msg.flags &= 0xFFFFFFFD;
                    n = this.max_xmit - 24;
                } else {
                    msg.flags |= 2;
                    isDirect = false;
                    msg.alloc_hint = n;
                }
                msg.length = 24 + n;
                if (off > 0) {
                    msg.flags &= 0xFFFFFFFE;
                }
                if ((msg.flags & 3) != 3) {
                    buf.start = off;
                    buf.reset();
                    msg.encode_header(buf);
                    buf.enc_ndr_long(msg.alloc_hint);
                    buf.enc_ndr_short(0);
                    buf.enc_ndr_short(msg.getOpnum());
                }
                this.doSendFragment(stub, off, msg.length, isDirect);
            }
            this.doReceiveFragment(stub, isDirect);
            buf.reset();
            buf.setIndex(8);
            buf.setLength(buf.dec_ndr_short());
            if (this.securityProvider != null) {
                this.securityProvider.unwrap(buf);
            }
            buf.setIndex(0);
            msg.decode_header(buf);
            off = 24;
            if (msg.ptype == 2 && !msg.isFlagSet(2)) {
                off = msg.length;
            }
            byte[] frag = null;
            NdrBuffer fbuf = null;
            while (!msg.isFlagSet(2)) {
                if (frag == null) {
                    frag = new byte[this.max_recv];
                    fbuf = new NdrBuffer(frag, 0);
                }
                this.doReceiveFragment(frag, isDirect);
                fbuf.reset();
                fbuf.setIndex(8);
                fbuf.setLength(fbuf.dec_ndr_short());
                if (this.securityProvider != null) {
                    this.securityProvider.unwrap(fbuf);
                }
                fbuf.reset();
                msg.decode_header(fbuf);
                int stub_frag_len = msg.length - 24;
                if (off + stub_frag_len > stub.length) {
                    byte[] tmp = new byte[off + stub_frag_len];
                    System.arraycopy(stub, 0, tmp, 0, off);
                    stub = tmp;
                }
                System.arraycopy(frag, 24, stub, off, stub_frag_len);
                off += stub_frag_len;
            }
            buf = new NdrBuffer(stub, 0);
            msg.decode(buf);
        }
        finally {
            BufferCache.releaseBuffer(stub);
        }
        DcerpcException de = msg.getResult();
        if (de != null) {
            throw de;
        }
    }

    public void setDcerpcSecurityProvider(DcerpcSecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public String getServer() {
        if (this instanceof DcerpcPipeHandle) {
            return ((DcerpcPipeHandle)this).pipe.getServer();
        }
        return null;
    }

    public Principal getPrincipal() {
        if (this instanceof DcerpcPipeHandle) {
            return ((DcerpcPipeHandle)this).pipe.getPrincipal();
        }
        return null;
    }

    public String toString() {
        return this.binding.toString();
    }

    protected abstract void doSendFragment(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    protected abstract void doReceiveFragment(byte[] var1, boolean var2) throws IOException;

    public abstract void close() throws IOException;
}

