/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.model.JpsModel;

public abstract class BuildTargetType<T extends BuildTarget<?>> {
    private final String myTypeId;
    private final boolean myFileBased;

    protected BuildTargetType(String typeId) {
        this(typeId, false);
    }

    protected BuildTargetType(String typeId, boolean fileBased) {
        this.myTypeId = typeId;
        this.myFileBased = fileBased;
    }

    public final String getTypeId() {
        return this.myTypeId;
    }

    public boolean equals(Object obj) {
        return obj instanceof BuildTargetType && ((BuildTargetType)obj).myTypeId.equals(this.myTypeId);
    }

    public int hashCode() {
        return this.myTypeId.hashCode();
    }

    @NotNull
    public abstract List<T> computeAllTargets(@NotNull JpsModel var1);

    @NotNull
    public abstract BuildTargetLoader<T> createLoader(@NotNull JpsModel var1);

    public final boolean isFileBased() {
        return this.myFileBased;
    }
}

