/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/EnumValueOf;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getEnumClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getEnumEntryByName", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "getListOfAcceptableFunctions", "", "", "unwind", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "ir.interpreter"})
public final class EnumValueOf
extends IntrinsicBase {
    @NotNull
    public static final EnumValueOf INSTANCE = new EnumValueOf();

    private EnumValueOf() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        return CollectionsKt.listOf("kotlin.enumValueOf");
    }

    private final IrClass getEnumClass(IrFunction irFunction2, IrInterpreterEnvironment environment) {
        IrClass irClass2;
        if (Intrinsics.areEqual(UtilsKt.getFqName(irFunction2), "kotlin.enumValueOf")) {
            State state = environment.getCallStack$ir_interpreter().loadState(CollectionsKt.first(irFunction2.getTypeParameters()).getSymbol());
            Intrinsics.checkNotNull(state, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState");
            KTypeState kType = (KTypeState)state;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(kType.getIrType());
            Intrinsics.checkNotNull(irClassSymbol);
            irClass2 = (IrClass)irClassSymbol.getOwner();
        } else {
            IrDeclarationParent irDeclarationParent = irFunction2.getParent();
            Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            irClass2 = (IrClass)irDeclarationParent;
        }
        return irClass2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrEnumEntry getEnumEntryByName(IrFunction irFunction2, IrInterpreterEnvironment environment) {
        Object v0;
        String enumEntryName;
        IrClass enumClass2;
        block4: {
            void $this$singleOrNull$iv;
            void $this$filterIsInstanceTo$iv$iv;
            enumClass2 = this.getEnumClass(irFunction2, environment);
            enumEntryName = StateKt.asString(environment.getCallStack$ir_interpreter().loadState(CollectionsKt.first(irFunction2.getValueParameters()).getSymbol()));
            Iterable $this$filterIsInstance$iv = enumClass2.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrEnumEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrEnumEntry it = (IrEnumEntry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName().asString(), enumEntryName)) continue;
                if (found$iv) {
                    v0 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        IrEnumEntry enumEntry = v0;
        if (enumEntry == null) {
            ExceptionUtilsKt.handleUserException(new IllegalArgumentException("No enum constant " + UtilsKt.getFqName(enumClass2) + '.' + enumEntryName), environment);
        }
        return enumEntry;
    }

    @Override
    @NotNull
    public List<Instruction> unwind(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Intrinsics.checkNotNullParameter(environment, "environment");
        IrEnumEntry irEnumEntry = this.getEnumEntryByName(irFunction2, environment);
        if (irEnumEntry == null) {
            return CollectionsKt.emptyList();
        }
        IrEnumEntry enumEntry = irEnumEntry;
        Instruction[] instructionArray = new Instruction[]{this.customEvaluateInstruction(irFunction2, environment), new SimpleInstruction(enumEntry)};
        return CollectionsKt.listOf(instructionArray);
    }

    @Override
    public void evaluate(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Intrinsics.checkNotNullParameter(environment, "environment");
        IrEnumEntry irEnumEntry = this.getEnumEntryByName(irFunction2, environment);
        Intrinsics.checkNotNull(irEnumEntry);
        IrEnumEntry enumEntry = irEnumEntry;
        CallStack callStack = environment.getCallStack$ir_interpreter();
        Complex complex = environment.getMapOfEnums$ir_interpreter().get(enumEntry.getSymbol());
        Intrinsics.checkNotNull(complex);
        callStack.pushState(complex);
    }
}

