/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.util.agent;

import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u001a\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"logger", "Lorg/jetbrains/projector/util/logging/Logger;", "attachAgent", "", "agentJarPath", "", "args", "copyAgentToTempJarAndAttach", "agentJar", "Ljava/io/InputStream;", "projector-util-agent"})
public final class MiscKt {
    @NotNull
    private static final Logger logger = LoggerKt.Logger("util.agent.MiscKt");

    public static final void attachAgent(@NotNull String agentJarPath, @Nullable String args) {
        Intrinsics.checkNotNullParameter((Object)agentJarPath, (String)"agentJarPath");
        Logger.DefaultImpls.debug$default(logger, null, (Function0)new Function0<String>(agentJarPath, args){
            final /* synthetic */ String $agentJarPath;
            final /* synthetic */ String $args;
            {
                this.$agentJarPath = $agentJarPath;
                this.$args = $args;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "dynamically attaching agent: jar=" + this.$agentJarPath + ", args=" + this.$args;
            }
        }, 1, null);
        Object object = ManagementFactory.getRuntimeMXBean().getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRuntimeMXBean().name");
        String pidOfRunningVM = StringsKt.substringBefore$default((String)object, (char)'@', null, (int)2, null);
        try {
            VirtualMachine virtualMachine = VirtualMachine.attach(pidOfRunningVM);
            Intrinsics.checkNotNull((Object)virtualMachine);
            Object $this$attachAgent_u24lambda_u2d0 = object = virtualMachine;
            boolean bl = false;
            ((VirtualMachine)$this$attachAgent_u24lambda_u2d0).loadAgent(agentJarPath, args);
            ((VirtualMachine)$this$attachAgent_u24lambda_u2d0).detach();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Logger.DefaultImpls.debug$default(logger, null, (Function0)new Function0<String>(agentJarPath, args){
            final /* synthetic */ String $agentJarPath;
            final /* synthetic */ String $args;
            {
                this.$agentJarPath = $agentJarPath;
                this.$args = $args;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "dynamically attaching agent is done: jar=" + this.$agentJarPath + ", args=" + this.$args;
            }
        }, 1, null);
    }

    public static final void copyAgentToTempJarAndAttach(@NotNull InputStream agentJar, @Nullable String args) {
        Intrinsics.checkNotNullParameter((Object)agentJar, (String)"agentJar");
        Object object = File.createTempFile("projector-agent", ".jar");
        File $this$copyAgentToTempJarAndAttach_u24lambda_u2d1 = object;
        boolean bl = false;
        $this$copyAgentToTempJarAndAttach_u24lambda_u2d1.deleteOnExit();
        File tempJar = object;
        Intrinsics.checkNotNullExpressionValue((Object)tempJar, (String)"tempJar");
        agentJar.transferTo(new FileOutputStream(tempJar));
        object = tempJar.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"tempJar.absolutePath");
        MiscKt.attachAgent((String)object, args);
    }
}

