/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.util;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.server.util.AsyncHostResolver;
import org.jetbrains.projector.server.util.Host;
import org.jetbrains.projector.server.util.NetworkKt;
import org.jetbrains.projector.server.util.ResolvedHostSubscriber;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0006\u0010\u000f\u001a\u00020\rJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0005J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007J\b\u0010\u0017\u001a\u00020\rH\u0002RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/projector/server/util/AsyncHostResolver;", "", "()V", "address2Name", "", "Ljava/net/InetAddress;", "kotlin.jvm.PlatformType", "", "", "queue", "", "Lorg/jetbrains/projector/server/util/AsyncHostResolver$Request;", "addRequest", "", "req", "cancelPendingRequests", "getName", "ip", "resolve", "Lorg/jetbrains/projector/server/util/Host;", "client", "Lorg/jetbrains/projector/server/util/ResolvedHostSubscriber;", "address", "runWorker", "Request", "projector-server-common"})
public final class AsyncHostResolver {
    @NotNull
    public static final AsyncHostResolver INSTANCE = new AsyncHostResolver();
    private static final Map<InetAddress, String> address2Name = Collections.synchronizedMap(new HashMap());
    @NotNull
    private static final List<Request> queue;

    private AsyncHostResolver() {
    }

    public final void cancelPendingRequests() {
        queue.clear();
    }

    @NotNull
    public final Host resolve(@NotNull ResolvedHostSubscriber client, @NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        byte[] addr = NetworkKt.ipString2Bytes(address);
        InetAddress ip = InetAddress.getByAddress(null, addr);
        Intrinsics.checkNotNullExpressionValue((Object)ip, (String)"ip");
        return this.resolve(client, ip);
    }

    @NotNull
    public final Host resolve(@NotNull ResolvedHostSubscriber client, @NotNull InetAddress ip) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        String name = this.getName(ip);
        if (name == null) {
            this.addRequest(new Request(client, ip));
        }
        return new Host(ip, name);
    }

    private final String getName(InetAddress ip) {
        return address2Name.get(ip);
    }

    private final void addRequest(Request req) {
        queue.add(req);
        this.runWorker();
    }

    private final void runWorker() {
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)runWorker.1.INSTANCE, (int)31, null);
    }

    public static final /* synthetic */ List access$getQueue$p() {
        return queue;
    }

    public static final /* synthetic */ Map access$getAddress2Name$p() {
        return address2Name;
    }

    public static final /* synthetic */ String access$getName(AsyncHostResolver $this, InetAddress ip) {
        return $this.getName(ip);
    }

    static {
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(ArrayList<Request>())");
        queue = list;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/projector/server/util/AsyncHostResolver$Request;", "", "client", "Lorg/jetbrains/projector/server/util/ResolvedHostSubscriber;", "ip", "Ljava/net/InetAddress;", "(Lorg/jetbrains/projector/server/util/ResolvedHostSubscriber;Ljava/net/InetAddress;)V", "getClient", "()Lorg/jetbrains/projector/server/util/ResolvedHostSubscriber;", "getIp", "()Ljava/net/InetAddress;", "projector-server-common"})
    public static final class Request {
        @NotNull
        private final ResolvedHostSubscriber client;
        @NotNull
        private final InetAddress ip;

        public Request(@NotNull ResolvedHostSubscriber client, @NotNull InetAddress ip) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            this.client = client;
            this.ip = ip;
        }

        @NotNull
        public final ResolvedHostSubscriber getClient() {
            return this.client;
        }

        @NotNull
        public final InetAddress getIp() {
            return this.ip;
        }
    }
}

