/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.ant.model.impl;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ant.model.JpsAntBuildFileOptions;
import org.jetbrains.jps.ant.model.JpsAntConfiguration;
import org.jetbrains.jps.ant.model.JpsAntExtensionService;
import org.jetbrains.jps.ant.model.artifacts.JpsAntArtifactExtension;
import org.jetbrains.jps.ant.model.impl.JpsAntBuildFileOptionsImpl;
import org.jetbrains.jps.ant.model.impl.JpsAntConfigurationImpl;
import org.jetbrains.jps.ant.model.impl.JpsAntInstallationImpl;
import org.jetbrains.jps.ant.model.impl.artifacts.AntArtifactExtensionProperties;
import org.jetbrains.jps.ant.model.impl.artifacts.JpsAntArtifactExtensionImpl;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.serialization.JpsGlobalExtensionSerializer;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactExtensionSerializer;
import org.jetbrains.jps.util.JpsPathUtil;

public final class JpsAntModelSerializerExtension
extends JpsModelSerializerExtension {
    @NotNull
    public List<? extends JpsGlobalExtensionSerializer> getGlobalExtensionSerializers() {
        List<JpsGlobalAntConfigurationSerializer> list = Collections.singletonList(new JpsGlobalAntConfigurationSerializer());
        if (list == null) {
            JpsAntModelSerializerExtension.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        List<JpsProjectExtensionSerializer> list = Arrays.asList(new JpsProjectExtensionSerializer[]{new JpsProjectAntConfigurationSerializer(), new JpsWorkspaceAntConfigurationSerializer()});
        if (list == null) {
            JpsAntModelSerializerExtension.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<? extends JpsArtifactExtensionSerializer<?>> getArtifactExtensionSerializers() {
        List<JpsAntArtifactExtensionSerializer> list = Arrays.asList(new JpsAntArtifactExtensionSerializer("ant-postprocessing", JpsAntArtifactExtensionImpl.POSTPROCESSING_ROLE), new JpsAntArtifactExtensionSerializer("ant-preprocessing", JpsAntArtifactExtensionImpl.PREPROCESSING_ROLE));
        if (list == null) {
            JpsAntModelSerializerExtension.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    private static String getValueAttribute(Element buildFileTag, String childName) {
        Element child = buildFileTag.getChild(childName);
        return child != null ? child.getAttributeValue("value") : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/ant/model/impl/JpsAntModelSerializerExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalExtensionSerializers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectExtensionSerializers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactExtensionSerializers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class JpsWorkspaceAntConfigurationSerializer
    extends JpsProjectExtensionSerializer {
        private JpsWorkspaceAntConfigurationSerializer() {
            super("workspace.xml", "antWorkspaceConfiguration");
        }

        public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            if (project == null) {
                JpsWorkspaceAntConfigurationSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                JpsWorkspaceAntConfigurationSerializer.$$$reportNull$$$0(1);
            }
            for (Element buildFileTag : JDOMUtil.getChildren((Element)componentTag, (String)"buildFile")) {
                JpsAntConfiguration configuration;
                String commandLine = JpsAntModelSerializerExtension.getValueAttribute(buildFileTag, "antCommandLine");
                String url = buildFileTag.getAttributeValue("url");
                if (StringUtil.isEmpty((String)commandLine) || (configuration = (JpsAntConfiguration)project.getContainer().getChild(JpsAntConfigurationImpl.ROLE)) == null) continue;
                configuration.getOptions(url).setAntCommandLineParameters(commandLine);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentTag";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/ant/model/impl/JpsAntModelSerializerExtension$JpsWorkspaceAntConfigurationSerializer";
            objectArray[2] = "loadExtension";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class JpsProjectAntConfigurationSerializer
    extends JpsProjectExtensionSerializer {
        private JpsProjectAntConfigurationSerializer() {
            super("ant.xml", "AntConfiguration");
        }

        public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            if (project == null) {
                JpsProjectAntConfigurationSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                JpsProjectAntConfigurationSerializer.$$$reportNull$$$0(1);
            }
            HashMap<String, JpsAntBuildFileOptions> optionsMap = new HashMap<String, JpsAntBuildFileOptions>();
            for (Element buildFileTag : JDOMUtil.getChildren((Element)componentTag, (String)"buildFile")) {
                String url = buildFileTag.getAttributeValue("url");
                JpsAntBuildFileOptionsImpl options = new JpsAntBuildFileOptionsImpl();
                options.setMaxHeapSize(StringUtil.parseInt((String)JpsAntModelSerializerExtension.getValueAttribute(buildFileTag, "maximumHeapSize"), (int)128));
                options.setMaxStackSize(StringUtil.parseInt((String)JpsAntModelSerializerExtension.getValueAttribute(buildFileTag, "maximumStackSize"), (int)2));
                options.setCustomJdkName(JpsAntModelSerializerExtension.getValueAttribute(buildFileTag, "customJdkName"));
                Element antReference = buildFileTag.getChild("antReference");
                if (antReference != null) {
                    options.setUseProjectDefaultAnt(Boolean.parseBoolean(antReference.getAttributeValue("projectDefault")));
                    options.setAntInstallationName(antReference.getAttributeValue("name"));
                }
                for (Element classpathEntry : JDOMUtil.getChildren((Element)buildFileTag.getChild("additionalClassPath"), (String)"entry")) {
                    String fileUrl = classpathEntry.getAttributeValue("path");
                    String dirUrl = classpathEntry.getAttributeValue("dir");
                    if (fileUrl != null) {
                        options.addJarPath(JpsPathUtil.urlToPath((String)fileUrl));
                        continue;
                    }
                    if (dirUrl == null) continue;
                    options.addJarDirectory(JpsPathUtil.urlToPath((String)dirUrl));
                }
                for (Element propertyTag : JDOMUtil.getChildren((Element)buildFileTag.getChild("properties"), (String)"property")) {
                    String name = propertyTag.getAttributeValue("name");
                    String value = propertyTag.getAttributeValue("value");
                    if (name == null || value == null) continue;
                    options.addProperty(name, value);
                }
                optionsMap.put(url, options);
            }
            Element defaultAnt = componentTag.getChild("defaultAnt");
            String projectDefaultAntName = defaultAnt != null ? defaultAnt.getAttributeValue("name") : null;
            project.getContainer().setChild(JpsAntConfigurationImpl.ROLE, (JpsElement)new JpsAntConfigurationImpl(optionsMap, projectDefaultAntName));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentTag";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/ant/model/impl/JpsAntModelSerializerExtension$JpsProjectAntConfigurationSerializer";
            objectArray[2] = "loadExtension";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JpsGlobalAntConfigurationSerializer
    extends JpsGlobalExtensionSerializer {
        protected JpsGlobalAntConfigurationSerializer() {
            super("other.xml", "GlobalAntConfiguration");
        }

        public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                JpsGlobalAntConfigurationSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                JpsGlobalAntConfigurationSerializer.$$$reportNull$$$0(1);
            }
            for (Element antTag : JDOMUtil.getChildren((Element)componentTag.getChild("registeredAnts"), (String)"ant")) {
                String name = JpsAntModelSerializerExtension.getValueAttribute(antTag, "name");
                String homeDir = JpsAntModelSerializerExtension.getValueAttribute(antTag, "homeDir");
                ArrayList<String> classpath = new ArrayList<String>();
                ArrayList<String> jarDirectories = new ArrayList<String>();
                for (Element classpathItemTag : JDOMUtil.getChildren((Element)antTag.getChild("classpath"), (String)"classpathItem")) {
                    String fileUrl = classpathItemTag.getAttributeValue("path");
                    String dirUrl = classpathItemTag.getAttributeValue("dir");
                    if (fileUrl != null) {
                        classpath.add(JpsPathUtil.urlToPath((String)fileUrl));
                        continue;
                    }
                    if (dirUrl == null) continue;
                    jarDirectories.add(JpsPathUtil.urlToPath((String)dirUrl));
                }
                if (name == null || homeDir == null) continue;
                JpsAntExtensionService.addAntInstallation(global, new JpsAntInstallationImpl(new File(homeDir), name, classpath, jarDirectories));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "global";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentTag";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/ant/model/impl/JpsAntModelSerializerExtension$JpsGlobalAntConfigurationSerializer";
            objectArray[2] = "loadExtension";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class JpsAntArtifactExtensionSerializer
    extends JpsArtifactExtensionSerializer<JpsAntArtifactExtension> {
        private JpsAntArtifactExtensionSerializer(String id, JpsElementChildRole<JpsAntArtifactExtension> role) {
            super(id, role);
        }

        public JpsAntArtifactExtension loadExtension(@Nullable Element optionsTag) {
            return new JpsAntArtifactExtensionImpl(optionsTag != null ? (AntArtifactExtensionProperties)XmlSerializer.deserialize((Element)optionsTag, AntArtifactExtensionProperties.class) : null);
        }
    }
}

