/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.NameValue;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementPresentationManager {
    private static final ConcurrentMap<Class<?>, Optional<Method>> ourNameValueMethods = ConcurrentFactoryMap.create(key -> ReflectionUtil.getClassPublicMethods((Class)key).stream().filter(method -> JavaMethod.getMethod(key, method).getAnnotation(NameValue.class) != null).findFirst(), CollectionFactory::createConcurrentWeakKeySoftValueMap);
    private static final Function<Object, String> DEFAULT_NAMER = element -> ElementPresentationManager.getElementName(element);
    public static final NullableFunction<Object, String> NAMER = o -> ElementPresentationManager.getElementName(o);

    public static ElementPresentationManager getInstance() {
        return (ElementPresentationManager)ApplicationManager.getApplication().getService(ElementPresentationManager.class);
    }

    public <T> Object @NotNull [] createVariants(Collection<T> elements) {
        Object[] objectArray = this.createVariants(elements, DEFAULT_NAMER);
        if (objectArray == null) {
            ElementPresentationManager.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    public <T> Object @NotNull [] createVariants(Collection<T> elements, int iconFlags) {
        Object[] objectArray = this.createVariants(elements, DEFAULT_NAMER, iconFlags);
        if (objectArray == null) {
            ElementPresentationManager.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public <T> Object @NotNull [] createVariants(Collection<? extends T> elements, Function<? super T, String> namer) {
        Object[] objectArray = this.createVariants(elements, namer, 0);
        if (objectArray == null) {
            ElementPresentationManager.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @Deprecated(forRemoval=true)
    public abstract Object createVariant(Object var1, String var2, PsiElement var3);

    public abstract <T> Object @NotNull [] createVariants(Collection<? extends T> var1, Function<? super T, String> var2, int var3);

    public static <T> NullableFunction<T, String> NAMER() {
        return o -> ElementPresentationManager.getElementName(o);
    }

    public static <T> NullableFunction<T, String> namer() {
        return NAMER;
    }

    @Nullable
    public static String getElementName(@NotNull Object element) {
        Object o;
        if (element == null) {
            ElementPresentationManager.$$$reportNull$$$0(3);
        }
        if ((o = ElementPresentationManager.invokeNameValueMethod(element)) == null || o instanceof String) {
            return (String)o;
        }
        if (o instanceof GenericValue) {
            Object value;
            GenericValue gv = (GenericValue)o;
            String s = gv.getStringValue();
            if (s == null && (value = gv.getValue()) != null) {
                return String.valueOf(value);
            }
            return s;
        }
        return null;
    }

    @Nullable
    public static Object invokeNameValueMethod(@NotNull Object element) {
        if (element == null) {
            ElementPresentationManager.$$$reportNull$$$0(4);
        }
        return ((Optional)ourNameValueMethods.get(element.getClass())).map(method -> DomReflectionUtil.invokeMethod(method, element, new Object[0])).orElse(null);
    }

    @NlsSafe
    public static String getTypeNameForObject(Object o) {
        Object firstImpl = ModelMergerUtil.getFirstImplementation(o);
        o = firstImpl != null ? firstImpl : o;
        String typeName = TypePresentationService.getService().getTypeName(o);
        if (typeName != null) {
            return typeName;
        }
        if (o instanceof DomElement) {
            DomElement element = (DomElement)o;
            return StringUtil.capitalizeWords((String)element.getNameStrategy().splitIntoWords(element.getXmlElementName()), (boolean)true);
        }
        return TypePresentationService.getDefaultTypeName(o.getClass());
    }

    public static Icon getIcon(@NotNull Object o) {
        Icon icon;
        if (o == null) {
            ElementPresentationManager.$$$reportNull$$$0(5);
        }
        if (o instanceof Iconable && (icon = ((Iconable)o).getIcon(2)) != null) {
            return icon;
        }
        if (o instanceof DomElement) {
            return ((DomElement)o).getPresentation().getIcon();
        }
        return ElementPresentationManager.getIconOld(o);
    }

    @Nullable
    public static Icon getIconOld(Object o) {
        return ElementPresentationManager.getFirst(ElementPresentationManager.getIconsForClass(o.getClass(), o));
    }

    @Nullable
    private static <T> T getFirst(T @Nullable [] array) {
        return array == null || array.length == 0 ? null : (T)array[0];
    }

    @Nullable
    public static Icon getIconForClass(Class clazz) {
        return ElementPresentationManager.getFirst(ElementPresentationManager.getIconsForClass(clazz, null));
    }

    private static Icon @Nullable [] getIconsForClass(Class clazz, @Nullable Object o) {
        Icon icon;
        TypePresentationService service = TypePresentationService.getService();
        Icon icon2 = icon = o == null ? service.getTypeIcon(clazz) : service.getIcon(o);
        if (icon != null) {
            return new Icon[]{icon};
        }
        return null;
    }

    @Nullable
    public static <T> T findByName(Collection<T> collection, String name) {
        return (T)ContainerUtil.find(collection, object -> Comparing.equal((String)name, (String)ElementPresentationManager.getElementName(object), (boolean)true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/ElementPresentationManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariants";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/ElementPresentationManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invokeNameValueMethod";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

