/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.XmlStructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.SmartList;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructuralSearchUtil {
    private static final String REG_EXP_META_CHARS = ".$|()[]{}^?*+\\";
    private static final Pattern ACCENTS = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static final Comparator<? super Configuration> CONFIGURATION_COMPARATOR = Comparator.comparing(Configuration::getCategory, NaturalComparator.INSTANCE).thenComparing(Configuration::getName, NaturalComparator.INSTANCE);
    private static LanguageFileType ourDefaultFileType;
    private static boolean ourUseUniversalMatchingAlgorithm;
    private static Map<String, LanguageFileType> ourNames2FileTypes;
    private static final Map<String, StructuralSearchProfile> cache;
    private static List<Configuration> ourPredefinedConfigurations;

    private static void clearCaches() {
        ourPredefinedConfigurations = null;
        ourDefaultFileType = null;
        ourNames2FileTypes = null;
        cache.clear();
    }

    private StructuralSearchUtil() {
    }

    public static void setUseUniversalMatchingAlgorithm(boolean useUniversalMatchingAlgorithm) {
        ourUseUniversalMatchingAlgorithm = useUniversalMatchingAlgorithm;
        cache.clear();
    }

    @Nullable
    public static StructuralSearchProfile getProfileByPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            StructuralSearchUtil.$$$reportNull$$$0(0);
        }
        return StructuralSearchUtil.getProfileByLanguage(element.getLanguage());
    }

    @Nullable
    public static StructuralSearchProfile getProfileByFileType(@Nullable LanguageFileType fileType) {
        return fileType == null ? null : StructuralSearchUtil.getProfileByLanguage(fileType.getLanguage());
    }

    @Nullable
    public static StructuralSearchProfile getProfileByLanguage(@NotNull Language language) {
        String id;
        if (language == null) {
            StructuralSearchUtil.$$$reportNull$$$0(1);
        }
        if (cache.containsKey(id = language.getID())) {
            return cache.get(id);
        }
        for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
            if (!profile.isMyLanguage(language)) continue;
            cache.put(id, profile);
            return profile;
        }
        cache.put(id, null);
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isIdentifier(PsiElement element) {
        if (element == null) {
            return false;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
        return profile != null && profile.isIdentifier(element);
    }

    public static PsiElement getParentIfIdentifier(PsiElement element) {
        return StructuralSearchUtil.isIdentifier(element) ? element.getParent() : element;
    }

    @Contract(value="!null -> !null")
    public static PsiElement getPresentableElement(PsiElement element) {
        if (element == null) {
            return null;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
        return profile == null ? element : profile.getPresentableElement(element);
    }

    private static StructuralSearchProfile[] getNewStyleProfiles() {
        SmartList list = new SmartList();
        for (StructuralSearchProfile profile : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions()) {
            if (!(profile instanceof StructuralSearchProfileBase)) continue;
            list.add(profile);
        }
        list.add(new XmlStructuralSearchProfile());
        return list.toArray(new StructuralSearchProfile[0]);
    }

    private static StructuralSearchProfile[] getProfiles() {
        return ourUseUniversalMatchingAlgorithm ? StructuralSearchUtil.getNewStyleProfiles() : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions();
    }

    @NotNull
    public static LanguageFileType getDefaultFileType() {
        if (ourDefaultFileType == null) {
            for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
                ourDefaultFileType = profile.getDefaultFileType(ourDefaultFileType);
            }
            if (ourDefaultFileType == null) {
                ourDefaultFileType = XmlFileType.INSTANCE;
            }
        }
        LanguageFileType languageFileType = ourDefaultFileType;
        if (languageFileType == null) {
            StructuralSearchUtil.$$$reportNull$$$0(2);
        }
        return languageFileType;
    }

    public static boolean isTypedVariable(@NotNull String name) {
        if (name == null) {
            StructuralSearchUtil.$$$reportNull$$$0(3);
        }
        return name.length() > 1 && name.charAt(0) == '$' && name.charAt(name.length() - 1) == '$';
    }

    public static Collection<LanguageFileType> getSuitableFileTypes() {
        return Collections.unmodifiableCollection(StructuralSearchUtil.getNames2FileTypes().values());
    }

    @NotNull
    private static Map<String, LanguageFileType> getNames2FileTypes() {
        Map<String, LanguageFileType> names2FileTypes = ourNames2FileTypes;
        if (names2FileTypes != null) {
            Map<String, LanguageFileType> map = names2FileTypes;
            if (map == null) {
                StructuralSearchUtil.$$$reportNull$$$0(4);
            }
            return map;
        }
        FileType[] fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes();
        Map<String, LanguageFileType> cache = Arrays.stream(fileTypes).filter(fileType -> fileType instanceof LanguageFileType).collect(Collectors.toMap(FileType::getName, fileType -> (LanguageFileType)fileType));
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType fileType2 = language.getAssociatedFileType();
            if (fileType2 == null) continue;
            cache.put(fileType2.getName(), fileType2);
        }
        ourNames2FileTypes = cache;
        if (ourNames2FileTypes == null) {
            StructuralSearchUtil.$$$reportNull$$$0(5);
        }
        return ourNames2FileTypes;
    }

    public static LanguageFileType getSuitableFileTypeByName(String name) {
        return StructuralSearchUtil.getNames2FileTypes().get(name);
    }

    public static boolean containsRegExpMetaChar(String s) {
        return s.chars().anyMatch(StructuralSearchUtil::isRegExpMetaChar);
    }

    public static boolean isRegExpMetaChar(int ch) {
        return REG_EXP_META_CHARS.indexOf(ch) >= 0;
    }

    @NotNull
    public static String shieldRegExpMetaChars(@NotNull String word) {
        if (word == null) {
            StructuralSearchUtil.$$$reportNull$$$0(6);
        }
        String string = StructuralSearchUtil.shieldRegExpMetaChars(word, new StringBuilder(word.length())).toString();
        if (string == null) {
            StructuralSearchUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static String makeExtremeSpacesOptional(String word) {
        if (word.trim().isEmpty()) {
            return word;
        }
        Object result = word;
        if (word.startsWith(" ")) {
            result = "(?:\\s|\\b)" + ((String)result).substring(1);
        }
        if (word.endsWith(" ")) {
            result = ((String)result).substring(0, ((String)result).length() - 1) + "(?:\\s|\\b)";
        }
        return result;
    }

    @NotNull
    public static StringBuilder shieldRegExpMetaChars(String word, StringBuilder out) {
        int length = word.length();
        for (int i = 0; i < length; ++i) {
            if (StructuralSearchUtil.isRegExpMetaChar(word.charAt(i))) {
                out.append("\\");
            }
            out.append(word.charAt(i));
        }
        StringBuilder stringBuilder = out;
        if (stringBuilder == null) {
            StructuralSearchUtil.$$$reportNull$$$0(8);
        }
        return stringBuilder;
    }

    public static Pattern[] createPatterns(String[] prefixes) {
        Pattern[] patterns = new Pattern[prefixes.length];
        for (int i = 0; i < prefixes.length; ++i) {
            String s = StructuralSearchUtil.shieldRegExpMetaChars(prefixes[i]);
            patterns[i] = Pattern.compile("\\b(" + s + "\\w+)\\b");
        }
        return patterns;
    }

    public static List<Configuration> getPredefinedTemplates() {
        if (ourPredefinedConfigurations == null) {
            ArrayList result = new ArrayList();
            for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
                Collections.addAll(result, profile.getPredefinedTemplates());
            }
            Collections.sort(result, CONFIGURATION_COMPARATOR);
            ourPredefinedConfigurations = Collections.unmodifiableList(result);
        }
        return ourPredefinedConfigurations;
    }

    public static boolean isDocCommentOwner(@NotNull PsiElement match) {
        StructuralSearchProfile profile;
        if (match == null) {
            StructuralSearchUtil.$$$reportNull$$$0(9);
        }
        return (profile = StructuralSearchUtil.getProfileByPsiElement(match)) != null && profile.isDocCommentOwner(match);
    }

    public static String getMeaningfulText(PsiElement matchedNode) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(matchedNode);
        return profile != null ? profile.getMeaningfulText(matchedNode) : matchedNode.getText();
    }

    public static String getAlternativeText(@NotNull PsiElement matchedNode, @NotNull String previousText) {
        StructuralSearchProfile profile;
        if (matchedNode == null) {
            StructuralSearchUtil.$$$reportNull$$$0(10);
        }
        if (previousText == null) {
            StructuralSearchUtil.$$$reportNull$$$0(11);
        }
        return (profile = StructuralSearchUtil.getProfileByPsiElement(matchedNode)) != null ? profile.getAlternativeText(matchedNode, previousText) : null;
    }

    @NotNull
    public static String normalizeWhiteSpace(@NotNull String text) {
        if (text == null) {
            StructuralSearchUtil.$$$reportNull$$$0(12);
        }
        text = text.trim();
        StringBuilder result = new StringBuilder();
        boolean white = false;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (StringUtil.isWhiteSpace((char)c)) {
                if (white) continue;
                result.append(' ');
                white = true;
                continue;
            }
            white = false;
            result.append(c);
        }
        String string = result.toString();
        if (string == null) {
            StructuralSearchUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String stripAccents(@NotNull String input) {
        if (input == null) {
            StructuralSearchUtil.$$$reportNull$$$0(14);
        }
        String string = ACCENTS.matcher(Normalizer.normalize(input, Normalizer.Form.NFD)).replaceAll("");
        if (string == null) {
            StructuralSearchUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String normalize(@NotNull String text) {
        if (text == null) {
            StructuralSearchUtil.$$$reportNull$$$0(16);
        }
        return StructuralSearchUtil.stripAccents(StructuralSearchUtil.normalizeWhiteSpace(text));
    }

    public static PatternContext findPatternContextByID(@Nullable String id, @NotNull Language language) {
        if (language == null) {
            StructuralSearchUtil.$$$reportNull$$$0(17);
        }
        return StructuralSearchUtil.findPatternContextByID(id, StructuralSearchUtil.getProfileByLanguage(language));
    }

    public static PatternContext findPatternContextByID(@Nullable String id, @Nullable StructuralSearchProfile profile) {
        if (profile == null) {
            return null;
        }
        List<PatternContext> patternContexts = profile.getPatternContexts();
        if (patternContexts.isEmpty()) {
            return null;
        }
        if (id == null) {
            return patternContexts.get(0);
        }
        return patternContexts.stream().filter(context -> context.getId().equals(id)).findFirst().orElse(patternContexts.get(0));
    }

    static {
        cache = new HashMap<String, StructuralSearchProfile>();
        StructuralSearchProfile.EP_NAME.addChangeListener(() -> StructuralSearchUtil.clearCaches(), null);
        Application application = ApplicationManager.getApplication();
        application.getMessageBus().connect((Disposable)application).subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                StructuralSearchUtil.clearCaches();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/StructuralSearchUtil$1", "fileTypesChanged"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedNode";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousText";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames2FileTypes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "shieldRegExpMetaChars";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeWhiteSpace";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "stripAccents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByPsiElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByLanguage";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTypedVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shieldRegExpMetaChars";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDocCommentOwner";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "normalizeWhiteSpace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "stripAccents";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findPatternContextByID";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

