/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ReflectionUtilRt;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.ParseException;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.path.DefaultPathTranslator;
import org.apache.maven.model.path.DefaultUrlNormalizer;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.path.UrlNormalizer;
import org.apache.maven.model.profile.DefaultProfileInjector;
import org.apache.maven.model.validation.DefaultModelValidator;
import org.apache.maven.model.validation.ModelValidator;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.profiles.activation.JdkPrefixProfileActivator;
import org.apache.maven.profiles.activation.OperatingSystemProfileActivator;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.apache.maven.profiles.activation.SystemPropertyProfileActivator;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.inheritance.DefaultModelInheritanceAssembler;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeResolutionListener;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.logging.BaseLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.ExceptionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.Maven3AetherModelConverter;
import org.jetbrains.idea.maven.server.Maven3ServerConsoleLogger;
import org.jetbrains.idea.maven.server.Maven3ServerEmbedder;
import org.jetbrains.idea.maven.server.Maven3ServerGlobals;
import org.jetbrains.idea.maven.server.Maven3WorkspaceReader;
import org.jetbrains.idea.maven.server.MavenArtifactResolveResult;
import org.jetbrains.idea.maven.server.MavenConfigParseException;
import org.jetbrains.idea.maven.server.MavenEffectivePomDumper;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenImporterSpy;
import org.jetbrains.idea.maven.server.MavenLeakDetector;
import org.jetbrains.idea.maven.server.MavenModelConverter;
import org.jetbrains.idea.maven.server.MavenServerConsole;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicatorWrapper;
import org.jetbrains.idea.maven.server.MavenServerPullProgressIndicator;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.MyFileProfileActivator;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.RemoteNativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.TransferListenerAdapter;
import org.jetbrains.idea.maven.server.Workspace3Reader;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ArtifactFactory;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ArtifactResolver;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator2;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3RepositoryMetadataManager;
import org.jetbrains.idea.maven.server.embedder.CustomModelValidator385;
import org.jetbrains.idea.maven.server.embedder.MavenExecutionResult;
import org.jetbrains.idea.maven.server.security.MavenToken;

public abstract class Maven3XServerEmbedder
extends Maven3ServerEmbedder {
    @NotNull
    private final DefaultPlexusContainer myContainer;
    @NotNull
    private final Settings myMavenSettings;
    private final ArtifactRepository myLocalRepository;
    private final Maven3ServerConsoleLogger myConsoleWrapper;
    private final Properties mySystemProperties;
    private volatile MavenServerProgressIndicatorWrapper myCurrentIndicator;
    private MavenWorkspaceMap myWorkspaceMap;
    private Date myBuildStartTime;
    private boolean myAlwaysUpdateSnapshots;
    @Nullable
    private Properties myUserProperties;
    @NotNull
    private final RepositorySystem myRepositorySystem;
    @NotNull
    private final MavenImporterSpy myImporterSpy;

    public Maven3XServerEmbedder(MavenEmbedderSettings settings) throws RemoteException {
        super(settings.getSettings());
        Object cliRequest;
        Class<?> cliRequestClass;
        if (settings.getWorkingDirectory() != null) {
            System.setProperty("user.dir", settings.getWorkingDirectory());
        }
        if (settings.getMultiModuleProjectDirectory() != null) {
            System.setProperty("maven.multiModuleProjectDirectory", settings.getMultiModuleProjectDirectory());
        } else {
            System.setProperty("maven.multiModuleProjectDirectory", "");
        }
        MavenServerSettings serverSettings = settings.getSettings();
        String mavenHome = serverSettings.getMavenHomePath();
        if (mavenHome != null) {
            System.setProperty("maven.home", mavenHome);
        }
        this.myConsoleWrapper = new Maven3ServerConsoleLogger();
        this.myConsoleWrapper.setThreshold(serverSettings.getLoggingLevel());
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        MavenCli cli = new MavenCli(classWorld){

            protected void customizeContainer(PlexusContainer container) {
                ((DefaultPlexusContainer)container).setLoggerManager((LoggerManager)new BaseLoggerManager(){

                    protected Logger createLogger(String s) {
                        return Maven3XServerEmbedder.this.myConsoleWrapper;
                    }
                });
            }
        };
        DefaultSettingsBuilder settingsBuilder = null;
        try {
            cliRequestClass = MavenCli.class.getClassLoader().loadClass("org.apache.maven.cli.MavenCli$CliRequest");
        }
        catch (ClassNotFoundException e) {
            try {
                cliRequestClass = MavenCli.class.getClassLoader().loadClass("org.apache.maven.cli.CliRequest");
                settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException("unable to find maven CliRequest class");
            }
        }
        try {
            ArrayList<String> commandLineOptions = new ArrayList<String>(serverSettings.getUserProperties().size());
            for (Map.Entry<Object, Object> each : serverSettings.getUserProperties().entrySet()) {
                commandLineOptions.add("-D" + each.getKey() + "=" + each.getValue());
            }
            if (serverSettings.getLoggingLevel() == 0) {
                commandLineOptions.add("-X");
                commandLineOptions.add("-e");
            } else if (serverSettings.getLoggingLevel() == 5) {
                commandLineOptions.add("-q");
            }
            String mavenEmbedderCliOptions = System.getProperty("idea.maven.embedder.ext.cli.args");
            if (mavenEmbedderCliOptions != null) {
                commandLineOptions.addAll(StringUtilRt.splitHonorQuotes((String)mavenEmbedderCliOptions, (char)' '));
            }
            if (commandLineOptions.contains("-U") || commandLineOptions.contains("--update-snapshots")) {
                this.myAlwaysUpdateSnapshots = true;
            }
            Constructor<?> constructor = cliRequestClass.getDeclaredConstructor(String[].class, ClassWorld.class);
            constructor.setAccessible(true);
            cliRequest = constructor.newInstance(commandLineOptions.toArray(new String[0]), classWorld);
            for (String each : new String[]{"initialize", "cli", "logging", "properties"}) {
                Method m = MavenCli.class.getDeclaredMethod(each, cliRequestClass);
                m.setAccessible(true);
                m.invoke((Object)cli, cliRequest);
            }
        }
        catch (Exception e) {
            ParseException cause = (ParseException)ExceptionUtilRt.findCause((Throwable)e, ParseException.class);
            if (cause != null) {
                String workingDir = settings.getWorkingDirectory();
                if (workingDir == null) {
                    workingDir = System.getProperty("user.dir");
                }
                throw new MavenConfigParseException(cause.getMessage(), workingDir);
            }
            throw new RuntimeException(e);
        }
        try {
            Method m = MavenCli.class.getDeclaredMethod("container", cliRequestClass);
            m.setAccessible(true);
            this.myContainer = (DefaultPlexusContainer)m.invoke((Object)cli, cliRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.myContainer.getLoggerManager().setThreshold(serverSettings.getLoggingLevel());
        this.mySystemProperties = (Properties)ReflectionUtilRt.getField(cliRequestClass, cliRequest, Properties.class, (String)"systemProperties");
        if (serverSettings.getProjectJdk() != null) {
            this.mySystemProperties.setProperty("java.home", serverSettings.getProjectJdk());
        }
        if (settingsBuilder == null) {
            settingsBuilder = (SettingsBuilder)ReflectionUtilRt.getField(MavenCli.class, (Object)cli, SettingsBuilder.class, (String)"settingsBuilder");
        }
        this.myMavenSettings = Maven3XServerEmbedder.buildSettings((SettingsBuilder)settingsBuilder, serverSettings, this.mySystemProperties, (Properties)ReflectionUtilRt.getField(cliRequestClass, cliRequest, Properties.class, (String)"userProperties"));
        this.myLocalRepository = this.createLocalRepository();
        this.myRepositorySystem = this.getComponent(RepositorySystem.class);
        MavenImporterSpy importerSpy = this.getComponentIfExists(MavenImporterSpy.class);
        if (importerSpy == null) {
            importerSpy = new MavenImporterSpy();
            this.myContainer.addComponent((Object)importerSpy, MavenImporterSpy.class.getName());
        }
        this.myImporterSpy = importerSpy;
    }

    @NotNull
    protected PlexusContainer getContainer() {
        DefaultPlexusContainer defaultPlexusContainer = this.myContainer;
        if (defaultPlexusContainer == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(0);
        }
        return defaultPlexusContainer;
    }

    private static Settings buildSettings(SettingsBuilder builder, MavenServerSettings settings, Properties systemProperties, Properties userProperties) throws RemoteException {
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        if (settings.getGlobalSettingsPath() != null) {
            settingsRequest.setGlobalSettingsFile(new File(settings.getGlobalSettingsPath()));
        }
        if (settings.getUserSettingsPath() != null) {
            settingsRequest.setUserSettingsFile(new File(settings.getUserSettingsPath()));
        }
        settingsRequest.setSystemProperties(systemProperties);
        settingsRequest.setUserProperties(userProperties);
        Settings result = new Settings();
        try {
            result = builder.build((SettingsBuildingRequest)settingsRequest).getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            Maven3ServerGlobals.getLogger().info((Throwable)e);
        }
        result.setOffline(settings.isOffline());
        if (settings.getLocalRepositoryPath() != null) {
            result.setLocalRepository(settings.getLocalRepositoryPath());
        }
        if (result.getLocalRepository() == null) {
            result.setLocalRepository(new File(System.getProperty("user.home"), ".m2/repository").getPath());
        }
        return result;
    }

    private static MavenExecutionResult handleException(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        return new MavenExecutionResult(Collections.singletonList((Exception)e));
    }

    private static Collection<String> collectActivatedProfiles(MavenProject mavenProject) throws RemoteException {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        try {
            while (mavenProject != null) {
                profiles.addAll(mavenProject.getActiveProfiles());
                mavenProject = mavenProject.getParent();
            }
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().info((Throwable)e);
        }
        return Maven3XServerEmbedder.collectProfilesIds(profiles);
    }

    private static List<Exception> filterExceptions(List<Throwable> list) {
        for (Throwable throwable : list) {
            if (throwable instanceof Exception) continue;
            throw new RuntimeException(throwable);
        }
        return list;
    }

    @NotNull
    public static MavenModel interpolateAndAlignModel(MavenModel model, File basedir) throws RemoteException {
        Model result = MavenModelConverter.toNativeModel((MavenModel)model);
        result = Maven3XServerEmbedder.doInterpolate(result, basedir);
        org.apache.maven.project.path.DefaultPathTranslator pathTranslator = new org.apache.maven.project.path.DefaultPathTranslator();
        pathTranslator.alignToBaseDirectory(result, basedir);
        MavenModel mavenModel = MavenModelConverter.convertModel((Model)result, null);
        if (mavenModel == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(1);
        }
        return mavenModel;
    }

    public static MavenModel assembleInheritance(MavenModel model, MavenModel parentModel) throws RemoteException {
        Model result = MavenModelConverter.toNativeModel((MavenModel)model);
        new DefaultModelInheritanceAssembler().assembleModelInheritance(result, MavenModelConverter.toNativeModel((MavenModel)parentModel));
        return MavenModelConverter.convertModel((Model)result, null);
    }

    public static ProfileApplicationResult applyProfiles(MavenModel model, File basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) throws RemoteException {
        Model nativeModel = MavenModelConverter.toNativeModel((MavenModel)model);
        Collection enabledProfiles = explicitProfiles.getEnabledProfiles();
        Collection disabledProfiles = explicitProfiles.getDisabledProfiles();
        ArrayList<Profile> activatedPom = new ArrayList<Profile>();
        ArrayList<Profile> activatedExternal = new ArrayList<Profile>();
        ArrayList<Profile> activeByDefault = new ArrayList<Profile>();
        List rawProfiles = nativeModel.getProfiles();
        List expandedProfilesCache = null;
        ArrayList<Profile> deactivatedProfiles = new ArrayList<Profile>();
        for (int i = 0; i < rawProfiles.size(); ++i) {
            Profile eachRawProfile = (Profile)rawProfiles.get(i);
            if (disabledProfiles.contains(eachRawProfile.getId())) {
                deactivatedProfiles.add(eachRawProfile);
                continue;
            }
            boolean shouldAdd = enabledProfiles.contains(eachRawProfile.getId()) || alwaysOnProfiles.contains(eachRawProfile.getId());
            Activation activation = eachRawProfile.getActivation();
            if (activation != null) {
                if (activation.isActiveByDefault()) {
                    activeByDefault.add(eachRawProfile);
                }
                if (expandedProfilesCache == null) {
                    expandedProfilesCache = Maven3XServerEmbedder.doInterpolate(nativeModel, basedir).getProfiles();
                }
                Profile eachExpandedProfile = (Profile)expandedProfilesCache.get(i);
                for (ProfileActivator eachActivator : Maven3XServerEmbedder.getProfileActivators(basedir)) {
                    try {
                        if (!eachActivator.canDetermineActivation(eachExpandedProfile) || !eachActivator.isActive(eachExpandedProfile)) continue;
                        shouldAdd = true;
                        break;
                    }
                    catch (Exception e) {
                        Maven3ServerGlobals.getLogger().warn((Throwable)e);
                    }
                }
            }
            if (!shouldAdd) continue;
            if ("pom".equals(eachRawProfile.getSource())) {
                activatedPom.add(eachRawProfile);
                continue;
            }
            activatedExternal.add(eachRawProfile);
        }
        ArrayList<Profile> activatedProfiles = new ArrayList<Profile>(activatedPom.isEmpty() ? activeByDefault : activatedPom);
        activatedProfiles.addAll(activatedExternal);
        for (Profile each : activatedProfiles) {
            new DefaultProfileInjector().injectProfile(nativeModel, each, null, null);
        }
        return new ProfileApplicationResult(MavenModelConverter.convertModel((Model)nativeModel, null), new MavenExplicitProfiles(Maven3XServerEmbedder.collectProfilesIds(activatedProfiles), Maven3XServerEmbedder.collectProfilesIds(deactivatedProfiles)));
    }

    @NotNull
    private static Model doInterpolate(@NotNull Model result, File basedir) throws RemoteException {
        String mavenVersion;
        if (result == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(2);
        }
        if (VersionComparatorUtil.compare((String)(mavenVersion = System.getProperty("idea.maven.embedder.version")), (String)"3.3.1") >= 0) {
            return Maven3XServerEmbedder.doInterpolate330(result, basedir);
        }
        Model model = Maven3XServerEmbedder.doInterpolate325(result, basedir);
        org.apache.maven.project.path.DefaultPathTranslator pathTranslator = new org.apache.maven.project.path.DefaultPathTranslator();
        pathTranslator.alignToBaseDirectory(model, basedir);
        Model model2 = model;
        if (model2 == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(3);
        }
        return model2;
    }

    @NotNull
    private static Model doInterpolate325(@NotNull Model result, File basedir) throws RemoteException {
        if (result == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(4);
        }
        try {
            CustomMaven3ModelInterpolator interpolator = new CustomMaven3ModelInterpolator(new org.apache.maven.project.path.DefaultPathTranslator());
            interpolator.initialize();
            Properties props = MavenServerUtil.collectSystemProperties();
            ProjectBuilderConfiguration config = new DefaultProjectBuilderConfiguration().setExecutionProperties(props);
            config.setBuildStartTime(new Date());
            Properties userProperties = new Properties();
            userProperties.putAll((Map<?, ?>)Maven3XServerEmbedder.getMavenAndJvmConfigProperties((File)basedir));
            config.setUserProperties(userProperties);
            result = interpolator.interpolate(result, basedir, config, false);
        }
        catch (ModelInterpolationException e) {
            Maven3ServerGlobals.getLogger().warn((Throwable)e);
        }
        catch (InitializationException e) {
            Maven3ServerGlobals.getLogger().error((Throwable)e);
        }
        Model model = result;
        if (model == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(5);
        }
        return model;
    }

    @NotNull
    private static Model doInterpolate330(@NotNull Model result, File basedir) throws RemoteException {
        if (result == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(6);
        }
        try {
            CustomMaven3ModelInterpolator2 interpolator = new CustomMaven3ModelInterpolator2();
            if (VersionComparatorUtil.compare((String)System.getProperty("idea.maven.embedder.version"), (String)"3.8.5") >= 0) {
                try {
                    Class<?> clazz = Class.forName("org.apache.maven.model.interpolation.DefaultModelVersionProcessor");
                    Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                    Object component = constructor.newInstance(new Object[0]);
                    Method processor = interpolator.getClass().getMethod("setVersionPropertiesProcessor", Class.forName("org.apache.maven.model.interpolation.ModelVersionProcessor"));
                    processor.invoke((Object)interpolator, component);
                }
                catch (Exception e) {
                    Maven3ServerGlobals.getLogger().error((Throwable)e);
                }
            }
            Properties userProperties = new Properties();
            userProperties.putAll((Map<?, ?>)Maven3XServerEmbedder.getMavenAndJvmConfigProperties((File)basedir));
            DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
            request.setUserProperties(userProperties);
            request.setSystemProperties(MavenServerUtil.collectSystemProperties());
            request.setBuildStartTime(new Date());
            request.setRawModel(result);
            interpolator.setPathTranslator(new PathTranslator(){

                public String alignToBaseDirectory(String path, File basedir) {
                    String result = path;
                    if (path != null && basedir != null) {
                        File file = new File(path = path.replace('\\', File.separatorChar).replace('/', File.separatorChar));
                        result = file.isAbsolute() ? file.getPath() : (file.getPath().startsWith(File.separator) ? file.getAbsolutePath() : new File(new File(basedir, path).toURI().normalize()).getAbsolutePath());
                    }
                    return result;
                }
            });
            final ArrayList problems = new ArrayList();
            result = interpolator.interpolateModel(result, basedir, (ModelBuildingRequest)request, new ModelProblemCollector(){

                public void add(ModelProblemCollectorRequest request) {
                    problems.add(request);
                }
            });
            for (ModelProblemCollectorRequest problem : problems) {
                if (problem.getException() == null) continue;
                Maven3ServerGlobals.getLogger().warn((Throwable)problem.getException());
            }
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().error((Throwable)e);
        }
        Model model = result;
        if (model == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(7);
        }
        return model;
    }

    private static Collection<String> collectProfilesIds(List<Profile> profiles) {
        HashSet<String> result = new HashSet<String>();
        for (Profile each : profiles) {
            if (each.getId() == null) continue;
            result.add(each.getId());
        }
        return result;
    }

    private static ProfileActivator[] getProfileActivators(File basedir) throws RemoteException {
        SystemPropertyProfileActivator sysPropertyActivator = new SystemPropertyProfileActivator();
        DefaultContext context = new DefaultContext();
        context.put((Object)"SystemProperties", (Object)MavenServerUtil.collectSystemProperties());
        try {
            sysPropertyActivator.contextualize((Context)context);
        }
        catch (ContextException e) {
            Maven3ServerGlobals.getLogger().error((Throwable)e);
            return new ProfileActivator[0];
        }
        return new ProfileActivator[]{new MyFileProfileActivator(basedir), sysPropertyActivator, new JdkPrefixProfileActivator(), new OperatingSystemProfileActivator()};
    }

    public <T> T getComponent(Class<T> clazz, String roleHint) {
        try {
            return (T)this.myContainer.lookup(clazz.getName(), roleHint);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getComponent(Class<T> clazz) {
        try {
            return (T)this.myContainer.lookup(clazz.getName());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getComponentIfExists(Class<T> clazz) {
        try {
            return (T)this.myContainer.lookup(clazz.getName());
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    private ArtifactRepository createLocalRepository() {
        try {
            ArtifactRepository localRepository = this.getComponent(RepositorySystem.class).createLocalRepository(new File(this.myMavenSettings.getLocalRepository()));
            String customRepoId = System.getProperty("maven3.localRepository.id", "localIntelliJ");
            if (customRepoId != null) {
                localRepository.setId(customRepoId);
            }
            return localRepository;
        }
        catch (InvalidRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public MavenServerPullProgressIndicator customizeAndGetProgressIndicator(@Nullable MavenWorkspaceMap workspaceMap, boolean failOnUnresolvedDependency, boolean alwaysUpdateSnapshots, @Nullable Properties userProperties, MavenToken token) throws RemoteException {
        MavenServerProgressIndicatorWrapper mavenServerProgressIndicatorWrapper;
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            this.customizeComponents(token);
            ArtifactFactory artifactFactory = this.getComponent(ArtifactFactory.class);
            if (artifactFactory instanceof CustomMaven3ArtifactFactory) {
                ((CustomMaven3ArtifactFactory)artifactFactory).customize();
            }
            ((CustomMaven3ArtifactResolver)this.getComponent(ArtifactResolver.class)).customize(workspaceMap, failOnUnresolvedDependency);
            ((CustomMaven3RepositoryMetadataManager)this.getComponent(RepositoryMetadataManager.class)).customize(workspaceMap);
            this.myWorkspaceMap = workspaceMap;
            this.myBuildStartTime = new Date();
            this.myAlwaysUpdateSnapshots = this.myAlwaysUpdateSnapshots || alwaysUpdateSnapshots;
            this.myCurrentIndicator = new MavenServerProgressIndicatorWrapper();
            this.myConsoleWrapper.setWrappee((MavenServerConsole)this.myCurrentIndicator);
            try {
                UnicastRemoteObject.exportObject((Remote)this.myCurrentIndicator, 0);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
            this.myUserProperties = userProperties;
            mavenServerProgressIndicatorWrapper = this.myCurrentIndicator;
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
        if (mavenServerProgressIndicatorWrapper == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(8);
        }
        return mavenServerProgressIndicatorWrapper;
    }

    public void customizeComponents(MavenToken token) throws RemoteException {
        ModelValidator modelValidator;
        MavenServerUtil.checkToken((MavenToken)token);
        if (VersionComparatorUtil.compare((String)"3.7.0-SNAPSHOT", (String)this.getMavenVersion()) < 0) {
            this.myContainer.addComponent((Object)this.getComponent(ArtifactFactory.class, "ide"), ArtifactFactory.ROLE);
        }
        this.myContainer.addComponent((Object)this.getComponent(ArtifactResolver.class, "ide"), ArtifactResolver.ROLE);
        this.myContainer.addComponent((Object)this.getComponent(RepositoryMetadataManager.class, "ide"), RepositoryMetadataManager.class.getName());
        this.myContainer.addComponent((Object)this.getComponent(PluginDescriptorCache.class, "ide"), PluginDescriptorCache.class.getName());
        ModelInterpolator modelInterpolator = this.createAndPutInterpolator(this.myContainer);
        if (VersionComparatorUtil.compare((String)this.getMavenVersion(), (String)"3.8.5") >= 0) {
            modelValidator = new CustomModelValidator385((CustomMaven3ModelInterpolator2)modelInterpolator, (DefaultModelValidator)this.getComponent(ModelValidator.class));
        } else {
            modelValidator = this.getComponent(ModelValidator.class, "ide");
            this.myContainer.addComponent((Object)modelValidator, ModelValidator.class.getName());
        }
        DefaultModelBuilder defaultModelBuilder = (DefaultModelBuilder)this.getComponent(ModelBuilder.class);
        defaultModelBuilder.setModelValidator(modelValidator);
        defaultModelBuilder.setModelInterpolator(modelInterpolator);
    }

    private ModelInterpolator createAndPutInterpolator(DefaultPlexusContainer container) {
        if (VersionComparatorUtil.compare((String)this.getMavenVersion(), (String)"3.6.2") >= 0) {
            DefaultPathTranslator pathTranslator = new DefaultPathTranslator();
            DefaultUrlNormalizer urlNormalizer = new DefaultUrlNormalizer();
            container.addComponent((Object)pathTranslator, PathTranslator.class.getName());
            container.addComponent((Object)pathTranslator, PathTranslator.class, "ide");
            container.addComponent((Object)urlNormalizer, UrlNormalizer.class.getName());
            container.addComponent((Object)urlNormalizer, UrlNormalizer.class, "ide");
            CustomMaven3ModelInterpolator2 interpolator = new CustomMaven3ModelInterpolator2();
            interpolator.setPathTranslator((PathTranslator)pathTranslator);
            interpolator.setUrlNormalizer((UrlNormalizer)urlNormalizer);
            if (VersionComparatorUtil.compare((String)this.getMavenVersion(), (String)"3.8.5") >= 0) {
                try {
                    Class<?> clazz = Class.forName("org.apache.maven.model.interpolation.ModelVersionProcessor");
                    Object component = this.getComponent(clazz);
                    container.addComponent(component, clazz.getName());
                    container.addComponent(component, clazz, "ide");
                    Method methodSetModelVersionProcessor = interpolator.getClass().getMethod("setVersionPropertiesProcessor", clazz);
                    methodSetModelVersionProcessor.invoke((Object)interpolator, component);
                }
                catch (Exception e) {
                    try {
                        Maven3ServerGlobals.getLogger().error((Throwable)e);
                    }
                    catch (RemoteException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            return interpolator;
        }
        ModelInterpolator modelInterpolator = this.getComponent(ModelInterpolator.class, "ide");
        this.myContainer.addComponent((Object)modelInterpolator, ModelInterpolator.class.getName());
        this.myContainer.addComponent((Object)this.getComponent(org.apache.maven.project.interpolation.ModelInterpolator.class, "ide"), org.apache.maven.project.interpolation.ModelInterpolator.ROLE);
        return modelInterpolator;
    }

    @NotNull
    public Collection<MavenServerExecutionResult> resolveProject(@NotNull Collection<File> files, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles, MavenToken token) throws RemoteException {
        if (files == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(9);
        }
        if (activeProfiles == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(10);
        }
        if (inactiveProfiles == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(11);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        DependencyTreeResolutionListener listener = new DependencyTreeResolutionListener((Logger)this.myConsoleWrapper);
        Collection<MavenExecutionResult> results = this.doResolveProject(files, new ArrayList<String>(activeProfiles), new ArrayList<String>(inactiveProfiles), Collections.singletonList(listener));
        List list = ContainerUtilRt.map2List(results, result -> {
            try {
                return this.createExecutionResult(result.getPomFile(), (MavenExecutionResult)result, listener.getRootNode());
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        });
        if (list == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public String evaluateEffectivePom(@NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, MavenToken token) throws RemoteException {
        if (file == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(13);
        }
        if (activeProfiles == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(14);
        }
        if (inactiveProfiles == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(15);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        return MavenEffectivePomDumper.evaluateEffectivePom((Maven3ServerEmbedder)this, (File)file, activeProfiles, inactiveProfiles);
    }

    @NotNull
    public Collection<MavenExecutionResult> doResolveProject(@NotNull Collection<File> files, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, List<ResolutionListener> listeners) throws RemoteException {
        if (files == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(16);
        }
        if (activeProfiles == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(17);
        }
        if (inactiveProfiles == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(18);
        }
        File file = !files.isEmpty() ? files.iterator().next() : null;
        MavenExecutionRequest request = this.createRequest(file, activeProfiles, inactiveProfiles, null);
        request.setUpdateSnapshots(this.myAlwaysUpdateSnapshots);
        ArrayList<MavenExecutionResult> executionResults = new ArrayList<MavenExecutionResult>();
        this.executeWithMavenSession(request, () -> {
            try {
                MavenSession mavenSession = this.getComponent(LegacySupport.class).getSession();
                RepositorySystemSession repositorySession = this.getComponent(LegacySupport.class).getRepositorySession();
                if (repositorySession instanceof DefaultRepositorySystemSession) {
                    DefaultRepositorySystemSession session = (DefaultRepositorySystemSession)repositorySession;
                    this.myImporterSpy.setIndicator((MavenServerProgressIndicator)this.myCurrentIndicator);
                    session.setTransferListener((TransferListener)new TransferListenerAdapter((MavenServerProgressIndicator)this.myCurrentIndicator));
                    if (this.myWorkspaceMap != null) {
                        session.setWorkspaceReader((WorkspaceReader)new Workspace3Reader(this.myWorkspaceMap));
                    }
                    session.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
                    session.setConfigProperty("aether.dependencyManager.verbose", (Object)true);
                }
                List buildingResults = this.getProjectBuildingResults(request, files);
                Maven3XServerEmbedder.fillSessionCache(mavenSession, repositorySession, buildingResults);
                for (ProjectBuildingResult buildingResult : buildingResults) {
                    MavenProject project = buildingResult.getProject();
                    if (project == null) {
                        ArrayList<Exception> exceptions = new ArrayList<Exception>();
                        for (ModelProblem problem : buildingResult.getProblems()) {
                            exceptions.add(problem.getException());
                        }
                        MavenExecutionResult mavenExecutionResult = new MavenExecutionResult(buildingResult.getPomFile(), exceptions);
                        executionResults.add(mavenExecutionResult);
                        continue;
                    }
                    ArrayList modelProblems = new ArrayList();
                    if (buildingResult.getProblems() != null) {
                        modelProblems.addAll(buildingResult.getProblems());
                    }
                    ArrayList<Exception> exceptions = new ArrayList<Exception>();
                    this.loadExtensions(project, exceptions);
                    project.setDependencyArtifacts(project.createArtifacts(this.getComponent(ArtifactFactory.class), null, null));
                    if (USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING) {
                        this.addMvn2CompatResults(project, exceptions, listeners, this.myLocalRepository, executionResults);
                        continue;
                    }
                    DependencyResolutionResult dependencyResolutionResult = this.resolveDependencies(project, repositorySession);
                    boolean addUnresolved = System.getProperty("idea.maven.no.use.dependency.graph") == null;
                    Set<Artifact> artifacts = this.resolveArtifacts(dependencyResolutionResult, addUnresolved);
                    project.setArtifacts(artifacts);
                    executionResults.add(new MavenExecutionResult(project, dependencyResolutionResult, exceptions, modelProblems));
                }
            }
            catch (Exception e) {
                executionResults.add(Maven3XServerEmbedder.handleException(e));
            }
        });
        ArrayList<MavenExecutionResult> arrayList = executionResults;
        if (arrayList == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static void fillSessionCache(MavenSession mavenSession, RepositorySystemSession session, List<ProjectBuildingResult> buildingResults) {
        String mavenVersion = System.getProperty("idea.maven.embedder.version");
        if (VersionComparatorUtil.compare((String)mavenVersion, (String)"3.3.1") < 0) {
            return;
        }
        if (session instanceof DefaultRepositorySystemSession) {
            int initialCapacity = (int)((double)buildingResults.size() * 1.5);
            HashMap<MavenId, Model> cacheMavenModelMap = new HashMap<MavenId, Model>(initialCapacity);
            HashMap<String, MavenProject> mavenProjectMap = new HashMap<String, MavenProject>(initialCapacity);
            for (ProjectBuildingResult result : buildingResults) {
                if (result.getProblems() != null && !result.getProblems().isEmpty()) continue;
                Model model = result.getProject().getModel();
                String key = ArtifactUtils.key((String)model.getGroupId(), (String)model.getArtifactId(), (String)model.getVersion());
                mavenProjectMap.put(key, result.getProject());
                cacheMavenModelMap.put(new MavenId(model.getGroupId(), model.getArtifactId(), model.getVersion()), model);
            }
            mavenSession.setProjectMap(mavenProjectMap);
            ((DefaultRepositorySystemSession)session).setWorkspaceReader((WorkspaceReader)new Maven3WorkspaceReader(session.getWorkspaceReader(), cacheMavenModelMap));
        }
    }

    @NotNull
    private Set<Artifact> resolveArtifacts(DependencyResolutionResult dependencyResolutionResult, boolean addUnresolvedNodes) {
        IdentityHashMap<Dependency, Artifact> winnerDependencyMap = new IdentityHashMap<Dependency, Artifact>();
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        Set addedDependencies = Collections.newSetFromMap(new IdentityHashMap());
        Maven3XServerEmbedder.resolveConflicts(dependencyResolutionResult, winnerDependencyMap);
        if (dependencyResolutionResult.getDependencyGraph() != null) {
            dependencyResolutionResult.getDependencyGraph().getChildren();
        }
        for (Dependency dependency : dependencyResolutionResult.getDependencies()) {
            Artifact artifact = dependency == null ? null : (Artifact)winnerDependencyMap.get(dependency);
            if (artifact == null) continue;
            addedDependencies.add(dependency);
            artifacts.add(artifact);
            this.resolveAsModule(artifact);
        }
        if (addUnresolvedNodes) {
            ArrayDeque queue = new ArrayDeque(dependencyResolutionResult.getDependencyGraph().getChildren());
            while (!queue.isEmpty()) {
                Artifact artifact;
                org.eclipse.aether.graph.DependencyNode node = (org.eclipse.aether.graph.DependencyNode)queue.poll();
                queue.addAll(node.getChildren());
                Dependency dependency = node.getDependency();
                if (dependency == null || !addedDependencies.add(dependency) || (artifact = (Artifact)winnerDependencyMap.get(dependency)) == null) continue;
                addedDependencies.add(dependency);
                artifacts.add(artifact);
                this.resolveAsModule(artifact);
            }
        }
        LinkedHashSet<Artifact> linkedHashSet = artifacts;
        if (linkedHashSet == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(20);
        }
        return linkedHashSet;
    }

    private static void resolveConflicts(DependencyResolutionResult dependencyResolutionResult, final Map<Dependency, Artifact> winnerDependencyMap) {
        dependencyResolutionResult.getDependencyGraph().accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){

            public boolean visitEnter(org.eclipse.aether.graph.DependencyNode node) {
                Object winner = node.getData().get("conflict.winner");
                Dependency dependency = node.getDependency();
                if (dependency != null && winner == null) {
                    Artifact winnerArtifact = Maven3AetherModelConverter.toArtifact(dependency);
                    winnerDependencyMap.put(dependency, winnerArtifact);
                }
                return true;
            }

            public boolean visitLeave(org.eclipse.aether.graph.DependencyNode node) {
                return true;
            }
        }));
    }

    private boolean resolveAsModule(Artifact a) {
        MavenWorkspaceMap map = this.myWorkspaceMap;
        if (map == null) {
            return false;
        }
        MavenWorkspaceMap.Data resolved = map.findFileAndOriginalId(MavenModelConverter.createMavenId((Artifact)a));
        if (resolved == null) {
            return false;
        }
        a.setResolved(true);
        a.setFile(resolved.getFile(a.getType()));
        a.selectVersion(resolved.originalId.getVersion());
        return true;
    }

    private DependencyResolutionResult resolveDependencies(MavenProject project, RepositorySystemSession session) {
        DependencyResolutionResult resolutionResult;
        try {
            ProjectDependenciesResolver dependencyResolver = this.getComponent(ProjectDependenciesResolver.class);
            DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(project, session);
            resolutionResult = dependencyResolver.resolve((DependencyResolutionRequest)resolution);
        }
        catch (DependencyResolutionException e) {
            resolutionResult = e.getResult();
        }
        LinkedHashSet artifacts = new LinkedHashSet();
        if (resolutionResult.getDependencyGraph() != null) {
            RepositoryUtils.toArtifacts(artifacts, (Collection)resolutionResult.getDependencyGraph().getChildren(), Collections.singletonList(project.getArtifact().getId()), null);
            LocalRepositoryManager lrm = session.getLocalRepositoryManager();
            for (Artifact artifact : artifacts) {
                if (artifact.isResolved()) continue;
                String path = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact((Artifact)artifact));
                artifact.setFile(new File(lrm.getRepository().getBasedir(), path));
            }
        }
        project.setResolvedArtifacts(artifacts);
        project.setArtifacts(artifacts);
        return resolutionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtensions(MavenProject project, List<Exception> exceptions) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Collection<AbstractMavenLifecycleParticipant> lifecycleParticipants = this.getLifecycleParticipants(Collections.singletonList(project));
        if (!lifecycleParticipants.isEmpty()) {
            LegacySupport legacySupport = this.getComponent(LegacySupport.class);
            MavenSession session = legacySupport.getSession();
            session.setCurrentProject(project);
            try {
                session.setAllProjects(Collections.singletonList(project));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            session.setProjects(Collections.singletonList(project));
            for (AbstractMavenLifecycleParticipant listener : lifecycleParticipants) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                try {
                    listener.afterProjectsRead(session);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractMavenLifecycleParticipant> getLifecycleParticipants(Collection<MavenProject> projects) {
        LinkedHashSet<AbstractMavenLifecycleParticipant> lifecycleListeners = new LinkedHashSet<AbstractMavenLifecycleParticipant>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                lifecycleListeners.addAll(this.myContainer.lookupList(AbstractMavenLifecycleParticipant.class));
            }
            catch (ComponentLookupException e) {
                Maven3XServerEmbedder.warn((String)"Failed to lookup lifecycle participants", (Throwable)e);
            }
            HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                try {
                    lifecycleListeners.addAll(this.myContainer.lookupList(AbstractMavenLifecycleParticipant.class));
                }
                catch (ComponentLookupException e) {
                    Maven3XServerEmbedder.warn((String)"Failed to lookup lifecycle participants", (Throwable)e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return lifecycleListeners;
    }

    public MavenExecutionRequest createRequest(@Nullable File file, @Nullable List<String> activeProfiles, @Nullable List<String> inactiveProfiles, @Nullable List<String> goals) throws RemoteException {
        DefaultMavenExecutionRequest result = new DefaultMavenExecutionRequest();
        try {
            this.getComponent(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)result, this.myMavenSettings);
            result.setGoals(goals == null ? Collections.emptyList() : goals);
            result.setPom(file);
            this.getComponent(MavenExecutionRequestPopulator.class).populateDefaults((MavenExecutionRequest)result);
            result.setSystemProperties(this.mySystemProperties);
            Properties userProperties = new Properties();
            if (this.myUserProperties != null) {
                userProperties.putAll((Map<?, ?>)this.myUserProperties);
            }
            if (file != null) {
                userProperties.putAll((Map<?, ?>)Maven3XServerEmbedder.getMavenAndJvmConfigProperties((File)file.getParentFile()));
            }
            result.setUserProperties(userProperties);
            result.setActiveProfiles(Maven3XServerEmbedder.collectActiveProfiles(result.getActiveProfiles(), activeProfiles, inactiveProfiles));
            if (inactiveProfiles != null) {
                result.setInactiveProfiles(inactiveProfiles);
            }
            result.setCacheNotFound(true);
            result.setCacheTransferError(true);
            result.setStartTime(this.myBuildStartTime);
            File mavenMultiModuleProjectDirectory = Maven3XServerEmbedder.getMultimoduleProjectDir(file);
            result.setBaseDirectory(mavenMultiModuleProjectDirectory);
            Method setMultiModuleProjectDirectoryMethod = Maven3XServerEmbedder.getSetMultiModuleProjectDirectoryMethod((MavenExecutionRequest)result);
            if (setMultiModuleProjectDirectoryMethod != null) {
                try {
                    result.setMultiModuleProjectDirectory(mavenMultiModuleProjectDirectory);
                }
                catch (Exception e) {
                    Maven3ServerGlobals.getLogger().error((Throwable)e);
                }
            }
            return result;
        }
        catch (MavenExecutionRequestPopulationException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> collectActiveProfiles(@Nullable List<String> defaultActiveProfiles, @Nullable List<String> explicitActiveProfiles, @Nullable List<String> explicitInactiveProfiles) {
        if (defaultActiveProfiles == null || defaultActiveProfiles.isEmpty()) {
            return explicitActiveProfiles != null ? explicitActiveProfiles : Collections.emptyList();
        }
        HashSet<String> result = new HashSet<String>(defaultActiveProfiles);
        if (explicitInactiveProfiles != null && !explicitInactiveProfiles.isEmpty()) {
            result.removeAll(explicitInactiveProfiles);
        }
        if (explicitActiveProfiles != null) {
            result.addAll(explicitActiveProfiles);
        }
        return new ArrayList<String>(result);
    }

    @NotNull
    private static File getMultimoduleProjectDir(@Nullable File file) {
        File mavenMultiModuleProjectDirectory = file == null ? new File(FileUtilRt.getTempDirectory()) : MavenServerUtil.findMavenBasedir((File)file);
        File file2 = mavenMultiModuleProjectDirectory;
        if (file2 == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(21);
        }
        return file2;
    }

    private static Method getSetMultiModuleProjectDirectoryMethod(MavenExecutionRequest result) {
        try {
            Method method = result.getClass().getDeclaredMethod("setMultiModuleProjectDirectory", File.class);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    @NotNull
    public File getLocalRepositoryFile() {
        return new File(this.myLocalRepository.getBasedir());
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(@Nullable File file, MavenExecutionResult result, DependencyNode rootNode) throws RemoteException {
        Collection problems = MavenProjectProblem.createProblemsList();
        this.collectProblems(file, result.getExceptions(), result.getModelProblems(), problems);
        HashSet<MavenProjectProblem> unresolvedProblems = new HashSet<MavenProjectProblem>();
        this.collectUnresolvedArtifactProblems(file, result.getDependencyResolutionResult(), unresolvedProblems);
        MavenProject mavenProject = result.getMavenProject();
        if (mavenProject == null) {
            return new MavenServerExecutionResult(null, problems, Collections.emptySet());
        }
        MavenModel model = new MavenModel();
        try {
            if (USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING) {
                List dependencyNodes = rootNode == null ? Collections.emptyList() : rootNode.getChildren();
                model = MavenModelConverter.convertModel((Model)mavenProject.getModel(), (List)mavenProject.getCompileSourceRoots(), (List)mavenProject.getTestCompileSourceRoots(), (Collection)mavenProject.getArtifacts(), (Collection)dependencyNodes, (Collection)mavenProject.getExtensionArtifacts(), (File)this.getLocalRepositoryFile());
            } else {
                DependencyResolutionResult dependencyResolutionResult = result.getDependencyResolutionResult();
                org.eclipse.aether.graph.DependencyNode dependencyGraph = dependencyResolutionResult != null ? dependencyResolutionResult.getDependencyGraph() : null;
                List dependencyNodes = dependencyGraph != null ? dependencyGraph.getChildren() : Collections.emptyList();
                model = Maven3AetherModelConverter.convertModelWithAetherDependencyTree(mavenProject.getModel(), mavenProject.getCompileSourceRoots(), mavenProject.getTestCompileSourceRoots(), mavenProject.getArtifacts(), dependencyNodes, mavenProject.getExtensionArtifacts(), this.getLocalRepositoryFile());
            }
        }
        catch (Exception e) {
            this.collectProblems(mavenProject.getFile(), Collections.singleton(e), result.getModelProblems(), problems);
        }
        RemoteNativeMavenProjectHolder holder = new RemoteNativeMavenProjectHolder(mavenProject);
        try {
            UnicastRemoteObject.exportObject((Remote)holder, 0);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        Collection<String> activatedProfiles = Maven3XServerEmbedder.collectActivatedProfiles(mavenProject);
        MavenServerExecutionResult.ProjectData data = new MavenServerExecutionResult.ProjectData(model, MavenModelConverter.convertToMap((Object)mavenProject.getModel()), (NativeMavenProjectHolder)holder, activatedProfiles);
        return new MavenServerExecutionResult(data, problems, Collections.emptySet(), unresolvedProblems);
    }

    /*
     * WARNING - void declaration
     */
    private void collectProblems(@Nullable File file, @NotNull Collection<? extends Exception> exceptions, @NotNull List<? extends ModelProblem> modelProblems, @NotNull Collection<? super MavenProjectProblem> collector) throws RemoteException {
        if (exceptions == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(22);
        }
        if (modelProblems == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(23);
        }
        if (collector == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(24);
        }
        for (Throwable throwable : exceptions) {
            void var6_6;
            String path;
            if (throwable == null) continue;
            Maven3ServerGlobals.getLogger().print(ExceptionUtils.getFullStackTrace((Throwable)throwable));
            this.myConsoleWrapper.info("Validation error:", throwable);
            Artifact problemTransferArtifact = Maven3XServerEmbedder.getProblemTransferArtifact(throwable);
            if (throwable instanceof IllegalStateException && throwable.getCause() != null) {
                Throwable throwable2 = throwable.getCause();
            }
            String string = path = file == null ? "" : file.getPath();
            if (path.isEmpty() && var6_6 instanceof ProjectBuildingException) {
                File pomFile = ((ProjectBuildingException)var6_6).getPomFile();
                String string2 = path = pomFile == null ? "" : pomFile.getPath();
            }
            if (var6_6 instanceof InvalidProjectModelException) {
                ModelValidationResult modelValidationResult = ((InvalidProjectModelException)var6_6).getValidationResult();
                if (modelValidationResult != null) {
                    for (String eachValidationProblem : modelValidationResult.getMessages()) {
                        collector.add((MavenProjectProblem)MavenProjectProblem.createStructureProblem((String)path, (String)eachValidationProblem));
                    }
                    continue;
                }
                collector.add((MavenProjectProblem)MavenProjectProblem.createStructureProblem((String)path, (String)var6_6.getCause().getMessage()));
                continue;
            }
            if (var6_6 instanceof ProjectBuildingException) {
                String causeMessage = var6_6.getCause() != null ? var6_6.getCause().getMessage() : var6_6.getMessage();
                collector.add((MavenProjectProblem)MavenProjectProblem.createStructureProblem((String)path, (String)causeMessage));
                continue;
            }
            if (var6_6.getStackTrace().length > 0 && var6_6.getClass().getPackage().getName().equals("groovy.lang")) {
                this.myConsoleWrapper.error("Maven server structure problem", (Throwable)var6_6);
                StackTraceElement traceElement = var6_6.getStackTrace()[0];
                collector.add((MavenProjectProblem)MavenProjectProblem.createStructureProblem((String)(traceElement.getFileName() + ":" + traceElement.getLineNumber()), (String)var6_6.getMessage()));
                continue;
            }
            if (problemTransferArtifact != null) {
                this.myConsoleWrapper.error("[server] Maven transfer artifact problem: " + problemTransferArtifact);
                String message = Maven3XServerEmbedder.getRootMessage((Throwable)var6_6);
                MavenArtifact mavenArtifact = MavenModelConverter.convertArtifact((Artifact)problemTransferArtifact, (File)this.getLocalRepositoryFile());
                collector.add((MavenProjectProblem)MavenProjectProblem.createRepositoryProblem((String)path, (String)message, (boolean)true, (MavenArtifact)mavenArtifact));
                continue;
            }
            this.myConsoleWrapper.error("Maven server structure problem", (Throwable)var6_6);
            collector.add((MavenProjectProblem)MavenProjectProblem.createStructureProblem((String)path, (String)Maven3XServerEmbedder.getRootMessage((Throwable)var6_6), (boolean)true));
        }
        for (ModelProblem modelProblem : modelProblems) {
            String source = !StringUtilRt.isEmptyOrSpaces((CharSequence)modelProblem.getSource()) ? modelProblem.getSource() + ":" + modelProblem.getLineNumber() + ":" + modelProblem.getColumnNumber() : (file == null ? "" : file.getPath());
            this.myConsoleWrapper.error("Maven model problem: " + modelProblem.getMessage() + " at " + modelProblem.getSource() + ":" + modelProblem.getLineNumber() + ":" + modelProblem.getColumnNumber());
            if (modelProblem.getException() != null) {
                this.myConsoleWrapper.error("Maven model problem", (Throwable)modelProblem.getException());
                collector.add((MavenProjectProblem)MavenProjectProblem.createStructureProblem((String)source, (String)modelProblem.getMessage()));
                continue;
            }
            collector.add((MavenProjectProblem)MavenProjectProblem.createStructureProblem((String)source, (String)modelProblem.getMessage(), (boolean)true));
        }
    }

    private void collectUnresolvedArtifactProblems(@Nullable File file, @Nullable DependencyResolutionResult result, Collection<MavenProjectProblem> problems) {
        if (result == null) {
            return;
        }
        String path = file == null ? "" : file.getPath();
        for (Dependency unresolvedDependency : result.getUnresolvedDependencies()) {
            Iterator iterator = result.getResolutionErrors(unresolvedDependency).iterator();
            if (!iterator.hasNext()) continue;
            Exception exception = (Exception)iterator.next();
            String message = Maven3XServerEmbedder.getRootMessage(exception);
            Artifact artifact = RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)unresolvedDependency.getArtifact());
            MavenArtifact mavenArtifact = MavenModelConverter.convertArtifact((Artifact)artifact, (File)this.getLocalRepositoryFile());
            problems.add(MavenProjectProblem.createUnresolvedArtifactProblem((String)path, (String)message, (boolean)true, (MavenArtifact)mavenArtifact));
        }
    }

    @NotNull
    private static String getRootMessage(Throwable each) {
        String baseMessage = each.getMessage() != null ? each.getMessage() : "";
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)each);
        String rootMessage = rootCause != null ? rootCause.getMessage() : "";
        String string = StringUtils.isNotEmpty((String)rootMessage) ? rootMessage : baseMessage;
        if (string == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Nullable
    private static Artifact getProblemTransferArtifact(Throwable each) throws RemoteException {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)each);
        if (throwables == null) {
            return null;
        }
        for (Throwable throwable : throwables) {
            if (!(throwable instanceof ArtifactTransferException)) continue;
            return RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)((ArtifactTransferException)throwable).getArtifact());
        }
        return null;
    }

    @NotNull
    public MavenArtifact resolve(@NotNull MavenArtifactInfo info, @NotNull List<MavenRemoteRepository> remoteRepositories, MavenToken token) throws RemoteException {
        if (info == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(26);
        }
        if (remoteRepositories == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(27);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        MavenArtifact mavenArtifact = this.doResolve(info, remoteRepositories);
        if (mavenArtifact == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(28);
        }
        return mavenArtifact;
    }

    @Deprecated
    @NotNull
    public List<MavenArtifact> resolveTransitively(final @NotNull List<MavenArtifactInfo> artifacts, final @NotNull List<MavenRemoteRepository> remoteRepositories, MavenToken token) throws RemoteException {
        List list;
        if (artifacts == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(29);
        }
        if (remoteRepositories == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(30);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            MavenExecutionRequest request = this.createRequest(null, null, null, null);
            final Ref mavenArtifacts = Ref.create();
            this.executeWithMavenSession(request, new Maven3ServerEmbedder.RunnableThrownRemote(){

                public void run() throws RemoteException {
                    mavenArtifacts.set((Object)Maven3XServerEmbedder.this.doResolveTransitively(artifacts, remoteRepositories));
                }
            });
            list = (List)mavenArtifacts.get();
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtilRt.getThrowableText((Throwable)e, (String)"com.intellij"));
        }
        if (list == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    public MavenArtifactResolveResult resolveArtifactTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories, MavenToken token) throws RemoteException {
        if (artifacts == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(32);
        }
        if (remoteRepositories == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(33);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            MavenExecutionRequest request = this.createRequest(null, null, null, null);
            Ref mavenArtifacts = Ref.create();
            this.executeWithMavenSession(request, () -> {
                try {
                    mavenArtifacts.set(this.doResolveTransitivelyWithError(artifacts, remoteRepositories));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            return new MavenArtifactResolveResult((List)mavenArtifacts.get(), null);
        }
        catch (Exception e) {
            MavenProjectProblem problem;
            Maven3ServerGlobals.getLogger().error((Throwable)e);
            Artifact transferArtifact = Maven3XServerEmbedder.getProblemTransferArtifact(e);
            String message = Maven3XServerEmbedder.getRootMessage(e);
            if (transferArtifact != null) {
                MavenArtifact mavenArtifact = MavenModelConverter.convertArtifact((Artifact)transferArtifact, (File)this.getLocalRepositoryFile());
                problem = MavenProjectProblem.createRepositoryProblem((String)"", (String)message, (boolean)true, (MavenArtifact)mavenArtifact);
            } else {
                problem = MavenProjectProblem.createStructureProblem((String)"", (String)message);
            }
            return new MavenArtifactResolveResult(Collections.emptyList(), problem);
        }
    }

    @NotNull
    private List<MavenArtifact> doResolveTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories) throws RemoteException {
        List list;
        if (artifacts == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(34);
        }
        if (remoteRepositories == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(35);
        }
        try {
            LinkedHashSet<Artifact> toResolve = new LinkedHashSet<Artifact>();
            for (MavenArtifactInfo each : artifacts) {
                toResolve.add(this.createArtifact(each));
            }
            Artifact project = this.getComponent(ArtifactFactory.class).createBuildArtifact("temp", "temp", "666", "pom");
            Set res = this.getComponent(ArtifactResolver.class).resolveTransitively(toResolve, project, Collections.emptyMap(), this.myLocalRepository, this.convertRepositories(remoteRepositories), this.getComponent(ArtifactMetadataSource.class)).getArtifacts();
            list = MavenModelConverter.convertArtifacts((Collection)res, new HashMap(), (File)this.getLocalRepositoryFile());
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().info((Throwable)e);
            throw this.rethrowException(e);
        }
        if (list == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(36);
        }
        return list;
    }

    @NotNull
    private List<MavenArtifact> doResolveTransitivelyWithError(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories) throws RemoteException, ArtifactResolutionException, ArtifactNotFoundException {
        if (artifacts == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(37);
        }
        if (remoteRepositories == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(38);
        }
        LinkedHashSet<Artifact> toResolve = new LinkedHashSet<Artifact>();
        for (MavenArtifactInfo each : artifacts) {
            toResolve.add(this.createArtifact(each));
        }
        Artifact project = this.getComponent(ArtifactFactory.class).createBuildArtifact("temp", "temp", "666", "pom");
        Set res = this.getComponent(ArtifactResolver.class).resolveTransitively(toResolve, project, Collections.emptyMap(), this.myLocalRepository, this.convertRepositories(remoteRepositories), this.getComponent(ArtifactMetadataSource.class)).getArtifacts();
        List list = MavenModelConverter.convertArtifacts((Collection)res, new HashMap(), (File)this.getLocalRepositoryFile());
        if (list == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(39);
        }
        return list;
    }

    public Collection<MavenArtifact> resolvePlugin(@NotNull MavenPlugin plugin, @NotNull List<MavenRemoteRepository> repositories, int nativeMavenProjectId, boolean transitive, MavenToken token) throws RemoteException {
        if (plugin == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(40);
        }
        if (repositories == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(41);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            Plugin mavenPlugin = new Plugin();
            mavenPlugin.setGroupId(plugin.getGroupId());
            mavenPlugin.setArtifactId(plugin.getArtifactId());
            mavenPlugin.setVersion(plugin.getVersion());
            MavenProject project = RemoteNativeMavenProjectHolder.findProjectById((int)nativeMavenProjectId);
            Plugin pluginFromProject = (Plugin)project.getBuild().getPluginsAsMap().get(plugin.getGroupId() + ':' + plugin.getArtifactId());
            if (pluginFromProject != null) {
                mavenPlugin.setDependencies(pluginFromProject.getDependencies());
            }
            MavenExecutionRequest request = this.createRequest(null, null, null, null);
            request.setTransferListener((TransferListener)new TransferListenerAdapter((MavenServerProgressIndicator)this.myCurrentIndicator));
            DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
            RepositorySystemSession repositorySystemSession = maven.newRepositorySession(request);
            this.myImporterSpy.setIndicator((MavenServerProgressIndicator)this.myCurrentIndicator);
            PluginDependenciesResolver pluginDependenciesResolver = this.getComponent(PluginDependenciesResolver.class);
            org.eclipse.aether.artifact.Artifact pluginArtifact = pluginDependenciesResolver.resolve(mavenPlugin, project.getRemotePluginRepositories(), repositorySystemSession);
            org.eclipse.aether.graph.DependencyNode node = pluginDependenciesResolver.resolve(mavenPlugin, pluginArtifact, null, project.getRemotePluginRepositories(), repositorySystemSession);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            node.accept((DependencyVisitor)nlg);
            ArrayList<MavenArtifact> res = new ArrayList<MavenArtifact>();
            for (org.eclipse.aether.artifact.Artifact artifact : nlg.getArtifacts(true)) {
                if (Objects.equals(artifact.getArtifactId(), plugin.getArtifactId()) && Objects.equals(artifact.getGroupId(), plugin.getGroupId())) continue;
                res.add(MavenModelConverter.convertArtifact((Artifact)RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)artifact), (File)this.getLocalRepositoryFile()));
            }
            return res;
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().info((Throwable)e);
            return Collections.emptyList();
        }
    }

    @Nullable
    public MavenModel readModel(File file, MavenToken token) throws RemoteException {
        MavenServerUtil.checkToken((MavenToken)token);
        HashMap<String, FileModelSource> inputOptions = new HashMap<String, FileModelSource>();
        inputOptions.put("org.apache.maven.model.building.source", new FileModelSource(file));
        ModelReader reader = null;
        if (!StringUtilRt.endsWithIgnoreCase((CharSequence)file.getName(), (CharSequence)"xml")) {
            try {
                Object polyglotManager = this.myContainer.lookup("org.sonatype.maven.polyglot.PolyglotModelManager");
                if (polyglotManager != null) {
                    Method getReaderFor = polyglotManager.getClass().getMethod("getReaderFor", Map.class);
                    reader = (ModelReader)getReaderFor.invoke(polyglotManager, inputOptions);
                }
            }
            catch (ComponentLookupException polyglotManager) {
            }
            catch (Throwable e) {
                Maven3ServerGlobals.getLogger().warn(e);
            }
        }
        if (reader == null) {
            try {
                reader = (ModelReader)this.myContainer.lookup(ModelReader.class);
            }
            catch (ComponentLookupException e) {
                // empty catch block
            }
        }
        if (reader != null) {
            try {
                Model model = reader.read(file, inputOptions);
                return MavenModelConverter.convertModel((Model)model, null);
            }
            catch (Exception e) {
                Maven3ServerGlobals.getLogger().warn((Throwable)e);
            }
        }
        return null;
    }

    private MavenArtifact doResolve(MavenArtifactInfo info, List<MavenRemoteRepository> remoteRepositories) throws RemoteException {
        Artifact resolved = this.doResolve(this.createArtifact(info), this.convertRepositories(remoteRepositories));
        return MavenModelConverter.convertArtifact((Artifact)resolved, (File)this.getLocalRepositoryFile());
    }

    private Artifact doResolve(Artifact artifact, List<ArtifactRepository> remoteRepositories) throws RemoteException {
        try {
            return this.resolve(artifact, remoteRepositories);
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().info((Throwable)e);
            return artifact;
        }
    }

    private Artifact resolve(@NotNull Artifact artifact, @NotNull List<ArtifactRepository> repos) throws ArtifactResolutionException, ArtifactNotFoundException, RemoteException, org.eclipse.aether.resolution.ArtifactResolutionException {
        if (artifact == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(42);
        }
        if (repos == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(43);
        }
        String mavenVersion = this.getMavenVersion();
        this.myImporterSpy.setIndicator((MavenServerProgressIndicator)this.myCurrentIndicator);
        if (USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING || VersionComparatorUtil.compare((String)mavenVersion, (String)"3.2.5") < 0) {
            DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
            request.setRemoteRepositories(repos);
            try {
                this.getComponent(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)request, this.myMavenSettings);
                this.getComponent(MavenExecutionRequestPopulator.class).populateDefaults((MavenExecutionRequest)request);
            }
            catch (MavenExecutionRequestPopulationException e) {
                throw new RuntimeException(e);
            }
            this.getComponent(ArtifactResolver.class).resolve(artifact, request.getRemoteRepositories(), this.myLocalRepository);
            return artifact;
        }
        MavenExecutionRequest request = this.createRequest(null, null, null, null);
        for (ArtifactRepository artifactRepository : repos) {
            request.addRemoteRepository(artifactRepository);
        }
        DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
        RepositorySystemSession repositorySystemSession = maven.newRepositorySession(request);
        this.initLogging(this.myConsoleWrapper);
        RemoteRepositoryManager remoteRepositoryManager = this.getComponent(RemoteRepositoryManager.class);
        org.eclipse.aether.RepositorySystem repositorySystem = this.getComponent(org.eclipse.aether.RepositorySystem.class);
        List repositories = RepositoryUtils.toRepos(repos);
        repositories = remoteRepositoryManager.aggregateRepositories(repositorySystemSession, new ArrayList(), repositories, false);
        ArtifactResult artifactResult = repositorySystem.resolveArtifact(repositorySystemSession, new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)artifact), repositories, null));
        return RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)artifactResult.getArtifact());
    }

    protected abstract void initLogging(Maven3ServerConsoleLogger var1);

    @NotNull
    protected List<ArtifactRepository> convertRepositories(List<MavenRemoteRepository> repositories) throws RemoteException {
        List result = this.map2ArtifactRepositories(repositories);
        if (this.getComponent(LegacySupport.class).getRepositorySession() == null) {
            this.myRepositorySystem.injectMirror(result, this.myMavenSettings.getMirrors());
            this.myRepositorySystem.injectProxy(result, this.myMavenSettings.getProxies());
            this.myRepositorySystem.injectAuthentication(result, this.myMavenSettings.getServers());
        }
        List list = result;
        if (list == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(44);
        }
        return list;
    }

    private Artifact createArtifact(MavenArtifactInfo info) {
        return this.getComponent(ArtifactFactory.class).createArtifactWithClassifier(info.getGroupId(), info.getArtifactId(), info.getVersion(), info.getPackaging(), info.getClassifier());
    }

    @NotNull
    public MavenServerExecutionResult execute(@NotNull File file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles, @NotNull List<String> goals, @NotNull List<String> selectedProjects, boolean alsoMake, boolean alsoMakeDependents, MavenToken token) throws RemoteException {
        if (file == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(45);
        }
        if (activeProfiles == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(46);
        }
        if (inactiveProfiles == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(47);
        }
        if (goals == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(48);
        }
        if (selectedProjects == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(49);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        MavenExecutionResult result = this.doExecute(file, new ArrayList<String>(activeProfiles), new ArrayList<String>(inactiveProfiles), goals, selectedProjects, alsoMake, alsoMakeDependents);
        return this.createExecutionResult(file, result, null);
    }

    private MavenExecutionResult doExecute(@NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, @NotNull List<String> goals, @NotNull List<String> selectedProjects, boolean alsoMake, boolean alsoMakeDependents) throws RemoteException {
        if (file == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(50);
        }
        if (activeProfiles == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(51);
        }
        if (inactiveProfiles == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(52);
        }
        if (goals == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(53);
        }
        if (selectedProjects == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(54);
        }
        MavenExecutionRequest request = this.createRequest(file, activeProfiles, inactiveProfiles, goals);
        if (!selectedProjects.isEmpty()) {
            request.setRecursive(true);
            request.setSelectedProjects(selectedProjects);
            if (alsoMake && alsoMakeDependents) {
                request.setMakeBehavior("make-both");
            } else if (alsoMake) {
                request.setMakeBehavior("make");
            } else if (alsoMakeDependents) {
                request.setMakeBehavior("make-dependents");
            }
        }
        org.apache.maven.execution.MavenExecutionResult executionResult = this.safeExecute(request, this.getComponent(Maven.class));
        return new MavenExecutionResult(executionResult.getProject(), Maven3XServerEmbedder.filterExceptions(executionResult.getExceptions()));
    }

    private org.apache.maven.execution.MavenExecutionResult safeExecute(MavenExecutionRequest request, Maven maven) throws RemoteException {
        MavenLeakDetector detector = new MavenLeakDetector().mark();
        org.apache.maven.execution.MavenExecutionResult result = maven.execute(request);
        detector.check();
        return result;
    }

    public void reset(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            RepositoryMetadataManager repositoryMetadataManager;
            ArtifactResolver artifactResolver;
            if (this.myCurrentIndicator != null) {
                UnicastRemoteObject.unexportObject((Remote)this.myCurrentIndicator, false);
            }
            this.myCurrentIndicator = null;
            this.myConsoleWrapper.setWrappee(null);
            ArtifactFactory artifactFactory = this.getComponent(ArtifactFactory.class);
            if (artifactFactory instanceof CustomMaven3ArtifactFactory) {
                ((CustomMaven3ArtifactFactory)artifactFactory).reset();
            }
            if ((artifactResolver = this.getComponent(ArtifactResolver.class)) instanceof CustomMaven3ArtifactResolver) {
                ((CustomMaven3ArtifactResolver)artifactResolver).reset();
            }
            if ((repositoryMetadataManager = this.getComponent(RepositoryMetadataManager.class)) instanceof CustomMaven3RepositoryMetadataManager) {
                ((CustomMaven3RepositoryMetadataManager)repositoryMetadataManager).reset();
            }
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    public void release(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        this.myContainer.dispose();
    }

    public void clearCaches(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
    }

    public void clearCachesFor(MavenId projectId, MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
    }

    protected ArtifactRepository getLocalRepository() {
        return this.myLocalRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/Maven3XServerEmbedder";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 11: 
            case 15: 
            case 18: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 13: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelProblems";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 27: 
            case 30: 
            case 33: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositories";
                break;
            }
            case 29: 
            case 32: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repos";
                break;
            }
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goals";
                break;
            }
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "interpolateAndAlignModel";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/Maven3XServerEmbedder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doInterpolate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doInterpolate325";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doInterpolate330";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "customizeAndGetProgressIndicator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProject";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveProject";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifacts";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultimoduleProjectDir";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootMessage";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTransitively";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveTransitively";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveTransitivelyWithError";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInterpolate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doInterpolate325";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doInterpolate330";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveProject";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "evaluateEffectivePom";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doResolveProject";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "collectProblems";
                break;
            }
            case 26: 
            case 27: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resolveTransitively";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifactTransitively";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "doResolveTransitively";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "doResolveTransitivelyWithError";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlugin";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

