/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.gradle.configuration.ui;

import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.project.Project;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.AnalyticsAwareConfigurableContributorDriver;
import com.jetbrains.packagesearch.intellij.plugin.fus.PackageSearchEventsLogger;
import com.jetbrains.packagesearch.intellij.plugin.gradle.configuration.PackageSearchGradleConfiguration;
import com.jetbrains.packagesearch.intellij.plugin.gradle.configuration.ui.GradleConfigurableContributorDriver;
import com.jetbrains.packagesearch.intellij.plugin.ui.PackageSearchUI;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.SwingUtilsKt;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\u0012\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\u0011H\u0016J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/gradle/configuration/ui/GradleConfigurableContributorDriver;", "Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/AnalyticsAwareConfigurableContributorDriver;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configuration", "Lcom/jetbrains/packagesearch/intellij/plugin/gradle/configuration/PackageSearchGradleConfiguration;", "gradleDefaultScopeEditor", "Ljavax/swing/JTextField;", "gradleScopesEditor", "isDefaultScopeModified", "", "isScopesModified", "isUpdateScopesModified", "updateScopesOnUsageEditor", "Ljavax/swing/JCheckBox;", "apply", "", "contributeUserInterface", "builder", "Lcom/intellij/util/ui/FormBuilder;", "isModified", "provideApplyEventAnalyticsData", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "reset", "restoreDefaults", "normalizeScopesList", "", "intellij.packageSearch.gradle"})
public final class GradleConfigurableContributorDriver
implements AnalyticsAwareConfigurableContributorDriver {
    private boolean isScopesModified;
    private boolean isDefaultScopeModified;
    private boolean isUpdateScopesModified;
    private final PackageSearchGradleConfiguration configuration;
    private final JTextField gradleScopesEditor;
    private final JTextField gradleDefaultScopeEditor;
    private final JCheckBox updateScopesOnUsageEditor;

    @Override
    public void contributeUserInterface(@NotNull FormBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.addComponent((JComponent)new TitledSeparator(PackageSearchBundle.INSTANCE.message("packagesearch.configuration.gradle.title", new Object[0])), 0);
        builder.addLabeledComponent(PackageSearchBundle.INSTANCE.message("packagesearch.configuration.gradle.configurations", new Object[0]), (JComponent)this.gradleScopesEditor);
        builder.addComponentToRightColumn((JComponent)RelativeFont.TINY.install(RelativeFont.ITALIC.install((Component)PackageSearchUI.createLabel$default(PackageSearchUI.INSTANCE, PackageSearchBundle.INSTANCE.message("packagesearch.configuration.gradle.configurations.comma.separated", new Object[0]), null, 2, null))));
        builder.addComponentToRightColumn((JComponent)this.updateScopesOnUsageEditor);
        builder.addLabeledComponent(PackageSearchBundle.INSTANCE.message("packagesearch.configuration.gradle.configurations.default", new Object[0]), (JComponent)this.gradleDefaultScopeEditor);
    }

    @Override
    public boolean isModified() {
        return this.isScopesModified || this.isDefaultScopeModified || this.isUpdateScopesModified;
    }

    @Override
    public void reset() {
        this.gradleScopesEditor.setText(CollectionsKt.joinToString$default((Iterable)this.configuration.getGradleScopes(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        this.updateScopesOnUsageEditor.setSelected(this.configuration.getUpdateScopesOnUsage());
        this.gradleDefaultScopeEditor.setText(this.configuration.determineDefaultGradleScope());
        this.isScopesModified = false;
        this.isDefaultScopeModified = false;
        this.isUpdateScopesModified = false;
    }

    @Override
    public void restoreDefaults() {
        String defaultScopesText = StringsKt.replace$default((String)"api,implementation,testImplementation,annotationProcessor,kapt", (String)",", (String)", ", (boolean)false, (int)4, null);
        this.isScopesModified = Intrinsics.areEqual((Object)this.gradleScopesEditor.getText(), (Object)defaultScopesText) ^ true;
        this.gradleScopesEditor.setText(defaultScopesText);
        boolean defaultUpdateScopes = true;
        this.isUpdateScopesModified = this.updateScopesOnUsageEditor.isSelected() != defaultUpdateScopes;
        this.updateScopesOnUsageEditor.setSelected(defaultUpdateScopes);
        String defaultGradleDefaultScopeName = "implementation";
        this.isDefaultScopeModified = Intrinsics.areEqual((Object)this.gradleDefaultScopeEditor.getText(), (Object)defaultGradleDefaultScopeName) ^ true;
        this.gradleDefaultScopeEditor.setText(defaultGradleDefaultScopeName);
    }

    @Override
    public void apply() {
        String string = this.gradleScopesEditor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gradleScopesEditor.text");
        this.configuration.setGradleScopes(this.normalizeScopesList(string));
        this.configuration.setUpdateScopesOnUsage(this.updateScopesOnUsageEditor.isSelected());
        String string2 = this.gradleDefaultScopeEditor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gradleDefaultScopeEditor.text");
        String string3 = string2;
        this.configuration.setDefaultGradleScope(((Object)StringsKt.trim((CharSequence)string3)).toString());
        this.isScopesModified = false;
        this.isDefaultScopeModified = false;
        this.isUpdateScopesModified = false;
    }

    /*
     * WARNING - void declaration
     */
    private final String normalizeScopesList(String $this$normalizeScopesList) {
        void $this$filterTo$iv$iv;
        CharSequence charSequence;
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$normalizeScopesList, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            charSequence = it;
            String string2 = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
            collection.add(string2);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            charSequence = it;
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public List<EventPair<?>> provideApplyEventAnalyticsData() {
        boolean hasChangedDefaultScope = Intrinsics.areEqual((Object)this.configuration.getDefaultGradleScope(), (Object)"implementation") ^ true;
        return CollectionsKt.listOf((Object[])new EventPair[]{PackageSearchEventsLogger.Companion.getPreferencesGradleScopeCountField().with((Object)this.configuration.getGradleScopes().size()), PackageSearchEventsLogger.Companion.getPreferencesUpdateScopesOnUsageField().with((Object)this.configuration.getUpdateScopesOnUsage()), PackageSearchEventsLogger.Companion.getPreferencesDefaultGradleScopeChangedField().with((Object)hasChangedDefaultScope)});
    }

    public GradleConfigurableContributorDriver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.configuration = PackageSearchGradleConfiguration.Companion.getInstance(project);
        this.gradleScopesEditor = PackageSearchUI.INSTANCE.textField((Function1<? super JTextField, Unit>)((Function1)new Function1<JTextField, Unit>(this){
            final /* synthetic */ GradleConfigurableContributorDriver this$0;

            public final void invoke(@NotNull JTextField $this$textField) {
                Intrinsics.checkNotNullParameter((Object)$this$textField, (String)"$receiver");
                SwingUtilsKt.addOnTextChangedListener($this$textField, (Function1<? super DocumentEvent, Unit>)((Function1)new Function1<DocumentEvent, Unit>(this, $this$textField){
                    final /* synthetic */ gradleScopesEditor.1 this$0;
                    final /* synthetic */ JTextField $this_textField;

                    public final void invoke(@NotNull DocumentEvent it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        GradleConfigurableContributorDriver gradleConfigurableContributorDriver = this.this$0.this$0;
                        GradleConfigurableContributorDriver gradleConfigurableContributorDriver2 = this.this$0.this$0;
                        String string = this.$this_textField.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                        GradleConfigurableContributorDriver.access$setScopesModified$p(gradleConfigurableContributorDriver, Intrinsics.areEqual((Object)GradleConfigurableContributorDriver.access$normalizeScopesList(gradleConfigurableContributorDriver2, string), (Object)GradleConfigurableContributorDriver.access$getConfiguration$p(this.this$0.this$0).getGradleScopes()) ^ true);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$this_textField = jTextField;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = gradleConfigurableContributorDriver;
                super(1);
            }
        }));
        this.gradleDefaultScopeEditor = PackageSearchUI.INSTANCE.textField((Function1<? super JTextField, Unit>)((Function1)new Function1<JTextField, Unit>(this){
            final /* synthetic */ GradleConfigurableContributorDriver this$0;

            public final void invoke(@NotNull JTextField $this$textField) {
                Intrinsics.checkNotNullParameter((Object)$this$textField, (String)"$receiver");
                SwingUtilsKt.addOnTextChangedListener($this$textField, (Function1<? super DocumentEvent, Unit>)((Function1)new Function1<DocumentEvent, Unit>(this, $this$textField){
                    final /* synthetic */ gradleDefaultScopeEditor.1 this$0;
                    final /* synthetic */ JTextField $this_textField;

                    public final void invoke(@NotNull DocumentEvent it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        GradleConfigurableContributorDriver gradleConfigurableContributorDriver = this.this$0.this$0;
                        String string = this.$this_textField.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                        String string2 = string;
                        GradleConfigurableContributorDriver.access$setDefaultScopeModified$p(gradleConfigurableContributorDriver, Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string2)).toString(), (Object)GradleConfigurableContributorDriver.access$getConfiguration$p(this.this$0.this$0).getDefaultGradleScope()) ^ true);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$this_textField = jTextField;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = gradleConfigurableContributorDriver;
                super(1);
            }
        }));
        this.updateScopesOnUsageEditor = PackageSearchUI.INSTANCE.checkBox(PackageSearchBundle.INSTANCE.message("packagesearch.configuration.update.scopes.on.usage", new Object[0]), (Function1<? super JCheckBox, Unit>)((Function1)new Function1<JCheckBox, Unit>(this){
            final /* synthetic */ GradleConfigurableContributorDriver this$0;

            public final void invoke(@NotNull JCheckBox $this$checkBox) {
                Intrinsics.checkNotNullParameter((Object)$this$checkBox, (String)"$receiver");
                $this$checkBox.addItemListener(new ItemListener(this){
                    final /* synthetic */ updateScopesOnUsageEditor.1 this$0;

                    public final void itemStateChanged(ItemEvent it) {
                        ItemEvent itemEvent = it;
                        Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"it");
                        boolean newIsSelected = itemEvent.getStateChange() == 1;
                        GradleConfigurableContributorDriver.access$setUpdateScopesModified$p(this.this$0.this$0, newIsSelected != GradleConfigurableContributorDriver.access$getConfiguration$p(this.this$0.this$0).getUpdateScopesOnUsage());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = gradleConfigurableContributorDriver;
                super(1);
            }
        }));
    }

    public static final /* synthetic */ boolean access$isScopesModified$p(GradleConfigurableContributorDriver $this) {
        return $this.isScopesModified;
    }

    public static final /* synthetic */ void access$setScopesModified$p(GradleConfigurableContributorDriver $this, boolean bl) {
        $this.isScopesModified = bl;
    }

    public static final /* synthetic */ String access$normalizeScopesList(GradleConfigurableContributorDriver $this, String $this$access_u24normalizeScopesList) {
        return $this.normalizeScopesList($this$access_u24normalizeScopesList);
    }

    public static final /* synthetic */ PackageSearchGradleConfiguration access$getConfiguration$p(GradleConfigurableContributorDriver $this) {
        return $this.configuration;
    }

    public static final /* synthetic */ boolean access$isDefaultScopeModified$p(GradleConfigurableContributorDriver $this) {
        return $this.isDefaultScopeModified;
    }

    public static final /* synthetic */ void access$setDefaultScopeModified$p(GradleConfigurableContributorDriver $this, boolean bl) {
        $this.isDefaultScopeModified = bl;
    }

    public static final /* synthetic */ boolean access$isUpdateScopesModified$p(GradleConfigurableContributorDriver $this) {
        return $this.isUpdateScopesModified;
    }

    public static final /* synthetic */ void access$setUpdateScopesModified$p(GradleConfigurableContributorDriver $this, boolean bl) {
        $this.isUpdateScopesModified = bl;
    }
}

