/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.NamedTest;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestDefinition;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class ListenerDefinition {
    private static final String LEGACY_PLAIN = "legacy-plain";
    private static final String LEGACY_BRIEF = "legacy-brief";
    private static final String LEGACY_XML = "legacy-xml";
    private String ifProperty;
    private String unlessProperty;
    private String className;
    private String resultFile;
    private boolean sendSysOut;
    private boolean sendSysErr;
    private String defaultResultFileSuffix = "txt";

    public void setClassName(String className) {
        this.className = className;
    }

    String getClassName() {
        return this.className;
    }

    String getIfProperty() {
        return this.ifProperty;
    }

    public void setIf(String ifProperty) {
        this.ifProperty = ifProperty;
    }

    String getUnlessProperty() {
        return this.unlessProperty;
    }

    public void setUnless(String unlessProperty) {
        this.unlessProperty = unlessProperty;
    }

    public void setType(ListenerType type) {
        switch (type.getValue()) {
            case "legacy-plain": {
                this.setClassName("org.apache.tools.ant.taskdefs.optional.junitlauncher.LegacyPlainResultFormatter");
                this.defaultResultFileSuffix = "txt";
                break;
            }
            case "legacy-brief": {
                this.setClassName("org.apache.tools.ant.taskdefs.optional.junitlauncher.LegacyBriefResultFormatter");
                this.defaultResultFileSuffix = "txt";
                break;
            }
            case "legacy-xml": {
                this.setClassName("org.apache.tools.ant.taskdefs.optional.junitlauncher.LegacyXmlResultFormatter");
                this.defaultResultFileSuffix = "xml";
            }
        }
    }

    public void setResultFile(String filename) {
        this.resultFile = filename;
    }

    String requireResultFile(TestDefinition test) {
        if (this.resultFile != null) {
            return this.resultFile;
        }
        StringBuilder sb = new StringBuilder("TEST-");
        if (test instanceof NamedTest) {
            sb.append(((NamedTest)((Object)test)).getName());
        } else {
            sb.append("unknown");
        }
        sb.append(".").append(this.defaultResultFileSuffix);
        return sb.toString();
    }

    public void setSendSysOut(boolean sendSysOut) {
        this.sendSysOut = sendSysOut;
    }

    boolean shouldSendSysOut() {
        return this.sendSysOut;
    }

    public void setSendSysErr(boolean sendSysErr) {
        this.sendSysErr = sendSysErr;
    }

    boolean shouldSendSysErr() {
        return this.sendSysErr;
    }

    protected boolean shouldUse(Project project) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(project);
        return propertyHelper.testIfCondition(this.ifProperty) && propertyHelper.testUnlessCondition(this.unlessProperty);
    }

    public static class ListenerType
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{ListenerDefinition.LEGACY_PLAIN, ListenerDefinition.LEGACY_BRIEF, ListenerDefinition.LEGACY_XML};
        }
    }
}

