/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.Maybe;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0002\u0017\u0018B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000b\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u000f\u001a\u00028\u00002\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0012j\u0002`\u00130\u0011H&\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0004\u001a\u0004\u0018\u00018\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0002\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lruntime/reactive/Maybe;", "T", "", "()V", "asNullable", "getAsNullable", "()Ljava/lang/Object;", "hasValue", "", "getHasValue", "()Z", "equals", "other", "hashCode", "", "orElseThrow", "err", "Lkotlin/Function0;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "toString", "", "Just", "None", "Lruntime/reactive/Maybe$None;", "Lruntime/reactive/Maybe$Just;", "platform-runtime"})
public abstract class Maybe<T> {
    private Maybe() {
    }

    public abstract boolean getHasValue();

    @Nullable
    public abstract T getAsNullable();

    public abstract T orElseThrow(@NotNull Function0<? extends IllegalStateException> var1);

    public final T orElseThrow() {
        return this.orElseThrow((Function0<IllegalStateException>)((Function0)orElseThrow.1.INSTANCE));
    }

    @NotNull
    public String toString() {
        if (this.getHasValue()) {
            return String.valueOf(((Just)this).getValue());
        }
        return "<null>";
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return false;
        }
        if (!(other instanceof Maybe)) {
            return false;
        }
        if (this.getHasValue() != ((Maybe)other).getHasValue()) {
            return false;
        }
        if (this.getHasValue()) {
            return Intrinsics.areEqual(this.getAsNullable(), ((Maybe)other).getAsNullable());
        }
        return true;
    }

    public int hashCode() {
        int n;
        if (this instanceof Just) {
            Object t = ((Just)this).getValue();
            n = t == null ? 0 : t.hashCode();
        } else {
            n = -1;
        }
        return n;
    }

    public /* synthetic */ Maybe(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00022\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lruntime/reactive/Maybe$None;", "Lruntime/reactive/Maybe;", "", "()V", "asNullable", "getAsNullable", "()Ljava/lang/Void;", "hasValue", "", "getHasValue", "()Z", "equals", "other", "", "hashCode", "", "orElseThrow", "err", "Lkotlin/Function0;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "toString", "", "platform-runtime"})
    public static final class None
    extends Maybe {
        @NotNull
        public static final None INSTANCE = new None();

        private None() {
            super(null);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return other == INSTANCE;
        }

        @Override
        public int hashCode() {
            return -1;
        }

        @Override
        @NotNull
        public String toString() {
            return "Maybe.None";
        }

        @NotNull
        public Void orElseThrow(@NotNull Function0<? extends IllegalStateException> err) {
            Intrinsics.checkNotNullParameter(err, (String)"err");
            throw (Throwable)err.invoke();
        }

        @Override
        public boolean getHasValue() {
            return false;
        }

        @Nullable
        public Void getAsNullable() {
            return null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001f\u0010\u0013\u001a\u00028\u00012\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0016j\u0002`\u00170\u0015H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00018\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\f\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lruntime/reactive/Maybe$Just;", "T", "Lruntime/reactive/Maybe;", "value", "(Ljava/lang/Object;)V", "asNullable", "getAsNullable", "()Ljava/lang/Object;", "hasValue", "", "getHasValue", "()Z", "getValue", "Ljava/lang/Object;", "equals", "other", "", "hashCode", "", "orElseThrow", "err", "Lkotlin/Function0;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "toString", "", "platform-runtime"})
    public static final class Just<T>
    extends Maybe<T> {
        private final T value;

        public Just(T value2) {
            super(null);
            this.value = value2;
        }

        public final T getValue() {
            return this.value;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return other instanceof Just ? Intrinsics.areEqual(((Just)other).value, this.value) : false;
        }

        @Override
        public int hashCode() {
            int n;
            T t = this.value;
            return t == null ? 0 : (n = t.hashCode());
        }

        @Override
        @NotNull
        public String toString() {
            return "Maybe.Just(" + this.value + ')';
        }

        @Override
        public T orElseThrow(@NotNull Function0<? extends IllegalStateException> err) {
            Intrinsics.checkNotNullParameter(err, (String)"err");
            return this.value;
        }

        @Override
        public boolean getHasValue() {
            return true;
        }

        @Override
        @Nullable
        public T getAsNullable() {
            return this.value;
        }
    }
}

