/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.LifetimedValue;
import runtime.reactive.Maybe;
import runtime.reactive.SequentialLifetimes;
import runtime.reactive.Source;
import runtime.reactive.ValueSource;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0011J*\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00062\u0018\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0004\u0012\u00020\u00110\u0018H\u0016J)\u0010\u0019\u001a\u00020\u00062!\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00028\u00000\u0018J\u0013\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lruntime/reactive/LifetimedValueSource;", "T", "Lruntime/reactive/Source;", "Lruntime/reactive/LifetimedValue;", "Lruntime/reactive/LifetimedValueView;", "sourceLifetime", "Llibraries/coroutines/extra/Lifetime;", "(Llibraries/coroutines/extra/Lifetime;)V", "lifetimes", "Lruntime/reactive/SequentialLifetimes;", "maybeLifetimedValue", "Lruntime/reactive/Maybe;", "getMaybeLifetimedValue", "()Lruntime/reactive/Maybe;", "valueSource", "Lruntime/reactive/ValueSource;", "applyValue", "", "value", "lifetime", "(Ljava/lang/Object;Llibraries/coroutines/extra/Lifetime;)V", "clearValue", "forEach", "sink", "Lkotlin/Function1;", "setValue", "builder", "Lkotlin/ParameterName;", "name", "(Ljava/lang/Object;)Llibraries/coroutines/extra/Lifetime;", "platform-runtime"})
public final class LifetimedValueSource<T>
implements Source<LifetimedValue<? extends T>> {
    @NotNull
    private final Lifetime sourceLifetime;
    @NotNull
    private final ValueSource<LifetimedValue<T>> valueSource;
    @NotNull
    private final SequentialLifetimes lifetimes;

    public LifetimedValueSource(@NotNull Lifetime sourceLifetime) {
        Intrinsics.checkNotNullParameter((Object)sourceLifetime, (String)"sourceLifetime");
        this.sourceLifetime = sourceLifetime;
        this.valueSource = new ValueSource();
        this.lifetimes = new SequentialLifetimes(this.sourceLifetime);
    }

    @NotNull
    public final Maybe<LifetimedValue<T>> getMaybeLifetimedValue() {
        return this.valueSource.getMaybeValue();
    }

    @NotNull
    public final Lifetime setValue(T value2) {
        if (this.sourceLifetime.isTerminated()) {
            throw new IllegalStateException("Source lifetime terminated.".toString());
        }
        Lifetime valueLifetime = this.lifetimes.next();
        this.applyValue(value2, valueLifetime);
        return valueLifetime;
    }

    @NotNull
    public final Lifetime setValue(@NotNull Function1<? super Lifetime, ? extends T> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        if (this.sourceLifetime.isTerminated()) {
            throw new IllegalStateException("Source lifetime terminated.".toString());
        }
        Lifetime valueLifetime = this.lifetimes.next();
        Object value2 = builder.invoke((Object)valueLifetime);
        this.applyValue(value2, valueLifetime);
        return valueLifetime;
    }

    private final void applyValue(T value2, Lifetime lifetime) {
        lifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ LifetimedValueSource<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                LifetimedValueSource.access$getValueSource$p(this.this$0).clearValue();
            }
        }));
        this.valueSource.setValue(new LifetimedValue<T>(value2, lifetime));
    }

    public final void clearValue() {
        this.lifetimes.clear();
    }

    @Override
    public void forEach(@NotNull Lifetime lifetime, @NotNull Function1<? super LifetimedValue<? extends T>, Unit> sink2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(sink2, (String)"sink");
        if (lifetime.isTerminated()) {
            return;
        }
        this.valueSource.forEach(lifetime, sink2);
    }

    @Override
    public void forEachWithPrevious(@NotNull Lifetime lifetime, @NotNull Function2<? super LifetimedValue<? extends T>, ? super LifetimedValue<? extends T>, Unit> consume) {
        Source.DefaultImpls.forEachWithPrevious(this, lifetime, consume);
    }

    public static final /* synthetic */ ValueSource access$getValueSource$p(LifetimedValueSource $this) {
        return $this.valueSource;
    }
}

