/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.matcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;

public class MapMatcher {
    private Map<String, Matcher> matchers = new HashMap<String, Matcher>();
    private PatternMatcher pm;
    private Map<String, String> attributes;

    public MapMatcher(Map<String, String> attributes, PatternMatcher pm) {
        this.attributes = attributes;
        this.pm = pm;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String value2 = entry.getValue();
            if (value2 == null) continue;
            this.matchers.put(entry.getKey(), pm.getMatcher(value2));
        }
    }

    public boolean matches(Map<String, String> m2) {
        for (Map.Entry<String, Matcher> entry : this.matchers.entrySet()) {
            Matcher matcher2 = entry.getValue();
            String value2 = m2.get(entry.getKey());
            if (value2 != null && matcher2.matches(value2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.attributes + " (" + this.pm.getName() + ")";
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public PatternMatcher getPatternMatcher() {
        return this.pm;
    }
}

