/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.circular;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public final class CircularDependencyHelper {
    private CircularDependencyHelper() {
    }

    public static String formatMessage(ModuleRevisionId[] mrids) {
        HashSet<ModuleRevisionId> alreadyAdded = new HashSet<ModuleRevisionId>();
        StringBuilder buff = new StringBuilder();
        for (ModuleRevisionId mrid : mrids) {
            if (buff.length() > 0) {
                buff.append("->");
            }
            if (!alreadyAdded.add(mrid)) {
                buff.append("...");
                break;
            }
            buff.append(mrid);
        }
        return buff.toString();
    }

    public static String formatMessage(ModuleDescriptor[] descriptors) {
        return CircularDependencyHelper.formatMessageFromDescriptors(Arrays.asList(descriptors));
    }

    public static String formatMessageFromDescriptors(List<ModuleDescriptor> loopElements) {
        LinkedList<ModuleRevisionId> mrids = new LinkedList<ModuleRevisionId>();
        for (ModuleDescriptor descriptor2 : loopElements) {
            mrids.add(descriptor2.getModuleRevisionId());
        }
        return CircularDependencyHelper.formatMessage(mrids.toArray(new ModuleRevisionId[mrids.size()]));
    }
}

