/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public class OverrideDependencyDescriptorMediator
implements DependencyDescriptorMediator {
    private String version;
    private String branch;

    public OverrideDependencyDescriptorMediator(String branch2, String version) {
        this.branch = branch2;
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBranch() {
        return this.branch;
    }

    @Override
    public DependencyDescriptor mediate(DependencyDescriptor dd) {
        String branch2;
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        if ((this.version == null || this.version.equals(mrid.getRevision())) && (this.branch == null || this.branch.equals(mrid.getBranch()))) {
            return dd;
        }
        String version = this.version == null ? mrid.getRevision() : this.version;
        String string2 = branch2 = this.branch == null ? mrid.getBranch() : this.branch;
        if (version.equals(dd.getDependencyRevisionId().getRevision()) && branch2.equals(dd.getDependencyRevisionId().getBranch())) {
            return dd;
        }
        return dd.clone(ModuleRevisionId.newInstance(mrid.getOrganisation(), mrid.getName(), branch2, version, mrid.getQualifiedExtraAttributes()));
    }
}

