/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;

public final class IvyPatternHelper {
    public static final String CONF_KEY = "conf";
    public static final String TYPE_KEY = "type";
    public static final String EXT_KEY = "ext";
    public static final String ARTIFACT_KEY = "artifact";
    public static final String BRANCH_KEY = "branch";
    public static final String REVISION_KEY = "revision";
    public static final String MODULE_KEY = "module";
    public static final String ORGANISATION_KEY = "organisation";
    public static final String ORGANISATION_KEY2 = "organization";
    public static final String ORGANISATION_PATH_KEY = "orgPath";
    public static final String ORIGINAL_ARTIFACTNAME_KEY = "originalname";
    private static final Pattern PARAM_PATTERN = Pattern.compile("\\@\\{(.*?)\\}");
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");

    private IvyPatternHelper() {
    }

    public static String substitute(String pattern2, ModuleRevisionId moduleRevision) {
        return IvyPatternHelper.substitute(pattern2, moduleRevision.getOrganisation(), moduleRevision.getName(), moduleRevision.getBranch(), moduleRevision.getRevision(), "ivy", "ivy", "xml", null, null, moduleRevision.getQualifiedExtraAttributes(), null);
    }

    public static String substitute(String pattern2, ModuleRevisionId moduleRevision, String artifact, String type, String ext2) {
        return IvyPatternHelper.substitute(pattern2, moduleRevision, new DefaultArtifact(moduleRevision, null, artifact, type, ext2));
    }

    public static String substitute(String pattern2, Artifact artifact) {
        return IvyPatternHelper.substitute(pattern2, artifact, (String)null);
    }

    public static String substitute(String pattern2, Artifact artifact, ArtifactOrigin origin) {
        return IvyPatternHelper.substitute(pattern2, artifact.getModuleRevisionId(), artifact, null, origin);
    }

    public static String substitute(String pattern2, Artifact artifact, String conf) {
        return IvyPatternHelper.substitute(pattern2, artifact.getModuleRevisionId(), artifact, conf, null);
    }

    public static String substitute(String pattern2, ModuleRevisionId mrid, Artifact artifact) {
        return IvyPatternHelper.substitute(pattern2, mrid, artifact, null, null);
    }

    public static String substitute(String pattern2, ModuleRevisionId mrid, Artifact artifact, String conf, ArtifactOrigin origin) {
        return IvyPatternHelper.substitute(pattern2, mrid.getOrganisation(), mrid.getName(), mrid.getBranch(), mrid.getRevision(), artifact.getName(), artifact.getType(), artifact.getExt(), conf, origin, mrid.getQualifiedExtraAttributes(), artifact.getQualifiedExtraAttributes());
    }

    public static String substitute(String pattern2, String org, String module2, String revision, String artifact, String type, String ext2) {
        return IvyPatternHelper.substitute(pattern2, org, module2, null, revision, artifact, type, ext2, null, null, null, null);
    }

    public static String substitute(String pattern2, String org, String module2, String revision, String artifact, String type, String ext2, String conf) {
        return IvyPatternHelper.substitute(pattern2, org, module2, null, revision, artifact, type, ext2, conf, null, null, null);
    }

    public static String substitute(String pattern2, String org, String module2, String revision, String artifact, String type, String ext2, String conf, Map<String, String> extraModuleAttributes, Map<String, String> extraArtifactAttributes) {
        return IvyPatternHelper.substitute(pattern2, org, module2, null, revision, artifact, type, ext2, conf, null, extraModuleAttributes, extraArtifactAttributes);
    }

    public static String substitute(String pattern2, String org, String module2, String branch2, String revision, String artifact, String type, String ext2, String conf, ArtifactOrigin origin, Map<String, String> extraModuleAttributes, Map<String, String> extraArtifactAttributes) {
        String token2;
        HashMap<String, Object> tokens2 = new HashMap<String, Object>();
        if (extraModuleAttributes != null) {
            for (Map.Entry<String, String> entry : extraModuleAttributes.entrySet()) {
                token2 = entry.getKey();
                if (token2.indexOf(58) > 0) {
                    token2 = token2.substring(token2.indexOf(58) + 1);
                }
                tokens2.put(token2, entry.getValue());
            }
        }
        if (extraArtifactAttributes != null) {
            for (Map.Entry<String, String> entry : extraArtifactAttributes.entrySet()) {
                token2 = entry.getKey();
                if (token2.indexOf(58) > 0) {
                    token2 = token2.substring(token2.indexOf(58) + 1);
                }
                tokens2.put(token2, entry.getValue());
            }
        }
        tokens2.put(ORGANISATION_KEY, org == null ? "" : org);
        tokens2.put(ORGANISATION_KEY2, org == null ? "" : org);
        tokens2.put(ORGANISATION_PATH_KEY, org == null ? "" : org.replace('.', '/'));
        tokens2.put(MODULE_KEY, module2 == null ? "" : module2);
        tokens2.put(BRANCH_KEY, branch2 == null ? "" : branch2);
        tokens2.put(REVISION_KEY, revision == null ? "" : revision);
        tokens2.put(ARTIFACT_KEY, artifact == null ? module2 : artifact);
        tokens2.put(TYPE_KEY, type == null ? "jar" : type);
        tokens2.put(EXT_KEY, ext2 == null ? "jar" : ext2);
        tokens2.put(CONF_KEY, conf == null ? "default" : conf);
        if (origin == null) {
            tokens2.put(ORIGINAL_ARTIFACTNAME_KEY, new OriginalArtifactNameValue(org, module2, branch2, revision, artifact, type, ext2, extraModuleAttributes, extraArtifactAttributes));
        } else {
            tokens2.put(ORIGINAL_ARTIFACTNAME_KEY, new OriginalArtifactNameValue(origin));
        }
        return IvyPatternHelper.substituteTokens(pattern2, tokens2, false);
    }

    public static String substituteVariables(String pattern2, Map<String, String> variables) {
        return IvyPatternHelper.substituteVariables(pattern2, new IvyVariableContainerImpl(variables), new Stack<String>());
    }

    public static String substituteVariables(String pattern2, IvyVariableContainer variables) {
        return IvyPatternHelper.substituteVariables(pattern2, variables, new Stack<String>());
    }

    private static String substituteVariables(String pattern2, IvyVariableContainer variables, Stack<String> substituting) {
        if (pattern2 == null) {
            return null;
        }
        Matcher m2 = VAR_PATTERN.matcher(pattern2);
        boolean useVariables = false;
        StringBuffer sb = null;
        while (m2.find()) {
            String var;
            String val;
            if (!useVariables) {
                useVariables = true;
                sb = new StringBuffer();
            }
            if ((val = variables.getVariable(var = m2.group(1))) != null) {
                int index = substituting.indexOf(var);
                if (index != -1) {
                    ArrayList<String> cycle = new ArrayList<String>(substituting.subList(index, substituting.size()));
                    cycle.add(var);
                    throw new IllegalArgumentException("cyclic variable definition: cycle = " + cycle);
                }
                substituting.push(var);
                val = IvyPatternHelper.substituteVariables(val, variables, substituting);
                substituting.pop();
            } else {
                val = m2.group();
            }
            m2.appendReplacement(sb, val.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$"));
        }
        if (useVariables) {
            m2.appendTail(sb);
            return sb.toString();
        }
        return pattern2;
    }

    public static String substituteTokens(String pattern2, Map<String, String> tokens2) {
        HashMap<String, Object> tokensCopy = new HashMap<String, Object>();
        tokensCopy.putAll(tokens2);
        return IvyPatternHelper.substituteTokens(pattern2, tokensCopy, true);
    }

    private static String substituteTokens(String pattern2, Map<String, Object> tokens2, boolean external) {
        HashMap tokensCopy;
        HashMap hashMap = tokensCopy = external ? tokens2 : new HashMap(tokens2);
        if (tokensCopy.containsKey(ORGANISATION_KEY) && !tokensCopy.containsKey(ORGANISATION_KEY2)) {
            tokensCopy.put(ORGANISATION_KEY2, tokensCopy.get(ORGANISATION_KEY));
        }
        if (tokensCopy.containsKey(ORGANISATION_KEY) && !tokensCopy.containsKey(ORGANISATION_PATH_KEY)) {
            String org = (String)tokensCopy.get(ORGANISATION_KEY);
            tokensCopy.put(ORGANISATION_PATH_KEY, org == null ? "" : org.replace('.', '/'));
        }
        StringBuilder buffer2 = new StringBuilder();
        StringBuffer optionalPart = null;
        StringBuffer tokenBuffer = null;
        boolean insideOptionalPart = false;
        boolean insideToken = false;
        boolean tokenSeen = false;
        boolean tokenHadValue = false;
        block6: for (char ch : pattern2.toCharArray()) {
            int i = pattern2.indexOf(ch);
            switch (ch) {
                case '(': {
                    if (insideOptionalPart) {
                        throw new IllegalArgumentException("invalid start of optional part at position " + i + " in pattern " + pattern2);
                    }
                    optionalPart = new StringBuffer();
                    insideOptionalPart = true;
                    tokenSeen = false;
                    tokenHadValue = false;
                    continue block6;
                }
                case ')': {
                    if (!insideOptionalPart || insideToken) {
                        throw new IllegalArgumentException("invalid end of optional part at position " + i + " in pattern " + pattern2);
                    }
                    if (tokenHadValue) {
                        buffer2.append(optionalPart.toString());
                    } else if (!tokenSeen) {
                        buffer2.append('(').append(optionalPart.toString()).append(')');
                    }
                    insideOptionalPart = false;
                    continue block6;
                }
                case '[': {
                    if (insideToken) {
                        throw new IllegalArgumentException("invalid start of token at position " + i + " in pattern " + pattern2);
                    }
                    tokenBuffer = new StringBuffer();
                    insideToken = true;
                    continue block6;
                }
                case ']': {
                    String value2;
                    if (!insideToken) {
                        throw new IllegalArgumentException("invalid end of token at position " + i + " in pattern " + pattern2);
                    }
                    String token2 = tokenBuffer.toString();
                    Object tokenValue = tokensCopy.get(token2);
                    String string2 = value2 = tokenValue == null ? null : tokenValue.toString();
                    if (insideOptionalPart) {
                        tokenHadValue = !StringUtils.isNullOrEmpty(value2);
                        optionalPart.append(value2);
                    } else {
                        if (value2 == null) {
                            value2 = "[" + token2 + "]";
                        }
                        buffer2.append(value2);
                    }
                    insideToken = false;
                    tokenSeen = true;
                    continue block6;
                }
                default: {
                    if (insideToken) {
                        tokenBuffer.append(ch);
                        continue block6;
                    }
                    if (insideOptionalPart) {
                        optionalPart.append(ch);
                        continue block6;
                    }
                    buffer2.append(ch);
                }
            }
        }
        if (insideToken) {
            throw new IllegalArgumentException("last token hasn't been closed in pattern " + pattern2);
        }
        if (insideOptionalPart) {
            throw new IllegalArgumentException("optional part hasn't been closed in pattern " + pattern2);
        }
        return buffer2.toString();
    }

    public static String substituteVariable(String pattern2, String variable, String value2) {
        StringBuffer buf = new StringBuffer(pattern2);
        IvyPatternHelper.substituteVariable(buf, variable, value2);
        return buf.toString();
    }

    public static void substituteVariable(StringBuffer buf, String variable, String value2) {
        String from = "${" + variable + "}";
        int fromLength = from.length();
        int index = buf.indexOf(from);
        while (index != -1) {
            buf.replace(index, index + fromLength, value2);
            index = buf.indexOf(from, index);
        }
    }

    public static String substituteToken(String pattern2, String token2, String value2) {
        StringBuffer buf = new StringBuffer(pattern2);
        IvyPatternHelper.substituteToken(buf, token2, value2);
        return buf.toString();
    }

    public static void substituteToken(StringBuffer buf, String token2, String value2) {
        String from = IvyPatternHelper.getTokenString(token2);
        int fromLength = from.length();
        int index = buf.indexOf(from);
        while (index != -1) {
            buf.replace(index, index + fromLength, value2);
            index = buf.indexOf(from, index);
        }
    }

    public static String getTokenString(String token2) {
        return "[" + token2 + "]";
    }

    public static String substituteParams(String pattern2, Map<String, String> params) {
        return IvyPatternHelper.substituteParams(pattern2, new IvyVariableContainerImpl(params), new Stack<String>());
    }

    private static String substituteParams(String pattern2, IvyVariableContainer params, Stack<String> substituting) {
        if (pattern2 == null) {
            return null;
        }
        Matcher m2 = PARAM_PATTERN.matcher(pattern2);
        StringBuffer sb = new StringBuffer();
        while (m2.find()) {
            String var = m2.group(1);
            String val = params.getVariable(var);
            if (val != null) {
                int index = substituting.indexOf(var);
                if (index != -1) {
                    ArrayList<String> cycle = new ArrayList<String>(substituting.subList(index, substituting.size()));
                    cycle.add(var);
                    throw new IllegalArgumentException("cyclic param definition: cycle = " + cycle);
                }
                substituting.push(var);
                val = IvyPatternHelper.substituteVariables(val, params, substituting);
                substituting.pop();
            } else {
                val = m2.group();
            }
            m2.appendReplacement(sb, val.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\@", "\\\\\\@"));
        }
        m2.appendTail(sb);
        return sb.toString();
    }

    public static String getTokenRoot(String pattern2) {
        int index = pattern2.indexOf(91);
        if (index == -1) {
            return pattern2;
        }
        int optionalIndex = pattern2.indexOf(40);
        if (optionalIndex >= 0) {
            index = Math.min(index, optionalIndex);
        }
        return pattern2.substring(0, index);
    }

    public static String getFirstToken(String pattern2) {
        if (pattern2 == null) {
            return null;
        }
        int startIndex = pattern2.indexOf(91);
        if (startIndex == -1) {
            return null;
        }
        int endIndex = pattern2.indexOf(93, startIndex);
        if (endIndex == -1) {
            return null;
        }
        return pattern2.substring(startIndex + 1, endIndex);
    }

    private static class OriginalArtifactNameValue {
        private String org;
        private String moduleName;
        private String branch;
        private String revision;
        private Map<String, String> extraModuleAttributes;
        private String artifactName;
        private String artifactType;
        private String artifactExt;
        private Map<String, String> extraArtifactAttributes;
        private ArtifactOrigin origin;

        public OriginalArtifactNameValue(String org, String moduleName, String branch2, String revision, String artifactName, String artifactType, String artifactExt, Map<String, String> extraModuleAttributes, Map<String, String> extraArtifactAttributes) {
            this.org = org;
            this.moduleName = moduleName;
            this.branch = branch2;
            this.revision = revision;
            this.artifactName = artifactName;
            this.artifactType = artifactType;
            this.artifactExt = artifactExt;
            this.extraModuleAttributes = extraModuleAttributes;
            this.extraArtifactAttributes = extraArtifactAttributes;
        }

        public OriginalArtifactNameValue(ArtifactOrigin origin) {
            this.origin = origin;
        }

        public String toString() {
            if (this.origin == null) {
                ModuleRevisionId revId = ModuleRevisionId.newInstance(this.org, this.moduleName, this.branch, this.revision, this.extraModuleAttributes);
                DefaultArtifact artifact = new DefaultArtifact(revId, null, this.artifactName, this.artifactType, this.artifactExt, this.extraArtifactAttributes);
                RepositoryCacheManager cacheManager = IvyContext.getContext().getSettings().getResolver(revId).getRepositoryCacheManager();
                this.origin = cacheManager.getSavedArtifactOrigin(artifact);
                if (ArtifactOrigin.isUnknown(this.origin)) {
                    Message.debug("no artifact origin found for " + artifact + " in " + cacheManager);
                    return null;
                }
            }
            if (ArtifactOrigin.isUnknown(this.origin)) {
                return null;
            }
            String location2 = this.origin.getLocation();
            int lastPathIndex = location2.lastIndexOf(47);
            if (lastPathIndex == -1) {
                lastPathIndex = location2.lastIndexOf(92);
            }
            int lastColonIndex = location2.lastIndexOf(46);
            return location2.substring(lastPathIndex + 1, lastColonIndex);
        }
    }
}

