/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.search.SearchEngine;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.tools.ant.BuildException;

public class IvyListModules
extends IvyTask {
    private String organisation;
    private String module;
    private String branch = "*";
    private String revision;
    private String matcher = "exactOrRegexp";
    private String property;
    private String value;
    private String resolver;

    public String getMatcher() {
        return this.matcher;
    }

    public void setMatcher(String matcher2) {
        this.matcher = matcher2;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module2) {
        this.module = module2;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String name2) {
        this.property = name2;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value2) {
        this.value = value2;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch2) {
        this.branch = branch2;
    }

    public void setResolver(String resolver2) {
        this.resolver = resolver2;
    }

    public String getResolver() {
        return this.resolver;
    }

    @Override
    public void doExecute() throws BuildException {
        ModuleRevisionId[] mrids;
        if (this.organisation == null) {
            throw new BuildException("no organisation provided for ivy listmodules task");
        }
        if (this.module == null) {
            throw new BuildException("no module name provided for ivy listmodules task");
        }
        if (this.revision == null) {
            throw new BuildException("no revision provided for ivy listmodules task");
        }
        if (this.property == null) {
            throw new BuildException("no property provided for ivy listmodules task");
        }
        if (this.value == null) {
            throw new BuildException("no value provided for ivy listmodules task");
        }
        Ivy ivy = this.getIvyInstance();
        IvySettings settings2 = ivy.getSettings();
        SearchEngine searcher = new SearchEngine(settings2);
        PatternMatcher patternMatcher = settings2.getMatcher(this.matcher);
        if (this.resolver == null) {
            mrids = searcher.listModules(ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision), patternMatcher);
        } else {
            DependencyResolver depResolver = settings2.getResolver(this.resolver);
            if (depResolver == null) {
                throw new BuildException("Unknown resolver: " + this.resolver);
            }
            mrids = searcher.listModules(depResolver, ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision), patternMatcher);
        }
        for (ModuleRevisionId mrid : mrids) {
            String name2 = IvyPatternHelper.substitute(settings2.substitute(this.property), mrid);
            String value2 = IvyPatternHelper.substitute(settings2.substitute(this.value), mrid);
            this.getProject().setProperty(name2, value2);
        }
    }
}

