/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.TextMateFileType;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateElementType;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

public class TextMateBackspaceHandler
extends BackspaceHandlerDelegate {
    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            TextMateBackspaceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TextMateBackspaceHandler.$$$reportNull$$$0(1);
        }
    }

    public boolean charDeleted(char c, PsiFile file, @NotNull Editor editor) {
        if (editor == null) {
            TextMateBackspaceHandler.$$$reportNull$$$0(2);
        }
        if (file.getFileType() == TextMateFileType.INSTANCE) {
            char prevChar;
            Document document;
            TextMateScope scopeSelector;
            TextMateBracePair pairForChar;
            int offset = editor.getCaretModel().getOffset();
            EditorHighlighter highlighter = editor.getHighlighter();
            HighlighterIterator iterator = highlighter.createIterator(offset);
            if (offset == 0 && iterator.atEnd()) {
                return false;
            }
            IElementType tokenType = iterator.getTokenType();
            if (tokenType instanceof TextMateElementType && (pairForChar = TextMateEditorUtils.getSmartTypingPairForLeftChar(c, scopeSelector = ((TextMateElementType)tokenType).getScope())) != null && (document = editor.getDocument()).getTextLength() > offset && (prevChar = document.getCharsSequence().charAt(offset)) == pairForChar.rightChar) {
                document.deleteString(offset, offset + 1);
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/editor/TextMateBackspaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCharDeleted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "charDeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

