/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum BundleType {
    TEXTMATE("Syntaxes", "Preferences", "Snippets", "tmsnippet", "plist"),
    SUBLIME("", "", "", "sublime-snippet"),
    VSCODE("syntaxes", "", "snippets", "json"),
    UNDEFINED;

    private final String mySyntaxesPath;
    private final String myPreferencesPath;
    private final String mySnippetsPath;
    private final String[] mySnippetFileExtensions;

    private BundleType() {
        this("", "", "", new String[0]);
    }

    private BundleType(@NotNull String syntaxesPath, String preferencesPath, String snippetsPath, String ... snippetFileExtension) {
        if (syntaxesPath == null) {
            BundleType.$$$reportNull$$$0(0);
        }
        if (preferencesPath == null) {
            BundleType.$$$reportNull$$$0(1);
        }
        if (snippetsPath == null) {
            BundleType.$$$reportNull$$$0(2);
        }
        this.mySyntaxesPath = syntaxesPath;
        this.myPreferencesPath = preferencesPath;
        this.mySnippetsPath = snippetsPath;
        this.mySnippetFileExtensions = snippetFileExtension;
    }

    @NotNull
    String getPreferencesPath() {
        String string = this.myPreferencesPath;
        if (string == null) {
            BundleType.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    String getSyntaxesPath() {
        String string = this.mySyntaxesPath;
        if (string == null) {
            BundleType.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    String getSnippetsPath() {
        String string = this.mySnippetsPath;
        if (string == null) {
            BundleType.$$$reportNull$$$0(5);
        }
        return string;
    }

    String @NotNull [] getSnippetFileExtensions() {
        if (this.mySnippetFileExtensions == null) {
            BundleType.$$$reportNull$$$0(6);
        }
        return this.mySnippetFileExtensions;
    }

    @NotNull
    static BundleType fromDirectory(@Nullable File directory) {
        if (directory != null && directory.exists() && directory.isDirectory()) {
            if ("tmBundle".equalsIgnoreCase(FileUtilRt.getExtension((String)directory.getName()))) {
                BundleType bundleType = TEXTMATE;
                if (bundleType == null) {
                    BundleType.$$$reportNull$$$0(7);
                }
                return bundleType;
            }
            File packageJson = new File(directory, "package.json");
            if (packageJson.exists() && packageJson.isFile()) {
                BundleType bundleType = VSCODE;
                if (bundleType == null) {
                    BundleType.$$$reportNull$$$0(8);
                }
                return bundleType;
            }
            File infoPlist = new File(directory, "info.plist");
            boolean hasInfoPlistFile = infoPlist.exists() && infoPlist.isFile();
            File[] children = directory.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (hasInfoPlistFile && child.isDirectory() && "Syntaxes".equalsIgnoreCase(child.getName())) {
                        BundleType bundleType = TEXTMATE;
                        if (bundleType == null) {
                            BundleType.$$$reportNull$$$0(9);
                        }
                        return bundleType;
                    }
                    String fileExtension = FileUtilRt.getExtension((String)child.getName());
                    if (!"tmLanguage".equalsIgnoreCase(fileExtension) && !"tmPreferences".equalsIgnoreCase(fileExtension)) continue;
                    BundleType bundleType = SUBLIME;
                    if (bundleType == null) {
                        BundleType.$$$reportNull$$$0(10);
                    }
                    return bundleType;
                }
            }
            if (hasInfoPlistFile) {
                BundleType bundleType = TEXTMATE;
                if (bundleType == null) {
                    BundleType.$$$reportNull$$$0(11);
                }
                return bundleType;
            }
        }
        BundleType bundleType = UNDEFINED;
        if (bundleType == null) {
            BundleType.$$$reportNull$$$0(12);
        }
        return bundleType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxesPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferencesPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snippetsPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/bundles/BundleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/bundles/BundleType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferencesPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntaxesPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnippetsPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnippetFileExtensions";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

