/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PathsList {
    private final List<String> myPath = new ArrayList<String>();
    private final List<String> myPathTail = new ArrayList<String>();
    private final Set<String> myPathSet = new HashSet<String>();
    private static final Function<String, VirtualFile> PATH_TO_LOCAL_VFILE = path -> StandardFileSystems.local().findFileByPath(path.replace(File.separatorChar, '/'));
    private static final Function<VirtualFile, String> LOCAL_PATH = file2 -> PathUtil.getLocalPath(file2);
    private static final Function<String, VirtualFile> PATH_TO_DIR = s -> {
        VirtualFile file2 = (VirtualFile)PATH_TO_LOCAL_VFILE.fun(s);
        if (file2 == null) {
            return null;
        }
        if (!file2.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(file2.getNameSequence()) == ArchiveFileType.INSTANCE) {
            return StandardFileSystems.jar().findFileByPath(file2.getPath() + "!/");
        }
        return file2;
    };

    public boolean isEmpty() {
        return this.myPathSet.isEmpty();
    }

    public void add(String path) {
        this.addAllLast(this.chooseFirstTimeItems(path), this.myPath);
    }

    public void remove(@NotNull String path) {
        if (path == null) {
            PathsList.$$$reportNull$$$0(0);
        }
        this.myPath.remove(path);
        this.myPathTail.remove(path);
        this.myPathSet.remove(path);
    }

    public void clear() {
        this.myPath.clear();
        this.myPathTail.clear();
        this.myPathSet.clear();
    }

    public void add(VirtualFile file2) {
        String trimmed;
        String path = (String)LOCAL_PATH.fun((Object)file2);
        String string2 = trimmed = path != null ? path.trim() : "";
        if (!trimmed.isEmpty() && this.myPathSet.add(trimmed)) {
            this.myPath.add(trimmed);
        }
    }

    public void addFirst(String path) {
        int index = 0;
        for (String element : this.chooseFirstTimeItems(path)) {
            this.myPath.add(index, element);
            this.myPathSet.add(element);
            ++index;
        }
    }

    public void addTail(String path) {
        this.addAllLast(this.chooseFirstTimeItems(path), this.myPathTail);
    }

    private Iterable<String> chooseFirstTimeItems(String path) {
        if (path == null) {
            return Collections.emptyList();
        }
        return JBIterable.from(StringUtil.tokenize(path, File.pathSeparator)).filter((Condition<String>)((Condition)element -> !(element = element.trim()).isEmpty() && !this.myPathSet.contains(element)));
    }

    private void addAllLast(Iterable<String> elements, List<? super String> toArray) {
        for (String element : elements) {
            toArray.add(element);
            this.myPathSet.add(element);
        }
    }

    @NotNull
    public String getPathsString() {
        String string2 = StringUtil.join(this.getPathList(), File.pathSeparator);
        if (string2 == null) {
            PathsList.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public List<String> getPathList() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.myPath);
        result.addAll(this.myPathTail);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            PathsList.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public List<VirtualFile> getVirtualFiles() {
        return JBIterable.from(this.getPathList()).filterMap(PATH_TO_LOCAL_VFILE).toList();
    }

    public List<VirtualFile> getRootDirs() {
        return JBIterable.from(this.getPathList()).filterMap(PATH_TO_DIR).toList();
    }

    public void addAll(List<String> allClasspath) {
        for (String path : allClasspath) {
            this.add(path);
        }
    }

    public void addAllFiles(File[] files2) {
        this.addAllFiles(Arrays.asList(files2));
    }

    public void addAllFiles(List<? extends File> files2) {
        for (File file2 : files2) {
            this.add(file2);
        }
    }

    public void add(File file2) {
        this.add(FileUtil.toCanonicalPath(file2.getAbsolutePath()).replace('/', File.separatorChar));
    }

    public void addFirst(File file2) {
        this.addFirst(FileUtil.toCanonicalPath(file2.getAbsolutePath()).replace('/', File.separatorChar));
    }

    public void addVirtualFiles(Collection<? extends VirtualFile> files2) {
        for (VirtualFile virtualFile : files2) {
            this.add(virtualFile);
        }
    }

    public void addVirtualFiles(VirtualFile[] files2) {
        this.addVirtualFiles(Arrays.asList(files2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/PathsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/PathsList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

