/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.MathUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Registry {
    private static Reference<Map<String, String>> bundledRegistry;
    @NonNls
    public static final String REGISTRY_BUNDLE = "misc.registry";
    private static final RegistryValueListener EMPTY_VALUE_LISTENER;
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final Map<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private Map<String, RegistryKeyDescriptor> myContributedKeys = Collections.emptyMap();
    private static final Registry ourInstance;
    private volatile boolean isLoaded;
    @NotNull
    private volatile RegistryValueListener valueChangeListener = EMPTY_VALUE_LISTENER;

    @NotNull
    public static RegistryValue get(@NonNls @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(0);
        }
        return Registry.getInstance().doGet(key);
    }

    @ApiStatus.Internal
    @NotNull
    public static RegistryValue _getWithoutStateCheck(@NonNls @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(1);
        }
        return ourInstance.doGet(key);
    }

    @NotNull
    private RegistryValue doGet(@NonNls @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(2);
        }
        RegistryValue registryValue = this.myValues.computeIfAbsent(key, s -> new RegistryValue(this, (String)s, this.myContributedKeys.get(s)));
        if (registryValue == null) {
            Registry.$$$reportNull$$$0(3);
        }
        return registryValue;
    }

    public static boolean is(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(4);
        }
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@NonNls @NotNull String key, boolean defaultValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(5);
        }
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            LoadingState.BASE_LAF_INITIALIZED.checkOccurred();
            return defaultValue;
        }
        try {
            return Registry.getInstance().doGet(key).asBoolean();
        }
        catch (MissingResourceException ignore) {
            return defaultValue;
        }
    }

    public static int intValue(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(6);
        }
        return Registry.getInstance().doGet(key).asInteger();
    }

    public static int intValue(@NonNls @NotNull String key, int defaultValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(7);
        }
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            LoadingState.BASE_LAF_INITIALIZED.checkOccurred();
            return defaultValue;
        }
        try {
            return Registry.getInstance().doGet(key).asInteger();
        }
        catch (MissingResourceException ignore) {
            return defaultValue;
        }
    }

    public static int intValue(@NonNls @NotNull String key, int defaultValue, int minValue, int maxValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(8);
        }
        if (defaultValue < minValue || defaultValue > maxValue) {
            throw new IllegalArgumentException("Wrong values for default:min:max (" + defaultValue + ":" + minValue + ":" + maxValue + ")");
        }
        return MathUtil.clamp(Registry.intValue(key, defaultValue), minValue, maxValue);
    }

    public static double doubleValue(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(9);
        }
        return Registry.get(key).asDouble();
    }

    @NotNull
    public static String stringValue(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(10);
        }
        String string2 = Registry.get(key).asString();
        if (string2 == null) {
            Registry.$$$reportNull$$$0(11);
        }
        return string2;
    }

    public static Color getColor(@NonNls @NotNull String key, Color defaultValue) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(12);
        }
        return Registry.get(key).asColor(defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Map<String, String> loadFromBundledConfig() throws IOException {
        Map<String, String> result;
        Reference<Map<String, String>> bundleRef = bundledRegistry;
        Map<String, String> map = result = bundleRef == null ? null : bundleRef.get();
        if (result != null) {
            return result;
        }
        InputStream stream = Registry.class.getClassLoader().getResourceAsStream("misc/registry.properties");
        if (stream == null) {
            return null;
        }
        final HashMap<String, String> map2 = new HashMap<String, String>(1800);
        try {
            new Properties(){

                @Override
                public Object put(Object key, Object value) {
                    return map2.put((String)key, (String)value);
                }
            }.load(stream);
        }
        finally {
            stream.close();
        }
        bundledRegistry = new SoftReference(map2);
        return map2;
    }

    @NlsSafe
    @Nullable
    public String getBundleValueOrNull(@NonNls @NotNull String key) {
        RegistryKeyDescriptor contributed;
        if (key == null) {
            Registry.$$$reportNull$$$0(13);
        }
        if ((contributed = this.myContributedKeys.get(key)) != null) {
            return contributed.getDefaultValue();
        }
        try {
            Map<String, String> bundle = Registry.loadFromBundledConfig();
            return bundle == null ? null : bundle.get(key);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NlsSafe
    @NotNull
    String getBundleValue(@NonNls @NotNull String key) throws MissingResourceException {
        RegistryKeyDescriptor contributed;
        if (key == null) {
            Registry.$$$reportNull$$$0(14);
        }
        if ((contributed = this.myContributedKeys.get(key)) != null) {
            String string2 = contributed.getDefaultValue();
            if (string2 == null) {
                Registry.$$$reportNull$$$0(15);
            }
            return string2;
        }
        String result = this.getBundleValueOrNull(key);
        if (result == null) {
            throw new MissingResourceException("Registry key " + key + " is not defined", REGISTRY_BUNDLE, key);
        }
        String string3 = result;
        if (string3 == null) {
            Registry.$$$reportNull$$$0(16);
        }
        return string3;
    }

    @NotNull
    public static Registry getInstance() {
        LoadingState.COMPONENTS_LOADED.checkOccurred();
        Registry registry = ourInstance;
        if (registry == null) {
            Registry.$$$reportNull$$$0(17);
        }
        return registry;
    }

    @NotNull
    public Element getState() {
        Element state = new Element("registry");
        for (Map.Entry<String, String> entry : this.myUserProperties.entrySet()) {
            Element entryElement = new Element("entry");
            entryElement.setAttribute("key", entry.getKey());
            entryElement.setAttribute("value", entry.getValue());
            state.addContent(entryElement);
        }
        Element element = state;
        if (element == null) {
            Registry.$$$reportNull$$$0(18);
        }
        return element;
    }

    @ApiStatus.Internal
    @Nullable
    public static Map<String, String> loadState(@Nullable Element state) {
        Registry registry = ourInstance;
        if (state == null) {
            registry.isLoaded = true;
            return null;
        }
        registry.myUserProperties.clear();
        for (Element eachEntry : state.getChildren("entry")) {
            RegistryValue registryValue;
            String key = eachEntry.getAttributeValue("key");
            String value = eachEntry.getAttributeValue("value");
            if (key == null || value == null || !(registryValue = registry.doGet(key)).isChangedFromDefault(value, registry)) continue;
            registry.myUserProperties.put(key, value);
            registryValue.resetCache();
        }
        registry.isLoaded = true;
        return registry.myUserProperties;
    }

    @ApiStatus.Internal
    public static void markAsLoaded() {
        Registry.ourInstance.isLoaded = true;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    @NotNull
    Map<String, String> getUserProperties() {
        Map<String, String> map = this.myUserProperties;
        if (map == null) {
            Registry.$$$reportNull$$$0(19);
        }
        return map;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<RegistryValue> getAll() {
        Map<String, String> bundle = null;
        try {
            bundle = Registry.loadFromBundledConfig();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Set<Object> keys = bundle == null ? Collections.emptySet() : bundle.keySet();
        ArrayList<RegistryValue> result = new ArrayList<RegistryValue>();
        Registry instance = ourInstance;
        Map<String, RegistryKeyDescriptor> contributedKeys = instance.myContributedKeys;
        for (String string2 : keys) {
            if (string2.endsWith(".description") || string2.endsWith(".restartRequired") || contributedKeys.containsKey(string2)) continue;
            result.add(instance.doGet(string2));
        }
        for (String string3 : contributedKeys.keySet()) {
            result.add(instance.doGet(string3));
        }
        ArrayList<RegistryValue> arrayList = result;
        if (arrayList == null) {
            Registry.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    void restoreDefaults() {
        HashMap<String, String> old = new HashMap<String, String>(this.myUserProperties);
        Registry instance = Registry.getInstance();
        for (String key : old.keySet()) {
            String v = instance.getBundleValueOrNull(key);
            if (v == null) {
                this.myValues.remove(key);
                continue;
            }
            RegistryValue value = instance.myValues.get(key);
            if (value == null) continue;
            value.setValue(v);
        }
    }

    boolean isInDefaultState() {
        return this.myUserProperties.isEmpty();
    }

    public boolean isRestartNeeded() {
        return Registry.isRestartNeeded(this.myUserProperties);
    }

    private static boolean isRestartNeeded(@NotNull Map<String, String> map) {
        if (map == null) {
            Registry.$$$reportNull$$$0(21);
        }
        Registry instance = Registry.getInstance();
        for (String s : map.keySet()) {
            RegistryValue eachValue = instance.doGet(s);
            if (!eachValue.isRestartRequired() || !eachValue.isChangedSinceAppStart()) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static synchronized void setKeys(@NotNull Map<String, RegistryKeyDescriptor> descriptors) {
        if (descriptors == null) {
            Registry.$$$reportNull$$$0(22);
        }
        Registry.ourInstance.myContributedKeys = descriptors;
    }

    @ApiStatus.Internal
    public static synchronized void mutateContributedKeys(@NotNull Function<? super Map<String, RegistryKeyDescriptor>, ? extends Map<String, RegistryKeyDescriptor>> mutator) {
        if (mutator == null) {
            Registry.$$$reportNull$$$0(23);
        }
        Registry.ourInstance.myContributedKeys = mutator.apply(Registry.ourInstance.myContributedKeys);
    }

    @ApiStatus.Internal
    public static void setValueChangeListener(@Nullable RegistryValueListener listener) {
        Registry.ourInstance.valueChangeListener = listener == null ? EMPTY_VALUE_LISTENER : listener;
    }

    @NotNull
    RegistryValueListener getValueChangeListener() {
        RegistryValueListener registryValueListener = this.valueChangeListener;
        if (registryValueListener == null) {
            Registry.$$$reportNull$$$0(24);
        }
        return registryValueListener;
    }

    static {
        EMPTY_VALUE_LISTENER = new RegistryValueListener(){};
        ourInstance = new Registry();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGet";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "stringValue";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleValue";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserProperties";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAll";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueChangeListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_getWithoutStateCheck";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doGet";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "intValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doubleValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "stringValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBundleValueOrNull";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getBundleValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isRestartNeeded";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setKeys";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "mutateContributedKeys";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

