/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.kpmsearch;

import com.fasterxml.jackson.jr.ob.JSON;
import com.intellij.application.options.RegistryManager;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.SameThreadExecutor;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.kpmsearch.PackageSearchEndpointConfig;

@Service(value={Service.Level.APP})
public final class DefaultPackageServiceConfig
implements PackageSearchEndpointConfig {
    private static final long INFO_TTL = TimeUnit.DAYS.toMillis(7L);
    private static final String CONFIG_URL_KEY_PREFIX = DefaultPackageServiceConfig.class.getSimpleName().toLowerCase(Locale.ENGLISH) + ".";
    private static final String CONFIG_UPDATED_TIMESTAMP_KEY = CONFIG_URL_KEY_PREFIX + "updated.ts";
    @NotNull
    private volatile PackageSearchEndpointUrls packageSearchEndpointUrls = new PackageSearchEndpointUrls(null, null);

    private DefaultPackageServiceConfig() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && RegistryManager.getInstance().is("maven.packagesearch.enabled")) {
            this.updateIfNecessary();
        }
    }

    private CompletableFuture<PackageSearchEndpointUrls> reloadConfig() {
        boolean isDispatchThreadOrReadAction = ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isReadAccessAllowed();
        return CompletableFuture.supplyAsync(() -> {
            Map config;
            try {
                config = (Map)HttpRequests.request((String)Objects.requireNonNull(RegistryManager.getInstance().stringValue("packagesearch.config.url"))).userAgent(this.getUserAgent()).forceHttps(true).connect(request -> JSON.std.mapFrom((Object)request.getReader()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            Object idea = config.get("idea");
            if (!(idea instanceof Map)) {
                return new PackageSearchEndpointUrls(null, null);
            }
            Map o = (Map)idea;
            String fulltextUrl = DefaultPackageServiceConfig.extract("fulltext", o);
            String suggestUrl = DefaultPackageServiceConfig.extract("suggest", o);
            return new PackageSearchEndpointUrls(fulltextUrl, suggestUrl);
        }, isDispatchThreadOrReadAction ? ProcessIOExecutorService.INSTANCE : SameThreadExecutor.INSTANCE);
    }

    @Override
    public String getFullTextUrl() {
        return this.packageSearchEndpointUrls.fulltextUrl;
    }

    @Override
    public String getSuggestUrl() {
        return this.packageSearchEndpointUrls.suggestUrl;
    }

    @Override
    public int getReadTimeout() {
        return Registry.intValue((String)"packagesearch.timeout");
    }

    @Override
    public int getConnectTimeout() {
        return this.getReadTimeout();
    }

    private static String extract(String fulltext, Map<String, Object> idea) {
        Object url;
        Object urlMap = idea.get(fulltext);
        if (urlMap instanceof Map && Boolean.parseBoolean(String.valueOf(((Map)urlMap).get("enabled"))) && (url = ((Map)urlMap).get("url")) instanceof String) {
            return url.toString();
        }
        return null;
    }

    private void updateIfNecessary() {
        PropertiesComponent persistentCache = PropertiesComponent.getInstance();
        long updatedTimestamp = persistentCache.getLong(CONFIG_UPDATED_TIMESTAMP_KEY, 0L);
        if (System.currentTimeMillis() - updatedTimestamp > INFO_TTL) {
            this.reloadConfig().thenAccept(result -> {
                persistentCache.setValue(CONFIG_UPDATED_TIMESTAMP_KEY, String.valueOf(System.currentTimeMillis()));
                persistentCache.setValue(CONFIG_URL_KEY_PREFIX + "fulltext", result.fulltextUrl);
                persistentCache.setValue(CONFIG_URL_KEY_PREFIX + "suggest", result.suggestUrl);
                this.packageSearchEndpointUrls = result;
            });
        } else {
            this.packageSearchEndpointUrls = new PackageSearchEndpointUrls(persistentCache.getValue(CONFIG_URL_KEY_PREFIX + "fulltext"), persistentCache.getValue(CONFIG_URL_KEY_PREFIX + "suggest"));
        }
    }

    static final class PackageSearchEndpointUrls {
        final String fulltextUrl;
        final String suggestUrl;

        PackageSearchEndpointUrls(@Nullable String fulltextUrl, @Nullable String suggestUrl) {
            this.fulltextUrl = fulltextUrl;
            this.suggestUrl = suggestUrl;
        }
    }
}

