/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectUtils;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.server.Maven3ServerGlobals;
import org.jetbrains.idea.maven.server.MavenModelConverter;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator2;
import org.jetbrains.idea.maven.server.embedder.MavenExecutionResult;
import org.jetbrains.idea.maven.server.security.MavenToken;

public abstract class Maven3ServerEmbedder
extends MavenRemoteObject
implements MavenServerEmbedder {
    public static final boolean USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING = System.getProperty("idea.maven3.use.compat.resolver") != null;
    private static final String MAVEN_VERSION = System.getProperty("idea.maven.embedder.version");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\"-D([\\S&&[^=]]+)(?:=([^\"]+))?\"|-D([\\S&&[^=]]+)(?:=(\\S+))?");
    protected final MavenServerSettings myServerSettings;

    protected Maven3ServerEmbedder(MavenServerSettings settings) {
        this.myServerSettings = settings;
        Maven3ServerEmbedder.initLogging(this.myServerSettings);
    }

    private static void initLogging(MavenServerSettings settings) {
        try {
            Level rootLoggerLevel = Maven3ServerEmbedder.toJavaUtilLoggingLevel(settings.getLoggingLevel());
            Logger.getLogger("").setLevel(rootLoggerLevel);
            if (rootLoggerLevel.intValue() < Level.SEVERE.intValue()) {
                Logger.getLogger("org.apache.maven.wagon.providers.http.httpclient.wire").setLevel(Level.SEVERE);
                Logger.getLogger("org.apache.http.wire").setLevel(Level.SEVERE);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Level toJavaUtilLoggingLevel(int level) {
        switch (level) {
            case 0: {
                return Level.ALL;
            }
            case 3: {
                return Level.SEVERE;
            }
            case 4: {
                return Level.SEVERE;
            }
            case 5: {
                return Level.OFF;
            }
            case 1: {
                return Level.INFO;
            }
            case 2: {
                return Level.WARNING;
            }
        }
        return Level.INFO;
    }

    protected abstract ArtifactRepository getLocalRepository();

    @NotNull
    public List<String> retrieveAvailableVersions(@NotNull String groupId, @NotNull String artifactId, @NotNull List<MavenRemoteRepository> remoteRepositories, MavenToken token) throws RemoteException {
        List list;
        if (groupId == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(1);
        }
        if (remoteRepositories == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(2);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, "", "compile", "pom", null, (ArtifactHandler)new DefaultArtifactHandler("pom"));
            List versions = this.getComponent(ArtifactMetadataSource.class).retrieveAvailableVersions((Artifact)artifact, this.getLocalRepository(), this.convertRepositories(remoteRepositories));
            list = ContainerUtilRt.map2List((Collection)versions, version -> version.toString());
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().info(e);
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                Maven3ServerEmbedder.$$$reportNull$$$0(4);
            }
            return list2;
        }
        if (list == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(3);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected List<ProjectBuildingResult> getProjectBuildingResults(@NotNull MavenExecutionRequest request, @NotNull Collection<File> files) {
        List<Object> buildingResults;
        block13: {
            if (request == null) {
                Maven3ServerEmbedder.$$$reportNull$$$0(5);
            }
            if (files == null) {
                Maven3ServerEmbedder.$$$reportNull$$$0(6);
            }
            ProjectBuilder builder = this.getComponent(ProjectBuilder.class);
            ModelInterpolator modelInterpolator = this.getComponent(ModelInterpolator.class);
            String savedLocalRepository = null;
            if (modelInterpolator instanceof CustomMaven3ModelInterpolator2) {
                CustomMaven3ModelInterpolator2 customMaven3ModelInterpolator2 = (CustomMaven3ModelInterpolator2)modelInterpolator;
                savedLocalRepository = customMaven3ModelInterpolator2.getLocalRepository();
                customMaven3ModelInterpolator2.setLocalRepository(request.getLocalRepositoryPath().getAbsolutePath());
            }
            buildingResults = new ArrayList<ProjectBuildingResult>();
            ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
            projectBuildingRequest.setValidationLevel(0);
            projectBuildingRequest.setResolveDependencies(false);
            try {
                if (files.size() == 1) {
                    this.buildSinglePom(builder, buildingResults, projectBuildingRequest, files.iterator().next());
                    break block13;
                }
                try {
                    buildingResults = builder.build(new ArrayList<File>(files), false, projectBuildingRequest);
                }
                catch (ProjectBuildingException e) {
                    for (ProjectBuildingResult result : e.getResults()) {
                        if (result.getProject() != null) {
                            buildingResults.add(result);
                            continue;
                        }
                        this.buildSinglePom(builder, buildingResults, projectBuildingRequest, result.getPomFile());
                    }
                }
            }
            finally {
                if (modelInterpolator instanceof CustomMaven3ModelInterpolator2 && savedLocalRepository != null) {
                    ((CustomMaven3ModelInterpolator2)modelInterpolator).setLocalRepository(savedLocalRepository);
                }
            }
        }
        List<Object> list = buildingResults;
        if (list == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(7);
        }
        return list;
    }

    private void buildSinglePom(ProjectBuilder builder, List<ProjectBuildingResult> buildingResults, ProjectBuildingRequest projectBuildingRequest, File pomFile) {
        try {
            ProjectBuildingResult build = builder.build(pomFile, projectBuildingRequest);
            buildingResults.add(build);
        }
        catch (ProjectBuildingException e) {
            this.handleProjectBuildingException(buildingResults, e);
        }
    }

    protected void handleProjectBuildingException(List<ProjectBuildingResult> buildingResults, ProjectBuildingException e) {
        List results = e.getResults();
        if (results != null && !results.isEmpty()) {
            buildingResults.addAll(results);
        } else {
            Throwable cause = e.getCause();
            List problems = null;
            if (cause instanceof ModelBuildingException) {
                problems = ((ModelBuildingException)cause).getProblems();
            }
            buildingResults.add(new MyProjectBuildingResult(null, e.getPomFile(), null, problems, null));
        }
    }

    protected void addMvn2CompatResults(MavenProject project, List<Exception> exceptions, List<ResolutionListener> listeners, ArtifactRepository localRepository, Collection<MavenExecutionResult> executionResults) {
        ArtifactResolutionRequest resolutionRequest = new ArtifactResolutionRequest();
        resolutionRequest.setArtifactDependencies(project.getDependencyArtifacts());
        resolutionRequest.setArtifact(project.getArtifact());
        resolutionRequest.setManagedVersionMap(project.getManagedVersionMap());
        resolutionRequest.setLocalRepository(localRepository);
        resolutionRequest.setRemoteRepositories(project.getRemoteArtifactRepositories());
        resolutionRequest.setListeners(listeners);
        resolutionRequest.setResolveRoot(false);
        resolutionRequest.setResolveTransitively(true);
        ArtifactResolver resolver = this.getComponent(ArtifactResolver.class);
        ArtifactResolutionResult result = resolver.resolve(resolutionRequest);
        project.setArtifacts(result.getArtifacts());
        executionResults.add(new MavenExecutionResult(project, exceptions));
    }

    @Nullable
    public MavenModel readModel(File file, MavenToken token) throws RemoteException {
        MavenServerUtil.checkToken((MavenToken)token);
        return null;
    }

    public static Map<String, String> getMavenAndJvmConfigProperties(File workingDir) {
        if (workingDir == null) {
            return Collections.emptyMap();
        }
        File baseDir = MavenServerUtil.findMavenBasedir((File)workingDir);
        HashMap<String, String> result = new HashMap<String, String>();
        Maven3ServerEmbedder.readConfigFiles(baseDir, result);
        return result.isEmpty() ? Collections.emptyMap() : result;
    }

    static void readConfigFiles(File baseDir, Map<String, String> result) {
        Maven3ServerEmbedder.readConfigFile(baseDir, File.separator + ".mvn" + File.separator + "jvm.config", result, "");
        Maven3ServerEmbedder.readConfigFile(baseDir, File.separator + ".mvn" + File.separator + "maven.config", result, "true");
    }

    private static void readConfigFile(File baseDir, String relativePath, Map<String, String> result, String valueIfMissing) {
        File configFile = new File(baseDir, relativePath);
        if (configFile.exists() && configFile.isFile()) {
            try {
                String text = FileUtilRt.loadFile((File)configFile, (String)"UTF-8");
                Matcher matcher = PROPERTY_PATTERN.matcher(text);
                while (matcher.find()) {
                    if (matcher.group(1) != null) {
                        result.put(matcher.group(1), StringUtilRt.notNullize((String)matcher.group(2), (String)valueIfMissing));
                        continue;
                    }
                    result.put(matcher.group(3), StringUtilRt.notNullize((String)matcher.group(4), (String)valueIfMissing));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @NotNull
    protected abstract List<ArtifactRepository> convertRepositories(List<MavenRemoteRepository> var1) throws RemoteException;

    @NotNull
    protected List<ArtifactRepository> map2ArtifactRepositories(List<MavenRemoteRepository> repositories) throws RemoteException {
        PlexusContainer container = this.getContainer();
        ArrayList<ArtifactRepository> result = new ArrayList<ArtifactRepository>();
        for (MavenRemoteRepository each : repositories) {
            try {
                ArtifactRepositoryFactory factory = this.getComponent(ArtifactRepositoryFactory.class);
                result.add(ProjectUtils.buildArtifactRepository((Repository)MavenModelConverter.toNativeRepository(each), (ArtifactRepositoryFactory)factory, (PlexusContainer)container));
            }
            catch (InvalidRepositoryException e) {
                Maven3ServerGlobals.getLogger().warn(e);
            }
        }
        ArrayList<ArtifactRepository> arrayList = result;
        if (arrayList == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    public String getMavenVersion() {
        return MAVEN_VERSION;
    }

    public abstract <T> T getComponent(Class<T> var1, String var2);

    public abstract <T> T getComponent(Class<T> var1);

    protected void executeWithMavenSession(MavenExecutionRequest request, final Runnable runnable) throws RemoteException {
        this.executeWithMavenSession(request, new RunnableThrownRemote(){

            @Override
            public void run() throws RemoteException {
                runnable.run();
            }
        });
    }

    protected void executeWithMavenSession(MavenExecutionRequest request, RunnableThrownRemote runnable) throws RemoteException {
        if (VersionComparatorUtil.compare((String)this.getMavenVersion(), (String)"3.2.5") >= 0) {
            this.executeWithSessionScope(request, runnable);
        } else {
            this.executeWithMavenSessionLegacy(request, runnable);
        }
    }

    protected void executeWithMavenSessionLegacy(MavenExecutionRequest request, final Runnable runnable) throws RemoteException {
        this.executeWithMavenSessionLegacy(request, new RunnableThrownRemote(){

            @Override
            public void run() throws RemoteException {
                runnable.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeWithMavenSessionLegacy(MavenExecutionRequest request, RunnableThrownRemote runnable) throws RemoteException {
        DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
        MavenSession mavenSession = this.createMavenSession(request, maven);
        LegacySupport legacySupport = this.getComponent(LegacySupport.class);
        MavenSession oldSession = legacySupport.getSession();
        legacySupport.setSession(mavenSession);
        this.notifyAfterSessionStart(mavenSession);
        try {
            runnable.run();
        }
        finally {
            legacySupport.setSession(oldSession);
        }
    }

    @NotNull
    private MavenSession createMavenSession(MavenExecutionRequest request, DefaultMaven maven) {
        RepositorySystemSession repositorySession = maven.newRepositorySession(request);
        request.getProjectBuildingRequest().setRepositorySession(repositorySession);
        return new MavenSession(this.getContainer(), repositorySession, request, (org.apache.maven.execution.MavenExecutionResult)new DefaultMavenExecutionResult());
    }

    private void notifyAfterSessionStart(MavenSession mavenSession) {
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(Collections.emptyList())) {
                listener.afterSessionStart(mavenSession);
            }
        }
        catch (MavenExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeWithSessionScope(MavenExecutionRequest request, RunnableThrownRemote runnable) throws RemoteException {
        DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
        SessionScope sessionScope = this.getComponent(SessionScope.class);
        sessionScope.enter();
        try {
            MavenSession mavenSession = this.createMavenSession(request, maven);
            sessionScope.seed(MavenSession.class, (Object)mavenSession);
            LegacySupport legacySupport = this.getComponent(LegacySupport.class);
            MavenSession oldSession = legacySupport.getSession();
            legacySupport.setSession(mavenSession);
            this.notifyAfterSessionStart(mavenSession);
            try {
                runnable.run();
            }
            finally {
                legacySupport.setSession(oldSession);
            }
        }
        finally {
            sessionScope.exit();
        }
    }

    @NotNull
    protected abstract PlexusContainer getContainer();

    public abstract MavenExecutionRequest createRequest(File var1, List<String> var2, List<String> var3, List<String> var4) throws RemoteException;

    protected static void warn(String message, Throwable e) {
        try {
            Maven3ServerGlobals.getLogger().warn(new RuntimeException(message, e));
        }
        catch (RemoteException e1) {
            throw new RuntimeException(e1);
        }
    }

    public Set<MavenRemoteRepository> resolveRepositories(@NotNull Collection<MavenRemoteRepository> repositories, MavenToken token) throws RemoteException {
        if (repositories == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(9);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        return new HashSet<MavenRemoteRepository>(MavenModelConverter.convertRemoteRepositories(this.convertRepositories(new ArrayList<MavenRemoteRepository>(repositories))));
    }

    public Collection<MavenArchetype> getArchetypes(MavenToken token) throws RemoteException {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            ArchetypeDataSource source = this.getComponent(ArchetypeDataSource.class, "internal-catalog");
            ArchetypeCatalog archetypeCatalog = source.getArchetypeCatalog(new Properties());
            return Maven3ServerEmbedder.getArchetypes(archetypeCatalog);
        }
        catch (ArchetypeDataSourceException e) {
            Maven3ServerGlobals.getLogger().warn(e);
            return Collections.emptyList();
        }
    }

    public Collection<MavenArchetype> getLocalArchetypes(MavenToken token, @NotNull String path) throws RemoteException {
        if (path == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(10);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            ArchetypeDataSource source = this.getComponent(ArchetypeDataSource.class, "catalog");
            Properties properties = new Properties();
            properties.put("file", path);
            ArchetypeCatalog archetypeCatalog = source.getArchetypeCatalog(properties);
            return Maven3ServerEmbedder.getArchetypes(archetypeCatalog);
        }
        catch (ArchetypeDataSourceException e) {
            Maven3ServerGlobals.getLogger().warn(e);
            return Collections.emptyList();
        }
    }

    public Collection<MavenArchetype> getRemoteArchetypes(MavenToken token, @NotNull String url) throws RemoteException {
        if (url == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(11);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            ArchetypeDataSource source = this.getComponent(ArchetypeDataSource.class, "remote-catalog");
            Properties properties = new Properties();
            properties.put("repository", url);
            ArchetypeCatalog archetypeCatalog = source.getArchetypeCatalog(properties);
            return Maven3ServerEmbedder.getArchetypes(archetypeCatalog);
        }
        catch (ArchetypeDataSourceException e) {
            Maven3ServerGlobals.getLogger().warn(e);
            return Collections.emptyList();
        }
    }

    @Nullable
    public Map<String, String> resolveAndGetArchetypeDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull List<MavenRemoteRepository> repositories, @Nullable String url, MavenToken token) throws RemoteException {
        if (groupId == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(12);
        }
        if (artifactId == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(13);
        }
        if (version == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(14);
        }
        if (repositories == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(15);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        MavenExecutionRequest request = this.createRequest(null, null, null, null);
        List<ArtifactRepository> artifactRepositories = this.map2ArtifactRepositories(repositories);
        for (ArtifactRepository repository : artifactRepositories) {
            request.addRemoteRepository(repository);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        AtomicBoolean unknownArchetypeError = new AtomicBoolean(false);
        this.executeWithMavenSession(request, () -> {
            MavenArtifactRepository artifactRepository = null;
            if (url != null) {
                artifactRepository = new MavenArtifactRepository();
                artifactRepository.setId("archetype");
                artifactRepository.setUrl(url);
                artifactRepository.setLayout((ArtifactRepositoryLayout)new DefaultRepositoryLayout());
            }
            List remoteRepositories = request.getRemoteRepositories();
            ArchetypeArtifactManager archetypeArtifactManager = this.getComponent(ArchetypeArtifactManager.class);
            ArchetypeDescriptor descriptor = null;
            try {
                descriptor = archetypeArtifactManager.getFileSetArchetypeDescriptor(groupId, artifactId, version, (ArtifactRepository)artifactRepository, this.getLocalRepository(), remoteRepositories);
            }
            catch (UnknownArchetype e) {
                unknownArchetypeError.set(true);
            }
            if (descriptor != null && descriptor.getRequiredProperties() != null) {
                for (RequiredProperty property : descriptor.getRequiredProperties()) {
                    result.put(property.getKey(), property.getDefaultValue() != null ? property.getDefaultValue() : "");
                }
            }
        });
        return unknownArchetypeError.get() ? null : result;
    }

    @NotNull
    private static ArrayList<MavenArchetype> getArchetypes(ArchetypeCatalog archetypeCatalog) {
        ArrayList<MavenArchetype> result = new ArrayList<MavenArchetype>(archetypeCatalog.getArchetypes().size());
        for (Archetype each : archetypeCatalog.getArchetypes()) {
            result.add(MavenModelConverter.convertArchetype(each));
        }
        ArrayList<MavenArchetype> arrayList = result;
        if (arrayList == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractMavenLifecycleParticipant> getLifecycleParticipants(Collection<MavenProject> projects) {
        LinkedHashSet<AbstractMavenLifecycleParticipant> lifecycleListeners = new LinkedHashSet<AbstractMavenLifecycleParticipant>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                lifecycleListeners.addAll(this.getContainer().lookupList(AbstractMavenLifecycleParticipant.class));
            }
            catch (ComponentLookupException e) {
                Maven3ServerEmbedder.warn("Failed to lookup lifecycle participants", e);
            }
            HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                try {
                    lifecycleListeners.addAll(this.getContainer().lookupList(AbstractMavenLifecycleParticipant.class));
                }
                catch (ComponentLookupException e) {
                    Maven3ServerEmbedder.warn("Failed to lookup lifecycle participants", e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return lifecycleListeners;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositories";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/Maven3ServerEmbedder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/Maven3ServerEmbedder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveAvailableVersions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectBuildingResults";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "map2ArtifactRepositories";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchetypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "retrieveAvailableVersions";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProjectBuildingResults";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveRepositories";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocalArchetypes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteArchetypes";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndGetArchetypeDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyProjectBuildingResult
    implements ProjectBuildingResult {
        private final String myProjectId;
        private final File myPomFile;
        private final MavenProject myMavenProject;
        private final List<ModelProblem> myProblems;
        private final DependencyResolutionResult myDependencyResolutionResult;

        MyProjectBuildingResult(String projectId, File pomFile, MavenProject mavenProject, List<ModelProblem> problems, DependencyResolutionResult dependencyResolutionResult) {
            this.myProjectId = projectId;
            this.myPomFile = pomFile;
            this.myMavenProject = mavenProject;
            this.myProblems = problems;
            this.myDependencyResolutionResult = dependencyResolutionResult;
        }

        public String getProjectId() {
            return this.myProjectId;
        }

        public File getPomFile() {
            return this.myPomFile;
        }

        public MavenProject getProject() {
            return this.myMavenProject;
        }

        public List<ModelProblem> getProblems() {
            return this.myProblems;
        }

        public DependencyResolutionResult getDependencyResolutionResult() {
            return this.myDependencyResolutionResult;
        }
    }

    public static interface RunnableThrownRemote {
        public void run() throws RemoteException;
    }
}

