/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references.extensions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.documentation.DocumentationMarkup;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.references.extensions.ExtensionPointBinding;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class ExtensionPointDocumentationProvider
implements DocumentationProvider {
    @Nls
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        ExtensionPoint extensionPoint = ExtensionPointDocumentationProvider.findExtensionPoint(element);
        if (extensionPoint == null) {
            return null;
        }
        XmlFile epDeclarationFile = DomUtil.getFile((DomElement)extensionPoint);
        Module epModule = ModuleUtilCore.findModuleForFile((VirtualFile)epDeclarationFile.getVirtualFile(), (Project)element.getProject());
        HtmlBuilder builder2 = new HtmlBuilder();
        if (epModule != null) {
            builder2.append("[" + epModule.getName() + "]").br();
        }
        builder2.append((HtmlChunk)HtmlChunk.text((String)extensionPoint.getEffectiveQualifiedName()).bold());
        builder2.append(" ");
        builder2.append("(" + epDeclarationFile.getName() + ")");
        builder2.br();
        if (DomUtil.hasXml(extensionPoint.getBeanClass())) {
            builder2.append(ExtensionPointDocumentationProvider.generateClassLink((PsiClass)extensionPoint.getBeanClass().getValue()));
            builder2.br();
        }
        PsiClass extensionPointClass = extensionPoint.getExtensionPointClass();
        builder2.append(ExtensionPointDocumentationProvider.generateClassLink(extensionPointClass));
        return builder2.toString();
    }

    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        ExtensionPoint extensionPoint = ExtensionPointDocumentationProvider.findExtensionPoint(element);
        if (extensionPoint == null) {
            return null;
        }
        HtmlBuilder defBuilder = new HtmlBuilder();
        defBuilder.append((HtmlChunk)HtmlChunk.text((String)extensionPoint.getEffectiveQualifiedName()).bold());
        defBuilder.br().append(DomUtil.getFile((DomElement)extensionPoint).getName());
        PsiClass beanClass = (PsiClass)extensionPoint.getBeanClass().getValue();
        if (beanClass != null) {
            defBuilder.append(ExtensionPointDocumentationProvider.generateClassDoc((PsiElement)beanClass));
            final HtmlBuilder bindingRows = new HtmlBuilder();
            new ExtensionPointBinding(beanClass).visit(new ExtensionPointBinding.BindingVisitor(){

                @Override
                public void visitAttribute(@NotNull PsiField field, @NotNull String attributeName, ExtensionPointBinding.BindingVisitor.RequiredFlag required) {
                    if (field == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (attributeName == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.appendFieldBindingText(field, attributeName, required);
                }

                @Override
                public void visitTagOrProperty(@NotNull PsiField field, @NotNull String tagName, ExtensionPointBinding.BindingVisitor.RequiredFlag required) {
                    if (field == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (tagName == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    this.visitAttribute(field, "<" + tagName + ">", required);
                }

                @Override
                public void visitXCollection(@NotNull PsiField field, @Nullable String tagName, @NotNull PsiAnnotation collectionAnnotation, ExtensionPointBinding.BindingVisitor.RequiredFlag required) {
                    if (field == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (collectionAnnotation == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    this.visitAttribute(field, "<" + tagName + ">...", required);
                }

                private void appendFieldBindingText(@NotNull PsiField field, @NotNull @NlsSafe String displayName, ExtensionPointBinding.BindingVisitor.RequiredFlag required) {
                    if (field == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    if (displayName == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    HtmlChunk hyperLink = ExtensionPointDocumentationProvider.createLink(JavaDocUtil.getReferenceText((Project)field.getProject(), (PsiElement)field), displayName);
                    String typeText = field.getType().getPresentableText();
                    Object requiredText = "";
                    if (required == ExtensionPointBinding.BindingVisitor.RequiredFlag.REQUIRED) {
                        requiredText = " " + DevKitBundle.message("extension.point.documentation.field.required.suffix", new Object[0]);
                    } else if (required == ExtensionPointBinding.BindingVisitor.RequiredFlag.REQUIRED_ALLOW_EMPTY) {
                        requiredText = " " + DevKitBundle.message("extension.point.documentation.field.required.can.be.empty.suffix", new Object[0]);
                    }
                    String initializer = field.getInitializer() != null ? " = " + field.getInitializer().getText() : "";
                    bindingRows.append(ExtensionPointDocumentationProvider.createSectionRow(hyperLink, typeText + (String)requiredText + initializer));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "field";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "attributeName";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "tagName";
                            break;
                        }
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "collectionAnnotation";
                            break;
                        }
                        case 7: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "displayName";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/idea/devkit/references/extensions/ExtensionPointDocumentationProvider$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitAttribute";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitTagOrProperty";
                            break;
                        }
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitXCollection";
                            break;
                        }
                        case 6: 
                        case 7: {
                            objectArray = objectArray2;
                            objectArray2[2] = "appendFieldBindingText";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (!bindingRows.isEmpty()) {
                defBuilder.append((HtmlChunk)bindingRows.br().wrapWith(DocumentationMarkup.SECTIONS_TABLE));
            }
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.append((HtmlChunk)defBuilder.wrapWith("pre").wrapWith(DocumentationMarkup.DEFINITION_ELEMENT));
        HtmlBuilder platformExplorerLink = new HtmlBuilder();
        platformExplorerLink.appendLink("https://jb.gg/ipe?extensions=" + extensionPoint.getEffectiveQualifiedName(), DevKitBundle.message("extension.point.documentation.link.platform.explorer", new Object[0]));
        builder2.append((HtmlChunk)platformExplorerLink.wrapWith(DocumentationMarkup.CONTENT_ELEMENT));
        PsiClass extensionPointClass = extensionPoint.getExtensionPointClass();
        if (extensionPointClass != null) {
            HtmlBuilder content = new HtmlBuilder();
            content.append((HtmlChunk)HtmlChunk.text((String)DevKitBundle.message("extension.point.documentation.implementation.section", new Object[0])).wrapWith("h2"));
            content.append(ExtensionPointDocumentationProvider.generateClassDoc((PsiElement)extensionPointClass));
            builder2.append((HtmlChunk)content.wrapWith(DocumentationMarkup.CONTENT_ELEMENT));
        }
        return builder2.toString();
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return JavaDocUtil.findReferenceTarget((PsiManager)psiManager, (String)link, (PsiElement)context);
    }

    private static HtmlChunk generateClassLink(@Nullable PsiClass epClass) {
        if (epClass == null) {
            return HtmlChunk.empty();
        }
        return ExtensionPointDocumentationProvider.createLink(epClass.getQualifiedName(), epClass.getName());
    }

    private static HtmlChunk createLink(String refText, @Nls String label) {
        HtmlChunk.Element text2 = HtmlChunk.text((String)label).wrapWith("code");
        String link = "psi_element://" + refText;
        return HtmlChunk.link((String)link, (HtmlChunk)text2);
    }

    private static HtmlChunk generateClassDoc(@NotNull PsiElement element) {
        if (element == null) {
            ExtensionPointDocumentationProvider.$$$reportNull$$$0(0);
        }
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)element);
        return HtmlChunk.raw((String)StringUtil.notNullize((String)documentationProvider.generateDoc(element, null)));
    }

    private static HtmlChunk createSectionRow(HtmlChunk sectionName, @Nls String sectionContent) {
        HtmlChunk.Element headerCell = DocumentationMarkup.SECTION_HEADER_CELL.child((HtmlChunk)sectionName.wrapWith("p"));
        HtmlChunk.Element contentCell = DocumentationMarkup.SECTION_CONTENT_CELL.addText(sectionContent);
        return HtmlChunk.tag((String)"tr").children(new HtmlChunk[]{headerCell, contentCell});
    }

    @Nullable
    private static ExtensionPoint findExtensionPoint(PsiElement element) {
        if ((element instanceof PomTargetPsiElement || element instanceof XmlTag) && DescriptorUtil.isPluginXml(element.getContainingFile())) {
            return ExtensionPoint.resolveFromDeclaration(element);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/references/extensions/ExtensionPointDocumentationProvider", "generateClassDoc"));
    }
}

