/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.ActionContainer;
import org.jetbrains.idea.devkit.dom.Actions;
import org.jetbrains.idea.devkit.dom.ApplicationComponents;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.Group;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.Listeners;
import org.jetbrains.idea.devkit.dom.ModuleComponents;
import org.jetbrains.idea.devkit.dom.ProjectComponents;
import org.jetbrains.idea.devkit.dom.index.RegistrationEntry;

class RegistrationIndexer {
    private final IdeaPlugin myPlugin;
    private final Map<String, List<RegistrationEntry>> myValueMap = FactoryMap.create(s -> new SmartList());

    RegistrationIndexer(IdeaPlugin plugin) {
        this.myPlugin = plugin;
    }

    @NotNull
    Map<String, List<RegistrationEntry>> indexFile() {
        this.process(this.myPlugin);
        Map<String, List<RegistrationEntry>> map = this.myValueMap;
        if (map == null) {
            RegistrationIndexer.$$$reportNull$$$0(0);
        }
        return map;
    }

    private void process(IdeaPlugin ideaPlugin) {
        this.processActions(ideaPlugin);
        this.processComponents(RegistrationEntry.RegistrationType.APPLICATION_COMPONENT, ideaPlugin.getApplicationComponents(), ApplicationComponents::getComponents);
        this.processComponents(RegistrationEntry.RegistrationType.PROJECT_COMPONENT, ideaPlugin.getProjectComponents(), ProjectComponents::getComponents);
        this.processComponents(RegistrationEntry.RegistrationType.MODULE_COMPONENT, ideaPlugin.getModuleComponents(), ModuleComponents::getComponents);
        this.processListeners(RegistrationEntry.RegistrationType.APPLICATION_LISTENER, ideaPlugin.getApplicationListeners());
        this.processListeners(RegistrationEntry.RegistrationType.PROJECT_LISTENER, ideaPlugin.getProjectListeners());
    }

    private <T extends DomElement, U extends Component> void processComponents(RegistrationEntry.RegistrationType componentType, List<T> componentContainer, Function<T, List<? extends U>> componentGetter) {
        this.processElements(componentType, componentContainer, componentGetter, Component::getImplementationClass, Component::getHeadlessImplementationClass);
        this.processElements(RegistrationEntry.RegistrationType.COMPONENT_INTERFACE, componentContainer, componentGetter, Component::getInterfaceClass);
    }

    private void processListeners(RegistrationEntry.RegistrationType listenerType, List<Listeners> listenerContainer) {
        this.processElements(listenerType, listenerContainer, Listeners::getListeners, Listeners.Listener::getListenerClassName);
        this.processElements(RegistrationEntry.RegistrationType.LISTENER_TOPIC, listenerContainer, Listeners::getListeners, Listeners.Listener::getTopicClassName);
    }

    private <T extends DomElement, U extends DomElement> void processElements(RegistrationEntry.RegistrationType type2, List<T> elementContainer, Function<T, List<? extends U>> elementGetter, Function<U, GenericDomValue<PsiClass>> ... psiClassGetters) {
        for (DomElement wrapper : elementContainer) {
            for (DomElement element : (List)elementGetter.fun((Object)wrapper)) {
                for (Function<U, GenericDomValue<PsiClass>> psiClassGetter : psiClassGetters) {
                    this.addEntry(element, (GenericDomValue<PsiClass>)((GenericDomValue)psiClassGetter.fun((Object)element)), type2);
                }
            }
        }
    }

    private void processActions(IdeaPlugin ideaPlugin) {
        for (Actions actions : ideaPlugin.getActions()) {
            this.processActionContainer(actions);
        }
    }

    private void processActionContainer(ActionContainer actionContainer) {
        for (Action action : actionContainer.getActions()) {
            this.addEntry(action, (GenericDomValue<PsiClass>)action.getClazz(), RegistrationEntry.RegistrationType.ACTION);
            this.addIdEntry(action, action.getId(), RegistrationEntry.RegistrationType.ACTION_ID);
        }
        for (Group group : actionContainer.getGroups()) {
            this.addEntry(group, (GenericDomValue<PsiClass>)group.getClazz(), RegistrationEntry.RegistrationType.ACTION);
            this.addIdEntry(group, (GenericAttributeValue<String>)group.getId(), RegistrationEntry.RegistrationType.ACTION_GROUP_ID);
            this.processActionContainer(group);
        }
    }

    private void addIdEntry(DomElement domElement, GenericAttributeValue<String> idValue, RegistrationEntry.RegistrationType type2) {
        if (!DomUtil.hasXml((DomElement)domElement)) {
            return;
        }
        String id = idValue.getStringValue();
        if (StringUtil.isEmptyOrSpaces((String)id)) {
            return;
        }
        this.storeEntry(id, domElement, type2);
    }

    private void addEntry(DomElement domElement, GenericDomValue<PsiClass> clazzValue, RegistrationEntry.RegistrationType type2) {
        if (!DomUtil.hasXml(clazzValue)) {
            return;
        }
        String clazz = clazzValue.getStringValue();
        if (StringUtil.isEmptyOrSpaces((String)clazz)) {
            return;
        }
        String className = clazz.replace('$', '.');
        this.storeEntry(className, domElement, type2);
    }

    private void storeEntry(String key, DomElement domElement, RegistrationEntry.RegistrationType type2) {
        List<RegistrationEntry> entries = this.myValueMap.get(key);
        XmlElement xmlElement = domElement.getXmlElement();
        assert (xmlElement != null) : domElement;
        RegistrationEntry entry = new RegistrationEntry(type2, xmlElement.getTextOffset());
        entries.add(entry);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/index/RegistrationIndexer", "indexFile"));
    }
}

