/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.Listeners;
import org.jetbrains.idea.devkit.dom.index.PluginXmlIndexBase;
import org.jetbrains.idea.devkit.dom.index.RegistrationEntry;
import org.jetbrains.idea.devkit.dom.index.RegistrationIndexer;

public class IdeaPluginRegistrationIndex
extends PluginXmlIndexBase<String, List<RegistrationEntry>> {
    private static final int INDEX_VERSION = 8;
    private static final ID<String, List<RegistrationEntry>> NAME = ID.create((String)"IdeaPluginRegistrationIndex");
    private final DataExternalizer<List<RegistrationEntry>> myValueExternalizer = new DataExternalizer<List<RegistrationEntry>>(){

        public void save(@NotNull DataOutput out, List<RegistrationEntry> values) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            DataInputOutputUtilRt.writeSeq((DataOutput)out, values, entry -> {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)entry.getRegistrationType().ordinal());
                DataInputOutputUtil.writeINT((DataOutput)out, (int)entry.getOffset());
            });
        }

        public List<RegistrationEntry> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return DataInputOutputUtilRt.readSeq((DataInput)in, () -> {
                RegistrationEntry.RegistrationType type2 = RegistrationEntry.RegistrationType.values()[DataInputOutputUtil.readINT((DataInput)in)];
                int offset = DataInputOutputUtil.readINT((DataInput)in);
                return new RegistrationEntry(type2, offset);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/devkit/dom/index/IdeaPluginRegistrationIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public ID<String, List<RegistrationEntry>> getName() {
        ID<String, List<RegistrationEntry>> iD = NAME;
        if (iD == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    protected Map<String, List<RegistrationEntry>> performIndexing(IdeaPlugin plugin) {
        return new RegistrationIndexer(plugin).indexFile();
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(1);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<List<RegistrationEntry>> getValueExternalizer() {
        DataExternalizer<List<RegistrationEntry>> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(2);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 8;
    }

    public static boolean isRegisteredClass(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, null);
    }

    public static boolean isRegisteredComponentInterface(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.COMPONENT_INTERFACE);
    }

    public static boolean isRegisteredApplicationComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.APPLICATION_COMPONENT);
    }

    public static boolean isRegisteredProjectComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.PROJECT_COMPONENT);
    }

    public static boolean isRegisteredModuleComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.MODULE_COMPONENT);
    }

    public static boolean isRegisteredActionOrGroup(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.ACTION);
    }

    public static boolean isRegisteredListenerTopic(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.LISTENER_TOPIC);
    }

    public static boolean processComponent(Project project, PsiClass componentInterfaceOrImplementationClass, GlobalSearchScope scope, Processor<? super Component> processor) {
        String key = componentInterfaceOrImplementationClass.getQualifiedName();
        assert (key != null) : componentInterfaceOrImplementationClass;
        return IdeaPluginRegistrationIndex.processAll(project, key, scope, EnumSet.of(RegistrationEntry.RegistrationType.APPLICATION_COMPONENT, RegistrationEntry.RegistrationType.PROJECT_COMPONENT, RegistrationEntry.RegistrationType.MODULE_COMPONENT, RegistrationEntry.RegistrationType.COMPONENT_INTERFACE), Component.class, processor);
    }

    public static boolean processListener(@NotNull Project project, PsiClass listenerClass, GlobalSearchScope scope, Processor<? super Listeners.Listener> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(3);
        }
        return IdeaPluginRegistrationIndex.doProcessListener(project, listenerClass, scope, EnumSet.of(RegistrationEntry.RegistrationType.APPLICATION_LISTENER, RegistrationEntry.RegistrationType.PROJECT_LISTENER), processor);
    }

    public static boolean processListenerTopic(@NotNull Project project, PsiClass topicClass, GlobalSearchScope scope, Processor<? super Listeners.Listener> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(4);
        }
        return IdeaPluginRegistrationIndex.doProcessListener(project, topicClass, scope, EnumSet.of(RegistrationEntry.RegistrationType.LISTENER_TOPIC), processor);
    }

    private static boolean doProcessListener(@NotNull Project project, PsiClass psiClass, GlobalSearchScope scope, EnumSet<RegistrationEntry.RegistrationType> types, Processor<? super Listeners.Listener> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(5);
        }
        String key = psiClass.getQualifiedName();
        assert (key != null) : psiClass;
        return IdeaPluginRegistrationIndex.processAll(project, key, scope, types, Listeners.Listener.class, processor);
    }

    private static boolean isRegisteredClass(PsiClass psiClass, GlobalSearchScope scope, @Nullable RegistrationEntry.RegistrationType type2) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        return !FileBasedIndex.getInstance().processValues(NAME, (Object)qualifiedName, null, (file, value) -> ContainerUtil.process((List)value, entry -> {
            RegistrationEntry.RegistrationType registrationType = entry.getRegistrationType();
            if (type2 == null) {
                return !registrationType.isClass();
            }
            return registrationType != type2;
        }), scope);
    }

    public static boolean processAllActionOrGroup(@NotNull Project project, GlobalSearchScope scope, Processor<? super ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(6);
        }
        HashSet keys = new HashSet();
        FileBasedIndex.getInstance().processAllKeys(NAME, s -> keys.add(s), scope, null);
        return ContainerUtil.process(keys, s -> IdeaPluginRegistrationIndex.processActionOrGroup(project, s, scope, processor));
    }

    public static boolean processActionOrGroupClass(@NotNull Project project, PsiClass actionOrGroupClass, GlobalSearchScope scope, Processor<? super ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(7);
        }
        String fqn = actionOrGroupClass.getQualifiedName();
        assert (fqn != null) : actionOrGroupClass;
        return IdeaPluginRegistrationIndex.doProcessActionOrGroup(project, fqn, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION), processor);
    }

    public static boolean processActionOrGroup(@NotNull Project project, @NotNull String actionOrGroupId, GlobalSearchScope scope, Processor<? super ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(8);
        }
        if (actionOrGroupId == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(9);
        }
        return IdeaPluginRegistrationIndex.doProcessActionOrGroup(project, actionOrGroupId, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION_ID, RegistrationEntry.RegistrationType.ACTION_GROUP_ID), processor);
    }

    public static boolean processAction(@NotNull Project project, @NotNull String actionId, GlobalSearchScope scope, Processor<? super ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(10);
        }
        if (actionId == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(11);
        }
        return IdeaPluginRegistrationIndex.doProcessActionOrGroup(project, actionId, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION_ID), processor);
    }

    public static boolean processGroup(@NotNull Project project, @NotNull String actionGroupId, GlobalSearchScope scope, Processor<? super ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(12);
        }
        if (actionGroupId == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(13);
        }
        return IdeaPluginRegistrationIndex.doProcessActionOrGroup(project, actionGroupId, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION_GROUP_ID), processor);
    }

    private static boolean doProcessActionOrGroup(@NotNull Project project, @NotNull String key, GlobalSearchScope scope, EnumSet<RegistrationEntry.RegistrationType> types, Processor<? super ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(14);
        }
        if (key == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(15);
        }
        return IdeaPluginRegistrationIndex.processAll(project, key, scope, types, ActionOrGroup.class, processor);
    }

    private static <T extends DomElement> boolean processAll(@NotNull Project project, @NotNull String key, GlobalSearchScope scope, EnumSet<RegistrationEntry.RegistrationType> types, Class<T> domClazz, Processor<? super T> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(16);
        }
        if (key == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(17);
        }
        List<XmlTag> tags = IdeaPluginRegistrationIndex.collectTags(project, key, scope, types);
        return ContainerUtil.process(tags, tag -> {
            DomElement domElement = DomManager.getDomManager((Project)project).getDomElement(tag);
            DomElement t = (DomElement)DomUtil.getParentOfType((DomElement)domElement, (Class)domClazz, (boolean)false);
            if (t == null) {
                return true;
            }
            return processor.process((Object)domElement);
        });
    }

    @NotNull
    private static List<XmlTag> collectTags(@NotNull Project project, @NotNull String key, GlobalSearchScope scope, EnumSet<RegistrationEntry.RegistrationType> types) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(18);
        }
        if (key == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(19);
        }
        SmartList tags = new SmartList();
        FileBasedIndex.getInstance().processValues(NAME, (Object)key, null, (arg_0, arg_1) -> IdeaPluginRegistrationIndex.lambda$collectTags$5(types, project, (List)tags, arg_0, arg_1), scope);
        SmartList smartList = tags;
        if (smartList == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(20);
        }
        return smartList;
    }

    private static /* synthetic */ boolean lambda$collectTags$5(EnumSet types, Project project, List tags, VirtualFile file, List value) {
        for (RegistrationEntry entry : value) {
            PsiFile psiFile;
            if (!types.contains((Object)entry.getRegistrationType()) || !((psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof XmlFile)) continue;
            PsiElement psiElement = psiFile.findElementAt(entry.getOffset());
            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class, (boolean)false);
            tags.add(xmlTag);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/index/IdeaPluginRegistrationIndex";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionOrGroupId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroupId";
                break;
            }
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/index/IdeaPluginRegistrationIndex";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTags";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processListenerTopic";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doProcessListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processAllActionOrGroup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processActionOrGroupClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processActionOrGroup";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processAction";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processGroup";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doProcessActionOrGroup";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectTags";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

