/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.generator;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtilRt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.generator.NamespaceDesc;

public class DomGenPanel {
    private JPanel mainPanel;
    private JTextField myNamespace;
    private JTextField mySuperClass;
    private TextFieldWithBrowseButton mySchemaLocation;
    private JTextField myPackage;
    private TextFieldWithBrowseButton myOutputDir;
    private JTextArea mySkipSchemas;
    private JTextField myAuthor;
    private JBCheckBox myUseQualifiedClassNames;
    private final Project myProject;
    @NonNls
    private static final String PREFIX = "DomGenPanel.";

    public DomGenPanel(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        this.mySchemaLocation = new TextFieldWithBrowseButton();
        this.mySchemaLocation.addBrowseFolderListener(DevKitBundle.message("dom.generator.dialog.choose.scheme.label", new Object[0]), DevKitBundle.message("dom.generator.dialog.folder.browser.description", new Object[0]), this.myProject, (FileChooserDescriptor)new FileTypeDescriptor(DevKitBundle.message("dom.generator.dialog.choose.scheme.label", new Object[0]), new String[]{"xsd", "dtd"}));
        this.mySchemaLocation.getTextField().setEditable(false);
        this.mySchemaLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlTag rootTag;
                XmlDocument xml;
                PsiFile psiFile;
                VirtualFile vf;
                File file = new File(DomGenPanel.this.mySchemaLocation.getText());
                if (file.exists() && StringUtil.toLowerCase((String)file.getName()).endsWith(".xsd") && (vf = LocalFileSystem.getInstance().findFileByIoFile(file)) != null && (psiFile = PsiManager.getInstance((Project)DomGenPanel.this.myProject).findFile(vf)) instanceof XmlFile && (xml = ((XmlFile)psiFile).getDocument()) != null && (rootTag = xml.getRootTag()) != null) {
                    String target = null;
                    ArrayList<String> ns = new ArrayList<String>();
                    for (XmlAttribute attr : rootTag.getAttributes()) {
                        if ("targetNamespace".equals(attr.getName())) {
                            target = attr.getValue();
                            continue;
                        }
                        if (!attr.getName().startsWith("xmlns")) continue;
                        ns.add(attr.getValue());
                    }
                    ns.remove(target);
                    if (target != null) {
                        DomGenPanel.this.myNamespace.setText(target);
                    }
                    DomGenPanel.this.mySkipSchemas.setText(StringUtil.join((String[])ArrayUtilRt.toStringArray(ns), (String)"\n"));
                }
            }
        });
        this.myOutputDir = new TextFieldWithBrowseButton();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myOutputDir.addBrowseFolderListener(DevKitBundle.message("dom.generator.dialog.folder.output", new Object[0]), "", this.myProject, descriptor);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public NamespaceDesc getNamespaceDescriptor() {
        return new NamespaceDesc(this.myNamespace.getText().trim(), this.myPackage.getText().trim(), this.mySuperClass.getText().trim(), "", null, null, null, null);
    }

    public String getLocation() {
        return this.mySchemaLocation.getText();
    }

    public String getOutputDir() {
        return this.myOutputDir.getText();
    }

    public void restore() {
        this.myNamespace.setText(DomGenPanel.getValue("namespace", ""));
        this.myPackage.setText(DomGenPanel.getValue("package", "com.intellij.myframework.model"));
        this.mySchemaLocation.setText(DomGenPanel.getValue("schemaLocation", ""));
        this.mySuperClass.setText(DomGenPanel.getValue("superClass", "com.intellij.util.xml.DomElement"));
        this.myOutputDir.setText(DomGenPanel.getValue("output", ""));
        this.mySkipSchemas.setText(DomGenPanel.getValue("skipSchemas", "http://www.w3.org/2001/XMLSchema\nhttp://www.w3.org/2001/XMLSchema-instance"));
        this.myAuthor.setText(DomGenPanel.getValue("author", ""));
        this.myUseQualifiedClassNames.setSelected(DomGenPanel.getValue("useFQNs", "false").equals("true"));
    }

    @NonNls
    private static String getValue(@NonNls String name, @NonNls String defaultValue) {
        return PropertiesComponent.getInstance().getValue(PREFIX + name, defaultValue);
    }

    private static void setValue(@NonNls String name, @NonNls String value) {
        PropertiesComponent.getInstance().setValue(PREFIX + name, value);
    }

    public void saveAll() {
        DomGenPanel.setValue("namespace", this.myNamespace.getText());
        DomGenPanel.setValue("package", this.myPackage.getText());
        DomGenPanel.setValue("schemaLocation", this.mySchemaLocation.getText());
        DomGenPanel.setValue("superClass", this.mySuperClass.getText());
        DomGenPanel.setValue("output", this.myOutputDir.getText());
        DomGenPanel.setValue("skipSchemas", this.mySkipSchemas.getText());
        DomGenPanel.setValue("author", this.myAuthor.getText());
        DomGenPanel.setValue("useFQNs", this.myUseQualifiedClassNames.isSelected() ? "true" : "false");
    }

    public boolean validate() {
        if (!new File(this.mySchemaLocation.getText()).exists()) {
            Messages.showErrorDialog((Project)this.myProject, (String)DevKitBundle.message("dom.generator.dialog.error.schema.not.exist", new Object[0]), (String)CommonBundle.getErrorTitle());
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.mySchemaLocation, true);
            return false;
        }
        if (!new File(this.myOutputDir.getText()).exists()) {
            Messages.showErrorDialog((Project)this.myProject, (String)DevKitBundle.message("dom.generator.dialog.error.output.not.exist", new Object[0]), (String)CommonBundle.getErrorTitle());
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myOutputDir, true);
            return false;
        }
        return true;
    }

    public String[] getSkippedSchemas() {
        String schemes = this.mySkipSchemas.getText().replaceAll("\r\n", "\n").trim();
        if (schemes.length() > 0) {
            return schemes.split("\n");
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public String getAuthor() {
        return this.myAuthor.getText();
    }

    public boolean isUseQualifiedClassNames() {
        return this.myUseQualifiedClassNames.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JPanel jPanel;
        this.createUIComponents();
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/DevKitBundle", DomGenPanel.class).getString("dom.generator.dialog.label.form.title"), (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DevKitBundle", DomGenPanel.class).getString("dom.generator.dialog.label.namespace"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DevKitBundle", DomGenPanel.class).getString("dom.generator.dialog.label.super.class"));
        jPanel.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySuperClass = jTextField4 = new JTextField();
        jTextField4.setText("com.intellij.util.xml.DomElement");
        jPanel.add((Component)jTextField4, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(327, 22), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/DevKitBundle", DomGenPanel.class).getString("dom.generator.dialog.label.package"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackage = jTextField3 = new JTextField();
        jTextField3.setText("com.intellij.myFramework.model");
        jPanel.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(327, 22), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/DevKitBundle", DomGenPanel.class).getString("dom.generator.dialog.label.output.directory"));
        jPanel.add((Component)jLabel4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myOutputDir;
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(327, 22), null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.mySchemaLocation;
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(327, 22), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/DevKitBundle", DomGenPanel.class).getString("dom.generator.dialog.label.scheme.file"));
        jPanel.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNamespace = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(327, 22), null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/DevKitBundle", DomGenPanel.class).getString("dom.generator.dialog.label.skip.schemes"));
        jPanel.add((Component)jLabel6, new GridConstraints(7, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/DevKitBundle", DomGenPanel.class).getString("dom.generator.dialog.label.javadoc.author"));
        jPanel.add((Component)jLabel7, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAuthor = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myUseQualifiedClassNames = jBCheckBox = new JBCheckBox();
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, DynamicBundle.getBundle((String)"messages/DevKitBundle", DomGenPanel.class).getString("dom.generator.dialog.label.use.fqn"));
        jLabel8.setToolTipText(ResourceBundle.getBundle("messages/DevKitBundle").getString("dom.generator.dialog.label.use.fqn.tooltip"));
        jPanel.add((Component)jLabel8, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(7, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(150, 50), null));
        this.mySkipSchemas = jTextArea = new JTextArea();
        jBScrollPane.setViewportView(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

