/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.devkit.workspaceModel;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.workspaceModel.storage.GeneratedCodeApiVersion;
import com.intellij.workspaceModel.storage.GeneratedCodeImplVersion;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.deft.annotations.Abstract;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parsing.ParseUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.ValueArgument;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0013\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u0003\u001a\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u0003\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0006*\u00020\u0002H\u0000\u00a8\u0006\b"}, d2={"getApiVersion", "", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Lorg/jetbrains/kotlin/psi/KtClass;)Ljava/lang/Integer;", "getImplVersion", "isAbstractEntity", "", "isWorkspaceEntity", "intellij.devkit.workspaceModel"})
public final class WorkspaceKtClassExtentionsKt {
    public static final boolean isWorkspaceEntity(@NotNull KtClass $this$isWorkspaceEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$isWorkspaceEntity, (String)"$this$isWorkspaceEntity");
        if (!$this$isWorkspaceEntity.isInterface()) {
            return false;
        }
        LinkedList<KtSuperTypeListEntry> superTypeList = new LinkedList<KtSuperTypeListEntry>();
        superTypeList.addAll($this$isWorkspaceEntity.getSuperTypeListEntries());
        while (!superTypeList.isEmpty()) {
            KtClass resolvedKtClass;
            PsiElement psiElement;
            KtUserType ktUserType;
            KtSuperTypeListEntry superType;
            KtSuperTypeListEntry ktSuperTypeListEntry = superType = (KtSuperTypeListEntry)superTypeList.pop();
            Intrinsics.checkNotNullExpressionValue((Object)ktSuperTypeListEntry, (String)"superType");
            KtTypeReference ktTypeReference = ktSuperTypeListEntry.getTypeReference();
            Object object = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
            if (!(object instanceof KtUserType)) {
                object = null;
            }
            if (!(((ktUserType = (KtUserType)object) != null && (ktUserType = ktUserType.getReferenceExpression()) != null && (ktUserType = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ktUserType)) != null ? ktUserType.resolve() : (psiElement = null)) instanceof KtClass)) {
                psiElement = null;
            }
            if ((KtClass)psiElement == null) {
                continue;
            }
            FqName fqName = resolvedKtClass.getFqName();
            if (Intrinsics.areEqual((Object)(fqName != null ? fqName.asString() : null), (Object)Reflection.getOrCreateKotlinClass(WorkspaceEntity.class).getQualifiedName())) {
                return true;
            }
            Iterable $this$forEach$iv = resolvedKtClass.getSuperTypeListEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
                boolean bl = false;
                superTypeList.push(it);
            }
        }
        return false;
    }

    public static final boolean isAbstractEntity(@NotNull KtClass $this$isAbstractEntity) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isAbstractEntity, (String)"$this$isAbstractEntity");
            String annotationName = Reflection.getOrCreateKotlinClass(Abstract.class).getSimpleName();
            List list2 = $this$isAbstractEntity.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"annotationEntries");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl2 = false;
                    KtAnnotationEntry ktAnnotationEntry = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"it");
                    Name name = ktAnnotationEntry.getShortName();
                    if (!Intrinsics.areEqual((Object)(name != null ? name.getIdentifier() : null), (Object)annotationName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final Integer getApiVersion(@NotNull KtClass $this$getApiVersion) {
        KtConstantExpression argumentExpression;
        Object v3;
        Object object;
        Object object2;
        String annotationName;
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$getApiVersion, (String)"$this$getApiVersion");
            annotationName = Reflection.getOrCreateKotlinClass(GeneratedCodeApiVersion.class).getSimpleName();
            List list2 = $this$getApiVersion.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"annotationEntries");
            object = object2 = (Iterable)list2;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                KtAnnotationEntry it = (KtAnnotationEntry)t;
                boolean bl = false;
                KtAnnotationEntry ktAnnotationEntry = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"it");
                Name name = ktAnnotationEntry.getShortName();
                if (!Intrinsics.areEqual((Object)(name != null ? name.getIdentifier() : null), (Object)annotationName)) continue;
                v3 = t;
                break block6;
            }
            v3 = null;
        }
        KtAnnotationEntry annotation = v3;
        if (annotation == null) {
            object2 = $this$getApiVersion.getName() + " should contain " + annotationName;
            throw new IllegalStateException(object2.toString());
        }
        if (annotation.getValueArguments().size() != 1) {
            object2 = "Annotation " + annotationName + " at " + $this$getApiVersion.getName() + " should contain only one argument";
            throw new IllegalStateException(object2.toString());
        }
        KtExpression ktExpression = ((ValueArgument)annotation.getValueArguments().get(0)).getArgumentExpression();
        if (!(ktExpression instanceof KtConstantExpression)) {
            ktExpression = null;
        }
        if ((argumentExpression = (KtConstantExpression)ktExpression) == null) {
            object = "Annotation parameter should be int constant";
            throw new IllegalStateException(object.toString());
        }
        ASTNode aSTNode = argumentExpression.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"argumentExpression.node");
        IElementType iElementType = aSTNode.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"argumentExpression.node.elementType");
        IElementType elementType = iElementType;
        if (Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.INTEGER_CONSTANT)) {
            String string = argumentExpression.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"argumentExpression.text");
            Number number = ParseUtilsKt.parseNumericLiteral((String)string, (IElementType)elementType);
            return number != null ? Integer.valueOf(number.intValue()) : null;
        }
        return null;
    }

    @Nullable
    public static final Integer getImplVersion(@NotNull KtClass $this$getImplVersion) {
        KtConstantExpression argumentExpression;
        Object v3;
        Object object;
        Object object2;
        String annotationName;
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$getImplVersion, (String)"$this$getImplVersion");
            annotationName = Reflection.getOrCreateKotlinClass(GeneratedCodeImplVersion.class).getSimpleName();
            List list2 = $this$getImplVersion.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"annotationEntries");
            object = object2 = (Iterable)list2;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                KtAnnotationEntry it = (KtAnnotationEntry)t;
                boolean bl = false;
                KtAnnotationEntry ktAnnotationEntry = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"it");
                Name name = ktAnnotationEntry.getShortName();
                if (!Intrinsics.areEqual((Object)(name != null ? name.getIdentifier() : null), (Object)annotationName)) continue;
                v3 = t;
                break block6;
            }
            v3 = null;
        }
        KtAnnotationEntry annotation = v3;
        if (annotation == null) {
            object2 = $this$getImplVersion.getName() + " should contain " + annotationName;
            throw new IllegalStateException(object2.toString());
        }
        if (annotation.getValueArguments().size() != 1) {
            object2 = "Annotation " + annotationName + " at " + $this$getImplVersion.getName() + " should contain only one argument";
            throw new IllegalStateException(object2.toString());
        }
        KtExpression ktExpression = ((ValueArgument)annotation.getValueArguments().get(0)).getArgumentExpression();
        if (!(ktExpression instanceof KtConstantExpression)) {
            ktExpression = null;
        }
        if ((argumentExpression = (KtConstantExpression)ktExpression) == null) {
            object = "Annotation parameter should be int constant";
            throw new IllegalStateException(object.toString());
        }
        ASTNode aSTNode = argumentExpression.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"argumentExpression.node");
        IElementType iElementType = aSTNode.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"argumentExpression.node.elementType");
        IElementType elementType = iElementType;
        if (Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.INTEGER_CONSTANT)) {
            String string = argumentExpression.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"argumentExpression.text");
            Number number = ParseUtilsKt.parseNumericLiteral((String)string, (IElementType)elementType);
            return number != null ? Integer.valueOf(number.intValue()) : null;
        }
        return null;
    }
}

