/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;

public enum Depth {
    UNKNOWN("unknown"),
    INFINITY("infinity"),
    IMMEDIATES("immediates"),
    FILES("files"),
    EMPTY("empty"),
    EXCLUDE("exclude");

    @NotNull
    private static final Map<String, Depth> ourAllDepths;
    @NonNls
    @NotNull
    private final String myName;

    private Depth(String name) {
        if (name == null) {
            Depth.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @NonNls
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            Depth.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        switch (this) {
            case INFINITY: {
                String string = SvnBundle.message("label.depth.infinity", new Object[0]);
                if (string == null) {
                    Depth.$$$reportNull$$$0(2);
                }
                return string;
            }
            case IMMEDIATES: {
                String string = SvnBundle.message("label.depth.immediates", new Object[0]);
                if (string == null) {
                    Depth.$$$reportNull$$$0(3);
                }
                return string;
            }
            case FILES: {
                String string = SvnBundle.message("label.depth.files", new Object[0]);
                if (string == null) {
                    Depth.$$$reportNull$$$0(4);
                }
                return string;
            }
            case EMPTY: {
                String string = SvnBundle.message("label.depth.empty", new Object[0]);
                if (string == null) {
                    Depth.$$$reportNull$$$0(5);
                }
                return string;
            }
            case EXCLUDE: {
                String string = SvnBundle.message("label.depth.exclude", new Object[0]);
                if (string == null) {
                    Depth.$$$reportNull$$$0(6);
                }
                return string;
            }
        }
        String string = SvnBundle.message("label.depth.unknown", new Object[0]);
        if (string == null) {
            Depth.$$$reportNull$$$0(7);
        }
        return string;
    }

    public String toString() {
        return this.myName;
    }

    private static void register(@NotNull Depth depth) {
        if (depth == null) {
            Depth.$$$reportNull$$$0(8);
        }
        ourAllDepths.put(depth.myName, depth);
    }

    @NotNull
    public static Depth from(@NonNls @NotNull String depthName) {
        Depth result;
        if (depthName == null) {
            Depth.$$$reportNull$$$0(9);
        }
        if ((result = ourAllDepths.get(depthName)) == null) {
            throw new IllegalArgumentException("Unknown depth " + depthName);
        }
        Depth depth = result;
        if (depth == null) {
            Depth.$$$reportNull$$$0(10);
        }
        return depth;
    }

    @NotNull
    public static Depth allOrFiles(boolean recursive) {
        Depth depth = recursive ? INFINITY : FILES;
        if (depth == null) {
            Depth.$$$reportNull$$$0(11);
        }
        return depth;
    }

    @NotNull
    public static Depth allOrEmpty(boolean recursive) {
        Depth depth = recursive ? INFINITY : EMPTY;
        if (depth == null) {
            Depth.$$$reportNull$$$0(12);
        }
        return depth;
    }

    public static boolean isRecursive(@Nullable Depth depth) {
        return depth == null || depth == INFINITY || depth == UNKNOWN;
    }

    static {
        ourAllDepths = new HashMap<String, Depth>();
        for (Depth action : Depth.values()) {
            Depth.register(action);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/api/Depth";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depth";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depthName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/api/Depth";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "allOrFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "allOrEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

